/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compiler.plugin.CliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOptionProcessingException;
import org.jetbrains.kotlin.compiler.plugin.CommandLineProcessor;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.scripting.compiler.plugin.ScriptingCommandLineProcessor;
import org.jetbrains.kotlin.scripting.compiler.plugin.ScriptingConfigurationKeys;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/ScriptingCommandLineProcessor;", "Lorg/jetbrains/kotlin/compiler/plugin/CommandLineProcessor;", "()V", "pluginId", "", "getPluginId", "()Ljava/lang/String;", "pluginOptions", "", "Lorg/jetbrains/kotlin/compiler/plugin/CliOption;", "getPluginOptions", "()Ljava/util/List;", "processOption", "", "option", "value", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "Companion", "kotlin-scripting-compiler"})
public final class ScriptingCommandLineProcessor
implements CommandLineProcessor {
    @NotNull
    private final String pluginId = PLUGIN_ID;
    @NotNull
    private final List<CliOption> pluginOptions = CollectionsKt.listOf((Object[])new CliOption[]{DISABLE_SCRIPTING_PLUGIN_OPTION, SCRIPT_DEFINITIONS_OPTION, SCRIPT_DEFINITIONS_CLASSPATH_OPTION, DISABLE_STANDARD_SCRIPT_DEFINITION_OPTION, DISABLE_SCRIPT_DEFINITIONS_FROM_CLSSPATH_OPTION, LEGACY_SCRIPT_TEMPLATES_OPTION, LEGACY_SCRIPT_RESOLVER_ENVIRONMENT_OPTION});
    @NotNull
    private static final CliOption DISABLE_SCRIPTING_PLUGIN_OPTION;
    @NotNull
    private static final CliOption SCRIPT_DEFINITIONS_OPTION;
    @NotNull
    private static final CliOption SCRIPT_DEFINITIONS_CLASSPATH_OPTION;
    @NotNull
    private static final CliOption DISABLE_STANDARD_SCRIPT_DEFINITION_OPTION;
    @NotNull
    private static final CliOption DISABLE_SCRIPT_DEFINITIONS_FROM_CLSSPATH_OPTION;
    @NotNull
    private static final CliOption LEGACY_SCRIPT_TEMPLATES_OPTION;
    @NotNull
    private static final CliOption LEGACY_SCRIPT_RESOLVER_ENVIRONMENT_OPTION;
    @NotNull
    private static final String PLUGIN_ID = "kotlin.scripting";
    public static final Companion Companion;

    @NotNull
    public String getPluginId() {
        return this.pluginId;
    }

    @NotNull
    public List<CliOption> getPluginOptions() {
        return this.pluginOptions;
    }

    /*
     * WARNING - void declaration
     */
    public void processOption(@NotNull CliOption option, @NotNull String value, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)option, (String)"option");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        CliOption cliOption = option;
        if (Intrinsics.areEqual((Object)cliOption, (Object)DISABLE_SCRIPTING_PLUGIN_OPTION)) {
            boolean bl;
            String string = value;
            CompilerConfigurationKey<Boolean> compilerConfigurationKey = ScriptingConfigurationKeys.INSTANCE.getDISABLE_SCRIPTING_PLUGIN_OPTION();
            CompilerConfiguration compilerConfiguration = configuration;
            String it = string;
            String string2 = !StringsKt.isBlank((CharSequence)it) ? string : null;
            CompilerConfiguration compilerConfiguration2 = compilerConfiguration;
            CompilerConfigurationKey<Boolean> compilerConfigurationKey2 = compilerConfigurationKey;
            String string3 = string2;
            if (string3 != null) {
                string = string3;
                compilerConfigurationKey = compilerConfigurationKey2;
                compilerConfiguration = compilerConfiguration2;
                boolean bl2 = Boolean.parseBoolean(string);
                compilerConfiguration2 = compilerConfiguration;
                compilerConfigurationKey2 = compilerConfigurationKey;
                bl = bl2;
            } else {
                bl = true;
            }
            compilerConfiguration2.put(compilerConfigurationKey2, (Object)bl);
        } else if (Intrinsics.areEqual((Object)cliOption, (Object)SCRIPT_DEFINITIONS_OPTION) || Intrinsics.areEqual((Object)cliOption, (Object)LEGACY_SCRIPT_TEMPLATES_OPTION)) {
            List list = configuration.getList(ScriptingConfigurationKeys.INSTANCE.getSCRIPT_DEFINITIONS());
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"configuration.getList(Sc\u2026nKeys.SCRIPT_DEFINITIONS)");
            List currentDefs = CollectionsKt.toMutableList((Collection)list);
            currentDefs.addAll(StringsKt.split$default((CharSequence)value, (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null));
            configuration.put(ScriptingConfigurationKeys.INSTANCE.getSCRIPT_DEFINITIONS(), (Object)currentDefs);
        } else if (Intrinsics.areEqual((Object)cliOption, (Object)SCRIPT_DEFINITIONS_CLASSPATH_OPTION)) {
            Collection<File> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            List list = configuration.getList(ScriptingConfigurationKeys.INSTANCE.getSCRIPT_DEFINITIONS_CLASSPATH());
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"configuration.getList(Sc\u2026PT_DEFINITIONS_CLASSPATH)");
            List currentCP = CollectionsKt.toMutableList((Collection)list);
            Iterable it = StringsKt.split$default((CharSequence)value, (char[])new char[]{File.pathSeparatorChar}, (boolean)false, (int)0, (int)6, null);
            List list2 = currentCP;
            void $i$a$1$takeUnless = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void p1;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                File file = new File((String)p1);
                collection.add(file);
            }
            collection = (List)destination$iv$iv;
            list2.addAll((Collection)collection);
            configuration.put(ScriptingConfigurationKeys.INSTANCE.getSCRIPT_DEFINITIONS_CLASSPATH(), (Object)currentCP);
        } else if (Intrinsics.areEqual((Object)cliOption, (Object)DISABLE_STANDARD_SCRIPT_DEFINITION_OPTION)) {
            boolean bl;
            String currentCP = value;
            CompilerConfigurationKey compilerConfigurationKey = JVMConfigurationKeys.DISABLE_STANDARD_SCRIPT_DEFINITION;
            CompilerConfiguration compilerConfiguration = configuration;
            String it = currentCP;
            String string = !StringsKt.isBlank((CharSequence)it) ? currentCP : null;
            CompilerConfiguration compilerConfiguration3 = compilerConfiguration;
            CompilerConfigurationKey compilerConfigurationKey3 = compilerConfigurationKey;
            String string4 = string;
            if (string4 != null) {
                currentCP = string4;
                compilerConfigurationKey = compilerConfigurationKey3;
                compilerConfiguration = compilerConfiguration3;
                boolean bl3 = Boolean.parseBoolean(currentCP);
                compilerConfiguration3 = compilerConfiguration;
                compilerConfigurationKey3 = compilerConfigurationKey;
                bl = bl3;
            } else {
                bl = true;
            }
            compilerConfiguration3.put(compilerConfigurationKey3, (Object)bl);
        } else if (Intrinsics.areEqual((Object)cliOption, (Object)DISABLE_SCRIPT_DEFINITIONS_FROM_CLSSPATH_OPTION)) {
            boolean bl;
            String currentCP = value;
            CompilerConfigurationKey<Boolean> compilerConfigurationKey = ScriptingConfigurationKeys.INSTANCE.getDISABLE_SCRIPT_DEFINITIONS_FROM_CLASSPATH_OPTION();
            CompilerConfiguration compilerConfiguration = configuration;
            String it = currentCP;
            String string = !StringsKt.isBlank((CharSequence)it) ? currentCP : null;
            CompilerConfiguration compilerConfiguration4 = compilerConfiguration;
            CompilerConfigurationKey<Boolean> compilerConfigurationKey4 = compilerConfigurationKey;
            String string5 = string;
            if (string5 != null) {
                currentCP = string5;
                compilerConfigurationKey = compilerConfigurationKey4;
                compilerConfiguration = compilerConfiguration4;
                boolean bl4 = Boolean.parseBoolean(currentCP);
                compilerConfiguration4 = compilerConfiguration;
                compilerConfigurationKey4 = compilerConfigurationKey;
                bl = bl4;
            } else {
                bl = true;
            }
            compilerConfiguration4.put(compilerConfigurationKey4, (Object)bl);
        } else if (Intrinsics.areEqual((Object)cliOption, (Object)LEGACY_SCRIPT_RESOLVER_ENVIRONMENT_OPTION)) {
            Map map = configuration.getMap(ScriptingConfigurationKeys.INSTANCE.getLEGACY_SCRIPT_RESOLVER_ENVIRONMENT_OPTION());
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"configuration.getMap(Scr\u2026OLVER_ENVIRONMENT_OPTION)");
            Map currentEnv = MapsKt.toMutableMap((Map)map);
            String $i$a$4$takeUnless = "(\\w+)=(?:\"([^\"\\\\]*(\\\\.[^\"\\\\]*)*)\"|([^\\s]*))";
            Regex envParseRe = new Regex($i$a$4$takeUnless);
            String destination$iv$iv = "\\\\([\"\\\\,])";
            Regex unescapeRe = new Regex(destination$iv$iv);
            String string = "(?:\\\\.|[^,\\\\]++)*";
            Regex splitRe = new Regex(string);
            Sequence splitMatches = Regex.findAll$default((Regex)splitRe, (CharSequence)value, (int)0, (int)2, null);
            for (String envParam : SequencesKt.filter((Sequence)SequencesKt.map((Sequence)splitMatches, (Function1)processOption.5.INSTANCE), (Function1)processOption.6.INSTANCE)) {
                String string6;
                String string7;
                Object v15;
                Object e;
                Map map2;
                block24: {
                    MatchResult match = envParseRe.matchEntire((CharSequence)envParam);
                    if (match == null || match.getGroupValues().size() < 4 || StringsKt.isBlank((CharSequence)((CharSequence)match.getGroupValues().get(1)))) {
                        throw (Throwable)new CliOptionProcessingException("Unable to parse script-resolver-environment argument " + envParam, null, 2, null);
                    }
                    map2 = currentEnv;
                    e = match.getGroupValues().get(1);
                    Iterable $receiver$iv = CollectionsKt.drop((Iterable)match.getGroupValues(), (int)2);
                    for (Object element$iv : $receiver$iv) {
                        String it = (String)element$iv;
                        CharSequence charSequence = it;
                        if (!(charSequence.length() > 0)) continue;
                        v15 = element$iv;
                        break block24;
                    }
                    v15 = null;
                }
                String string8 = v15;
                if (string8 != null) {
                    String it = string7 = string8;
                    string6 = unescapeRe.replace((CharSequence)it, "$1");
                } else {
                    string6 = null;
                }
                string7 = string6;
                map2.put(e, string7);
            }
            configuration.put(ScriptingConfigurationKeys.INSTANCE.getLEGACY_SCRIPT_RESOLVER_ENVIRONMENT_OPTION(), (Object)currentEnv);
        } else {
            throw (Throwable)new CliOptionProcessingException("Unknown option: " + option.getName(), null, 2, null);
        }
    }

    static {
        Companion = new Companion(null);
        DISABLE_SCRIPTING_PLUGIN_OPTION = new CliOption("disable", "true/false", "Disable scripting plugin", false, false);
        SCRIPT_DEFINITIONS_OPTION = new CliOption("script-definitions", "<fully qualified class name[,]>", "Script definition classes", false, true);
        SCRIPT_DEFINITIONS_CLASSPATH_OPTION = new CliOption("script-definitions-classpath", "<classpath entry[:]>", "Additional classpath for the script definitions", false, true);
        DISABLE_STANDARD_SCRIPT_DEFINITION_OPTION = new CliOption("disable-standard-script", "true/false", "Disable standard kotlin script support", false, false);
        DISABLE_SCRIPT_DEFINITIONS_FROM_CLSSPATH_OPTION = new CliOption("disable-script-definitions-from-classpath", "true/false", "Do not extract script definitions from the compilation classpath", false, false);
        LEGACY_SCRIPT_TEMPLATES_OPTION = new CliOption("script-templates", "<fully qualified class name[,]>", "Script definition template classes", false, true);
        LEGACY_SCRIPT_RESOLVER_ENVIRONMENT_OPTION = new CliOption("script-resolver-environment", "<key=value[,]>", "Script resolver environment in key-value pairs (the value could be quoted and escaped)", false, true);
        PLUGIN_ID = PLUGIN_ID;
    }

    public <T> void appendList(@NotNull CompilerConfiguration $receiver, @NotNull CompilerConfigurationKey<List<T>> option, T value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(option, (String)"option");
        CommandLineProcessor.DefaultImpls.appendList((CommandLineProcessor)this, (CompilerConfiguration)$receiver, option, value);
    }

    public <T> void appendList(@NotNull CompilerConfiguration $receiver, @NotNull CompilerConfigurationKey<List<T>> option, @NotNull List<? extends T> values) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(option, (String)"option");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        CommandLineProcessor.DefaultImpls.appendList((CommandLineProcessor)this, (CompilerConfiguration)$receiver, option, values);
    }

    public void applyOptionsFrom(@NotNull CompilerConfiguration $receiver, @NotNull Map<String, ? extends List<String>> map, @NotNull Collection<CliOption> pluginOptions) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        Intrinsics.checkParameterIsNotNull(pluginOptions, (String)"pluginOptions");
        CommandLineProcessor.DefaultImpls.applyOptionsFrom((CommandLineProcessor)this, (CompilerConfiguration)$receiver, map, pluginOptions);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0010X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/ScriptingCommandLineProcessor$Companion;", "", "()V", "DISABLE_SCRIPTING_PLUGIN_OPTION", "Lorg/jetbrains/kotlin/compiler/plugin/CliOption;", "getDISABLE_SCRIPTING_PLUGIN_OPTION", "()Lorg/jetbrains/kotlin/compiler/plugin/CliOption;", "DISABLE_SCRIPT_DEFINITIONS_FROM_CLSSPATH_OPTION", "getDISABLE_SCRIPT_DEFINITIONS_FROM_CLSSPATH_OPTION", "DISABLE_STANDARD_SCRIPT_DEFINITION_OPTION", "getDISABLE_STANDARD_SCRIPT_DEFINITION_OPTION", "LEGACY_SCRIPT_RESOLVER_ENVIRONMENT_OPTION", "getLEGACY_SCRIPT_RESOLVER_ENVIRONMENT_OPTION", "LEGACY_SCRIPT_TEMPLATES_OPTION", "getLEGACY_SCRIPT_TEMPLATES_OPTION", "PLUGIN_ID", "", "getPLUGIN_ID", "()Ljava/lang/String;", "SCRIPT_DEFINITIONS_CLASSPATH_OPTION", "getSCRIPT_DEFINITIONS_CLASSPATH_OPTION", "SCRIPT_DEFINITIONS_OPTION", "getSCRIPT_DEFINITIONS_OPTION", "kotlin-scripting-compiler"})
    public static final class Companion {
        @NotNull
        public final CliOption getDISABLE_SCRIPTING_PLUGIN_OPTION() {
            return DISABLE_SCRIPTING_PLUGIN_OPTION;
        }

        @NotNull
        public final CliOption getSCRIPT_DEFINITIONS_OPTION() {
            return SCRIPT_DEFINITIONS_OPTION;
        }

        @NotNull
        public final CliOption getSCRIPT_DEFINITIONS_CLASSPATH_OPTION() {
            return SCRIPT_DEFINITIONS_CLASSPATH_OPTION;
        }

        @NotNull
        public final CliOption getDISABLE_STANDARD_SCRIPT_DEFINITION_OPTION() {
            return DISABLE_STANDARD_SCRIPT_DEFINITION_OPTION;
        }

        @NotNull
        public final CliOption getDISABLE_SCRIPT_DEFINITIONS_FROM_CLSSPATH_OPTION() {
            return DISABLE_SCRIPT_DEFINITIONS_FROM_CLSSPATH_OPTION;
        }

        @NotNull
        public final CliOption getLEGACY_SCRIPT_TEMPLATES_OPTION() {
            return LEGACY_SCRIPT_TEMPLATES_OPTION;
        }

        @NotNull
        public final CliOption getLEGACY_SCRIPT_RESOLVER_ENVIRONMENT_OPTION() {
            return LEGACY_SCRIPT_RESOLVER_ENVIRONMENT_OPTION;
        }

        @NotNull
        public final String getPLUGIN_ID() {
            return PLUGIN_ID;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

