/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.descriptors.DescriptorUtilsKt;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0001\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\u0006*\u00020\u0001\u001a\n\u0010\b\u001a\u00020\u0006*\u00020\u0001\u001a\n\u0010\t\u001a\u00020\u0006*\u00020\u0001\u001a\n\u0010\n\u001a\u00020\u0006*\u00020\u0001\u001a\n\u0010\u000b\u001a\u00020\u0006*\u00020\u0001\u001a\u0012\u0010\f\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001\u001a\u0012\u0010\u000e\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u0006*\u00020\u0001\u00a8\u0006\u0012"}, d2={"commonSupertype", "Lorg/jetbrains/kotlin/ir/types/IrType;", "", "getPrimitiveArrayElementType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "isBuiltinFunctionalTypeOrSubtype", "", "isFunctionOrKFunction", "isFunctionTypeOrSubtype", "isInterface", "isNullable", "isPrimitiveArray", "isSubtypeOf", "superType", "isSubtypeOfClass", "superClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "isTypeParameter", "ir.backend.common"})
public final class KotlinTypeBasedUtilsKt {
    public static final boolean isNullable(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinTypeKt.isNullable(IrTypesKt.toKotlinType($receiver));
    }

    public static final boolean isInterface(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return TypeUtilsKt.isInterface(IrTypesKt.toKotlinType($receiver));
    }

    public static final boolean isPrimitiveArray(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isPrimitiveArray(IrTypesKt.toKotlinType($receiver));
    }

    @Nullable
    public static final PrimitiveType getPrimitiveArrayElementType(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.getPrimitiveArrayElementType(IrTypesKt.toKotlinType($receiver));
    }

    public static final boolean isTypeParameter(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return TypeUtilsKt.isTypeParameter(IrTypesKt.toKotlinType($receiver));
    }

    public static final boolean isFunctionOrKFunction(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return DescriptorUtilsKt.isFunctionOrKFunctionType(IrTypesKt.toKotlinType($receiver));
    }

    public static final boolean isFunctionTypeOrSubtype(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FunctionTypesKt.isFunctionTypeOrSubtype(IrTypesKt.toKotlinType($receiver));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrType commonSupertype(@NotNull List<? extends IrType> $receiver) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterable iterable = $receiver$iv = (Iterable)$receiver;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            IrType irType = (IrType)item$iv$iv;
            Collection collection = destination$iv$iv;
            KotlinType kotlinType = IrTypesKt.toKotlinType((IrType)p1);
            collection.add(kotlinType);
        }
        KotlinType kotlinType = CommonSupertypes.commonSupertype((List)var3_3);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "CommonSupertypes.commonS\u2026ap(IrType::toKotlinType))");
        IrType irType = IrTypesKt.toIrType(kotlinType);
        if (irType == null) {
            Intrinsics.throwNpe();
        }
        return irType;
    }

    public static final boolean isSubtypeOf(@NotNull IrType $receiver, @NotNull IrType superType) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(superType, "superType");
        return TypeUtilsKt.isSubtypeOf(IrTypesKt.toKotlinType($receiver), IrTypesKt.toKotlinType(superType));
    }

    public static final boolean isSubtypeOfClass(@NotNull IrType $receiver, @NotNull IrClassSymbol superClass) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(superClass, "superClass");
        return DescriptorUtils.isSubtypeOfClass(IrTypesKt.toKotlinType($receiver), (DeclarationDescriptor)superClass.getDescriptor());
    }

    public static final boolean isBuiltinFunctionalTypeOrSubtype(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FunctionTypesKt.isBuiltinFunctionalTypeOrSubtype(IrTypesKt.toKotlinType($receiver));
    }
}

