/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.JvmFunctionSignature;
import kotlin.reflect.jvm.internal.JvmPropertySignature;
import kotlin.reflect.jvm.internal.KotlinReflectionInternalError;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertySetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaMethodDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaPropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.sources.JavaSourceElement;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaElement;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmProtoBufUtil;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.platform.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import kotlin.reflect.jvm.internal.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.structure.ReflectJavaConstructor;
import kotlin.reflect.jvm.internal.structure.ReflectJavaField;
import kotlin.reflect.jvm.internal.structure.ReflectJavaMethod;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u00020\u00042\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u0006\u0012\u0002\b\u00030\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lkotlin/reflect/jvm/internal/RuntimeTypeMapper;", "", "()V", "JAVA_LANG_VOID", "Lkotlin/reflect/jvm/internal/impl/name/ClassId;", "primitiveType", "Lkotlin/reflect/jvm/internal/impl/builtins/PrimitiveType;", "Ljava/lang/Class;", "getPrimitiveType", "(Ljava/lang/Class;)Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "mapIntrinsicFunctionSignature", "Lkotlin/reflect/jvm/internal/JvmFunctionSignature;", "function", "Lkotlin/reflect/jvm/internal/impl/descriptors/FunctionDescriptor;", "mapJvmClassToKotlinClassId", "klass", "mapPropertySignature", "Lkotlin/reflect/jvm/internal/JvmPropertySignature;", "possiblyOverriddenProperty", "Lkotlin/reflect/jvm/internal/impl/descriptors/PropertyDescriptor;", "mapSignature", "possiblySubstitutedFunction", "kotlin-reflection"})
public final class RuntimeTypeMapper {
    private static final ClassId JAVA_LANG_VOID;
    public static final RuntimeTypeMapper INSTANCE;

    @NotNull
    public final JvmFunctionSignature mapSignature(@NotNull FunctionDescriptor possiblySubstitutedFunction) {
        FunctionDescriptor function;
        Intrinsics.checkParameterIsNotNull((Object)possiblySubstitutedFunction, (String)"possiblySubstitutedFunction");
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)possiblySubstitutedFunction);
        Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"DescriptorUtils.unwrapFa\u2026siblySubstitutedFunction)");
        FunctionDescriptor functionDescriptor = function = ((FunctionDescriptor)callableMemberDescriptor).getOriginal();
        if (functionDescriptor instanceof DeserializedCallableMemberDescriptor) {
            FunctionDescriptor functionDescriptor2 = function;
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"function");
            JvmFunctionSignature jvmFunctionSignature = this.mapIntrinsicFunctionSignature(functionDescriptor2);
            if (jvmFunctionSignature != null) {
                JvmFunctionSignature jvmFunctionSignature2;
                JvmFunctionSignature it = jvmFunctionSignature2 = jvmFunctionSignature;
                return it;
            }
            MessageLite proto = ((DeserializedCallableMemberDescriptor)((Object)function)).getProto();
            if (proto instanceof ProtoBuf.Function) {
                String string = JvmProtoBufUtil.INSTANCE.getJvmMethodSignature((ProtoBuf.Function)proto, ((DeserializedCallableMemberDescriptor)((Object)function)).getNameResolver(), ((DeserializedCallableMemberDescriptor)((Object)function)).getTypeTable());
                if (string != null) {
                    String string2;
                    String signature2 = string2 = string;
                    return new JvmFunctionSignature.KotlinFunction(signature2);
                }
            }
            if (proto instanceof ProtoBuf.Constructor) {
                String string = JvmProtoBufUtil.INSTANCE.getJvmConstructorSignature((ProtoBuf.Constructor)proto, ((DeserializedCallableMemberDescriptor)((Object)function)).getNameResolver(), ((DeserializedCallableMemberDescriptor)((Object)function)).getTypeTable());
                if (string != null) {
                    String string3;
                    String signature3 = string3 = string;
                    return new JvmFunctionSignature.KotlinConstructor(signature3);
                }
            }
            throw (Throwable)new KotlinReflectionInternalError("Reflection on built-in Kotlin types is not yet fully supported. " + "No metadata found for " + function);
        }
        if (functionDescriptor instanceof JavaMethodDescriptor) {
            Object object;
            FunctionDescriptor functionDescriptor3 = function;
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor3, (String)"function");
            SourceElement sourceElement = ((JavaMethodDescriptor)functionDescriptor3).getSource();
            if (!(sourceElement instanceof JavaSourceElement)) {
                sourceElement = null;
            }
            JavaSourceElement javaSourceElement = (JavaSourceElement)sourceElement;
            JavaElement javaElement = javaSourceElement != null ? javaSourceElement.getJavaElement() : null;
            if (!(javaElement instanceof ReflectJavaMethod)) {
                javaElement = null;
            }
            if ((object = (ReflectJavaMethod)javaElement) == null || (object = ((ReflectJavaMethod)object).getMember()) == null) {
                throw (Throwable)new KotlinReflectionInternalError("Incorrect resolution sequence for Java method " + function);
            }
            Object method = object;
            return new JvmFunctionSignature.JavaMethod((Method)method);
        }
        if (functionDescriptor instanceof JavaClassConstructorDescriptor) {
            JvmFunctionSignature jvmFunctionSignature;
            JavaElement element;
            FunctionDescriptor functionDescriptor4 = function;
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor4, (String)"function");
            SourceElement sourceElement = ((JavaClassConstructorDescriptor)functionDescriptor4).getSource();
            if (!(sourceElement instanceof JavaSourceElement)) {
                sourceElement = null;
            }
            JavaSourceElement javaSourceElement = (JavaSourceElement)sourceElement;
            JavaElement javaElement = element = javaSourceElement != null ? javaSourceElement.getJavaElement() : null;
            if (element instanceof ReflectJavaConstructor) {
                jvmFunctionSignature = new JvmFunctionSignature.JavaConstructor((Constructor<?>)((ReflectJavaConstructor)element).getMember());
            } else if (element instanceof ReflectJavaClass && ((ReflectJavaClass)element).isAnnotationType()) {
                jvmFunctionSignature = new JvmFunctionSignature.FakeJavaAnnotationConstructor((Class<?>)((ReflectJavaClass)element).getElement());
            } else {
                throw (Throwable)new KotlinReflectionInternalError("Incorrect resolution sequence for Java constructor " + function + " (" + element + ')');
            }
            return jvmFunctionSignature;
        }
        throw (Throwable)new KotlinReflectionInternalError("Unknown origin of " + function + " (" + function.getClass() + ')');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final JvmPropertySignature mapPropertySignature(@NotNull PropertyDescriptor possiblyOverriddenProperty) {
        JvmPropertySignature jvmPropertySignature;
        PropertyDescriptor property;
        Intrinsics.checkParameterIsNotNull((Object)possiblyOverriddenProperty, (String)"possiblyOverriddenProperty");
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)possiblyOverriddenProperty);
        Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"DescriptorUtils.unwrapFa\u2026ssiblyOverriddenProperty)");
        PropertyDescriptor propertyDescriptor = property = ((PropertyDescriptor)callableMemberDescriptor).getOriginal();
        if (propertyDescriptor instanceof DeserializedPropertyDescriptor) {
            ProtoBuf.Property proto = ((DeserializedPropertyDescriptor)property).getProto();
            GeneratedMessageLite.ExtendableMessage extendableMessage = proto;
            GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, JvmProtoBuf.JvmPropertySignature> generatedExtension = JvmProtoBuf.propertySignature;
            Intrinsics.checkExpressionValueIsNotNull(generatedExtension, (String)"JvmProtoBuf.propertySignature");
            JvmProtoBuf.JvmPropertySignature jvmPropertySignature2 = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
            if (jvmPropertySignature2 == null) {
                throw (Throwable)new KotlinReflectionInternalError("Reflection on built-in Kotlin types is not yet fully supported. No metadata found for " + property);
            }
            JvmProtoBuf.JvmPropertySignature signature2 = jvmPropertySignature2;
            PropertyDescriptor propertyDescriptor2 = property;
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor2, (String)"property");
            jvmPropertySignature = new JvmPropertySignature.KotlinProperty(propertyDescriptor2, proto, signature2, ((DeserializedPropertyDescriptor)property).getNameResolver(), ((DeserializedPropertyDescriptor)property).getTypeTable());
            return jvmPropertySignature;
        } else {
            if (!(propertyDescriptor instanceof JavaPropertyDescriptor)) throw (Throwable)new KotlinReflectionInternalError("Unknown origin of " + property + " (" + property.getClass() + ')');
            PropertyDescriptor propertyDescriptor3 = property;
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor3, (String)"property");
            SourceElement sourceElement = ((JavaPropertyDescriptor)propertyDescriptor3).getSource();
            if (!(sourceElement instanceof JavaSourceElement)) {
                sourceElement = null;
            }
            JavaSourceElement javaSourceElement = (JavaSourceElement)sourceElement;
            JavaElement element = javaSourceElement != null ? javaSourceElement.getJavaElement() : null;
            JavaElement javaElement = element;
            if (javaElement instanceof ReflectJavaField) {
                jvmPropertySignature = new JvmPropertySignature.JavaField(((ReflectJavaField)element).getMember());
                return jvmPropertySignature;
            } else {
                if (!(javaElement instanceof ReflectJavaMethod)) throw (Throwable)new KotlinReflectionInternalError("Incorrect resolution sequence for Java field " + property + " (source = " + element + ')');
                Method method = ((ReflectJavaMethod)element).getMember();
                PropertySetterDescriptor propertySetterDescriptor = property.getSetter();
                SourceElement sourceElement2 = propertySetterDescriptor != null ? propertySetterDescriptor.getSource() : null;
                if (!(sourceElement2 instanceof JavaSourceElement)) {
                    sourceElement2 = null;
                }
                JavaSourceElement javaSourceElement2 = (JavaSourceElement)sourceElement2;
                JavaElement javaElement2 = javaSourceElement2 != null ? javaSourceElement2.getJavaElement() : null;
                if (!(javaElement2 instanceof ReflectJavaMethod)) {
                    javaElement2 = null;
                }
                ReflectJavaMethod reflectJavaMethod = (ReflectJavaMethod)javaElement2;
                jvmPropertySignature = new JvmPropertySignature.JavaMethodProperty(method, reflectJavaMethod != null ? reflectJavaMethod.getMember() : null);
            }
        }
        return jvmPropertySignature;
    }

    private final JvmFunctionSignature mapIntrinsicFunctionSignature(FunctionDescriptor function) {
        List<ValueParameterDescriptor> parameters2 = function.getValueParameters();
        switch (function.getName().asString()) {
            case "equals": {
                if (parameters2.size() != 1) break;
                List<ValueParameterDescriptor> list = parameters2;
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"parameters");
                Object object = CollectionsKt.single(list);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.single()");
                if (!KotlinBuiltIns.isNullableAny(((ValueParameterDescriptor)object).getType())) break;
                Method method = Object.class.getDeclaredMethod("equals", Object.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"Any::class.java.getDecla\u2026equals\", Any::class.java)");
                return new JvmFunctionSignature.BuiltInFunction.Predefined("equals(Ljava/lang/Object;)Z", method);
            }
            case "hashCode": {
                if (!parameters2.isEmpty()) break;
                Method method = Object.class.getDeclaredMethod("hashCode", new Class[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"Any::class.java.getDeclaredMethod(\"hashCode\")");
                return new JvmFunctionSignature.BuiltInFunction.Predefined("hashCode()I", method);
            }
            case "toString": {
                if (!parameters2.isEmpty()) break;
                Method method = Object.class.getDeclaredMethod("toString", new Class[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"Any::class.java.getDeclaredMethod(\"toString\")");
                return new JvmFunctionSignature.BuiltInFunction.Predefined("toString()Ljava/lang/String;", method);
            }
        }
        return null;
    }

    @NotNull
    public final ClassId mapJvmClassToKotlinClassId(@NotNull Class<?> klass) {
        Intrinsics.checkParameterIsNotNull(klass, (String)"klass");
        if (klass.isArray()) {
            Class<?> clazz = klass.getComponentType();
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"klass.componentType");
            PrimitiveType primitiveType = this.getPrimitiveType(clazz);
            if (primitiveType != null) {
                PrimitiveType primitiveType2;
                PrimitiveType it = primitiveType2 = primitiveType;
                return new ClassId(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, it.getArrayTypeName());
            }
            ClassId classId = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.array.toSafe());
            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"ClassId.topLevel(KotlinB\u2026.FQ_NAMES.array.toSafe())");
            return classId;
        }
        if (Intrinsics.areEqual(klass, Void.TYPE)) {
            ClassId classId = JAVA_LANG_VOID;
            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"JAVA_LANG_VOID");
            return classId;
        }
        PrimitiveType primitiveType = this.getPrimitiveType(klass);
        if (primitiveType != null) {
            PrimitiveType primitiveType3;
            PrimitiveType it = primitiveType3 = primitiveType;
            return new ClassId(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, it.getTypeName());
        }
        ClassId classId = ReflectClassUtilKt.getClassId(klass);
        if (!classId.isLocal()) {
            FqName fqName2 = classId.asSingleFqName();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.asSingleFqName()");
            ClassId classId2 = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName2);
            if (classId2 != null) {
                ClassId classId3;
                ClassId it = classId3 = classId2;
                return it;
            }
        }
        return classId;
    }

    private final PrimitiveType getPrimitiveType(@NotNull Class<?> $receiver) {
        PrimitiveType primitiveType;
        if ($receiver.isPrimitive()) {
            JvmPrimitiveType jvmPrimitiveType = JvmPrimitiveType.get($receiver.getSimpleName());
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)jvmPrimitiveType), (String)"JvmPrimitiveType.get(simpleName)");
            primitiveType = jvmPrimitiveType.getPrimitiveType();
        } else {
            primitiveType = null;
        }
        return primitiveType;
    }

    private RuntimeTypeMapper() {
    }

    static {
        RuntimeTypeMapper runtimeTypeMapper;
        INSTANCE = runtimeTypeMapper = new RuntimeTypeMapper();
        JAVA_LANG_VOID = ClassId.topLevel(new FqName("java.lang.Void"));
    }
}

