/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.CounterWithExclude;
import org.jetbrains.kotlin.util.ReenterableCounter;
import org.jetbrains.kotlin.util.SimpleCounter;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013H$\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000fH\u0004J\u001a\u0010\u0019\u001a\u00020\u00162\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u001bJ\u0006\u0010\u001c\u001a\u00020\u0016J\u001f\u0010\u001d\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/util/PerformanceCounter;", "", "name", "", "(Ljava/lang/String;)V", "count", "", "excludedFrom", "", "Lorg/jetbrains/kotlin/util/CounterWithExclude;", "getExcludedFrom$frontend", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "totalTimeNanos", "", "countTime", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "increment", "", "incrementTime", "delta", "report", "consumer", "Lkotlin/Function1;", "reset", "time", "Companion", "frontend"})
public abstract class PerformanceCounter {
    @NotNull
    private final List<CounterWithExclude> excludedFrom;
    private int count;
    private long totalTimeNanos;
    @NotNull
    private final String name;
    private static final ArrayList<PerformanceCounter> allCounters;
    private static boolean enabled;
    public static final Companion Companion;

    @NotNull
    public final List<CounterWithExclude> getExcludedFrom$frontend() {
        return this.excludedFrom;
    }

    public final void increment() {
        int n = this.count;
        this.count = n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T time(@NotNull Function0<? extends T> block) {
        Intrinsics.checkParameterIsNotNull(block, "block");
        int n = this.count;
        this.count = n + 1;
        if (!enabled) {
            return block.invoke();
        }
        Iterable $receiver$iv = this.excludedFrom;
        for (Object element$iv : $receiver$iv) {
            CounterWithExclude it = (CounterWithExclude)element$iv;
            it.enterExcludedMethod();
        }
        try {
            T t = this.countTime(block);
            return t;
        }
        finally {
            Iterable $receiver$iv2 = this.excludedFrom;
            for (Object element$iv : $receiver$iv2) {
                CounterWithExclude it = (CounterWithExclude)element$iv;
                it.exitExcludedMethod();
            }
        }
    }

    public final void reset() {
        this.count = 0;
        this.totalTimeNanos = 0L;
    }

    protected final void incrementTime(long delta) {
        this.totalTimeNanos += delta;
    }

    protected abstract <T> T countTime(@NotNull Function0<? extends T> var1);

    public final void report(@NotNull Function1<? super String, Unit> consumer) {
        Intrinsics.checkParameterIsNotNull(consumer, "consumer");
        if (this.totalTimeNanos == 0L) {
            consumer.invoke("" + this.name + " performed " + this.count + " times");
        } else {
            long millis = TimeUnit.NANOSECONDS.toMillis(this.totalTimeNanos);
            consumer.invoke("" + this.name + " performed " + this.count + " times, total time " + millis + " ms");
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PerformanceCounter(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        this.name = name;
        this.excludedFrom = new ArrayList();
        ArrayList<PerformanceCounter> arrayList = allCounters;
        synchronized (arrayList) {
            boolean bl = allCounters.add(this);
        }
    }

    static {
        Companion = new Companion(null);
        allCounters = new ArrayList();
    }

    public static final /* synthetic */ boolean access$getEnabled$cp() {
        return enabled;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\r\"\u00020\u0005\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\bH\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J2\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017H\u0080\b\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001a\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001b0\u001dJ\u0006\u0010\u001e\u001a\u00020\u001bJ\u000e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\bR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/util/PerformanceCounter$Companion;", "", "()V", "allCounters", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/util/PerformanceCounter;", "Lkotlin/collections/ArrayList;", "enabled", "", "create", "name", "", "excluded", "", "(Ljava/lang/String;[Lorg/jetbrains/kotlin/util/PerformanceCounter;)Lorg/jetbrains/kotlin/util/PerformanceCounter;", "reenterable", "currentTime", "", "getOrPut", "T", "threadLocal", "Ljava/lang/ThreadLocal;", "default", "Lkotlin/Function0;", "getOrPut$frontend", "(Ljava/lang/ThreadLocal;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "report", "", "consumer", "Lkotlin/Function1;", "resetAllCounters", "setTimeCounterEnabled", "enable", "frontend"})
    public static final class Companion {
        public final long currentTime() {
            return System.nanoTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void report(@NotNull Function1<? super String, Unit> consumer) {
            PerformanceCounter[] countersCopy;
            PerformanceCounter[] performanceCounterArray;
            Intrinsics.checkParameterIsNotNull(consumer, "consumer");
            ArrayList arrayList = allCounters;
            synchronized (arrayList) {
                Collection $receiver$iv;
                Collection collection = $receiver$iv = (Collection)allCounters;
                if (collection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = collection;
                PerformanceCounter[] performanceCounterArray2 = thisCollection$iv.toArray(new PerformanceCounter[0]);
                if (performanceCounterArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                performanceCounterArray = performanceCounterArray2;
            }
            PerformanceCounter[] $receiver$iv = countersCopy = performanceCounterArray;
            int n = $receiver$iv.length;
            for (int i = 0; i < n; ++i) {
                PerformanceCounter element$iv;
                PerformanceCounter it = element$iv = $receiver$iv[i];
                it.report(consumer);
            }
        }

        public final void setTimeCounterEnabled(boolean enable) {
            enabled = enable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void resetAllCounters() {
            ArrayList arrayList = allCounters;
            synchronized (arrayList) {
                Iterable $receiver$iv = allCounters;
                for (Object element$iv : $receiver$iv) {
                    PerformanceCounter p1 = (PerformanceCounter)element$iv;
                    p1.reset();
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        @JvmOverloads
        @NotNull
        public final PerformanceCounter create(@NotNull String name, boolean reenterable) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            return reenterable ? (PerformanceCounter)new ReenterableCounter(name) : (PerformanceCounter)new SimpleCounter(name);
        }

        @JvmOverloads
        @NotNull
        public static /* synthetic */ PerformanceCounter create$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.create(string, bl);
        }

        @JvmOverloads
        @NotNull
        public final PerformanceCounter create(@NotNull String name) {
            return org.jetbrains.kotlin.util.PerformanceCounter$Companion.create$default(this, name, false, 2, null);
        }

        @NotNull
        public final PerformanceCounter create(@NotNull String name, PerformanceCounter ... excluded) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(excluded, "excluded");
            return new CounterWithExclude(name, Arrays.copyOf(excluded, excluded.length));
        }

        public final <T> T getOrPut$frontend(@NotNull ThreadLocal<T> threadLocal, @NotNull Function0<? extends T> function0) {
            Intrinsics.checkParameterIsNotNull(threadLocal, "threadLocal");
            Intrinsics.checkParameterIsNotNull(function0, "default");
            T value = threadLocal.get();
            if (value == null) {
                value = function0.invoke();
                threadLocal.set(value);
            }
            return value;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

