/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.definition;

import com.intellij.psi.PsiElement;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.javacs.kt.CompiledFile;
import org.javacs.kt.CompilerClassPath;
import org.javacs.kt.ExternalSourcesConfiguration;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.definition.GoToDefinitionKt;
import org.javacs.kt.externalsources.ClassContentProvider;
import org.javacs.kt.externalsources.KlsURI;
import org.javacs.kt.externalsources.KlsURIKt;
import org.javacs.kt.position.PositionKt;
import org.javacs.kt.util.TemporaryDirectory;
import org.javacs.kt.util.URIsKt;
import org.javacs.kt.util.UtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a8\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"cachedTempFiles", "", "Lorg/javacs/kt/externalsources/KlsURI;", "Ljava/nio/file/Path;", "definitionPattern", "Lkotlin/text/Regex;", "goToDefinition", "Lorg/eclipse/lsp4j/Location;", "file", "Lorg/javacs/kt/CompiledFile;", "cursor", "", "classContentProvider", "Lorg/javacs/kt/externalsources/ClassContentProvider;", "tempDir", "Lorg/javacs/kt/util/TemporaryDirectory;", "config", "Lorg/javacs/kt/ExternalSourcesConfiguration;", "cp", "Lorg/javacs/kt/CompilerClassPath;", "isInsideArchive", "", "uri", "", "server"})
@SourceDebugExtension(value={"SMAP\nGoToDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoToDefinition.kt\norg/javacs/kt/definition/GoToDefinitionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class GoToDefinitionKt {
    @NotNull
    private static final Map<KlsURI, Path> cachedTempFiles = new LinkedHashMap();
    @NotNull
    private static final Regex definitionPattern = new Regex("(?:class|interface|object|fun)\\s+(\\w+)");

    @Nullable
    public static final Location goToDefinition(@NotNull CompiledFile file, int cursor, @NotNull ClassContentProvider classContentProvider, @NotNull TemporaryDirectory tempDir, @NotNull ExternalSourcesConfiguration config, @NotNull CompilerClassPath cp) {
        Location destination;
        block19: {
            DeclarationDescriptor target;
            block17: {
                PsiElement psiElement;
                block18: {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)classContentProvider, (String)"classContentProvider");
                    Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
                    Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                    Intrinsics.checkNotNullParameter((Object)cp, (String)"cp");
                    Pair<KtExpression, DeclarationDescriptor> pair = file.referenceExpressionAtPoint(cursor);
                    if (pair == null) {
                        return null;
                    }
                    target = (DeclarationDescriptor)pair.component2();
                    Object[] objectArray = new Object[]{target};
                    LoggerKt.getLOG().info("Found declaration descriptor {}", objectArray);
                    destination = null;
                    destination = PositionKt.location(target);
                    PsiElement psi = SourceLocationUtilsKt.findPsi((DeclarationDescriptor)target);
                    if (!(psi instanceof KtNamedDeclaration)) break block17;
                    psiElement = ((KtNamedDeclaration)psi).getNameIdentifier();
                    if (psiElement == null) break block18;
                    PsiElement p0 = psiElement;
                    boolean bl = false;
                    Location location = PositionKt.location(p0);
                    psiElement = location;
                    if (location != null) break block17;
                }
                psiElement = destination = destination;
            }
            if (destination == null) break block19;
            String rawClassURI = destination.getUri();
            Intrinsics.checkNotNullExpressionValue((Object)rawClassURI, (String)"rawClassURI");
            if (GoToDefinitionKt.isInsideArchive(rawClassURI, cp)) {
                KlsURI klsURI = KlsURIKt.toKlsURI(URIsKt.parseURI((String)rawClassURI));
                if (klsURI != null) {
                    KlsURI klsURI2 = klsURI;
                    boolean bl = false;
                    Pair<KlsURI, String> pair = classContentProvider.contentOf(klsURI2);
                    KlsURI klsSourceURI = (KlsURI)pair.component1();
                    String content = (String)pair.component2();
                    if (config.getUseKlsScheme()) {
                        destination.setUri(klsSourceURI.toString());
                    } else {
                        Path path = cachedTempFiles.get(klsSourceURI);
                        if (path == null) {
                            Path path2;
                            boolean bl2 = false;
                            String name = (String)UtilsKt.partitionAroundLast((String)klsSourceURI.getFileName(), (String)".").getFirst();
                            String extensionWithoutDot = klsSourceURI.getFileExtension();
                            String string = extensionWithoutDot;
                            Object extension = string != null ? "." + string : "";
                            Path it = path2 = tempDir.createTempFile(name, (String)extension);
                            boolean bl3 = false;
                            File file2 = it.toFile();
                            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"it.toFile()");
                            FilesKt.writeText$default((File)file2, (String)content, null, (int)2, null);
                            cachedTempFiles.put(klsSourceURI, it);
                            path = path2;
                        }
                        Path tmpFile = path;
                        destination.setUri(tmpFile.toUri().toString());
                    }
                    Range range = destination.getRange();
                    Intrinsics.checkNotNullExpressionValue((Object)range, (String)"destination.range");
                    if (PositionKt.isZero(range)) {
                        Object object;
                        String string;
                        block16: {
                            string = target instanceof ConstructorDescriptor ? ((ConstructorDescriptor)target).getConstructedClass().getName().toString() : target.getName().toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when (target) {\n        \u2026g()\n                    }");
                            String name = string;
                            Sequence sequence = SequencesKt.map((Sequence)Regex.findAll$default((Regex)definitionPattern, (CharSequence)content, (int)0, (int)2, null), (Function1)goToDefinition.2.1.INSTANCE);
                            for (Object extension : sequence) {
                                MatchGroup it = (MatchGroup)extension;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)it.getValue(), (Object)name)) continue;
                                object = extension;
                                break block16;
                            }
                            object = null;
                        }
                        string = (MatchGroup)object;
                        if (string != null) {
                            String it = string;
                            boolean bl5 = false;
                            IntRange intRange = it.getRange();
                            if (intRange != null) {
                                it = intRange;
                                boolean bl6 = false;
                                destination.setRange(new Range(PositionKt.position(content, it.getFirst()), PositionKt.position(content, it.getLast())));
                            }
                        }
                    }
                }
            }
        }
        return destination;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isInsideArchive(String uri, CompilerClassPath cp) {
        if (StringsKt.contains$default((CharSequence)uri, (CharSequence)".jar!", (boolean)false, (int)2, null)) return true;
        if (StringsKt.contains$default((CharSequence)uri, (CharSequence)".zip!", (boolean)false, (int)2, null)) return true;
        String string = cp.getJavaHome();
        if (string == null) return false;
        String it = string;
        boolean bl = false;
        String string2 = ((Object)Paths.get(URIsKt.parseURI((String)uri))).toString();
        String string3 = new File(it).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"File(it).path");
        boolean bl2 = StringsKt.startsWith$default((String)string2, (String)string3, (boolean)false, (int)2, null);
        if (!bl2) return false;
        return true;
    }
}

