/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.common;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.Assembler;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.DockerPackager;
import org.jreleaser.model.internal.packagers.DockerSpec;
import org.jreleaser.model.internal.packagers.JibPackager;
import org.jreleaser.model.internal.packagers.JibSpec;
import org.jreleaser.model.internal.packagers.TemplatePackager;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class TemplateValidator {
    private TemplateValidator() {
    }

    public static void validateTemplate(JReleaserContext context, Distribution distribution, TemplatePackager<?> packager, TemplatePackager<?> parentPackager, Errors errors) {
        String defaultTemplateDirectory = "src/jreleaser/distributions/" + distribution.getName() + "/" + packager.getType();
        if (StringUtils.isBlank((String)packager.getTemplateDirectory())) {
            packager.setTemplateDirectory(parentPackager.getTemplateDirectory());
            if (StringUtils.isNotBlank((String)packager.getTemplateDirectory()) && !defaultTemplateDirectory.equals(packager.getTemplateDirectory().trim()) && !Files.exists(context.getBasedir().resolve(packager.getTemplateDirectory().trim()), new LinkOption[0])) {
                errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"distribution." + distribution.getName() + "." + packager.getType() + ".template", packager.getTemplateDirectory()}));
            }
            if (StringUtils.isBlank((String)packager.getTemplateDirectory())) {
                packager.setTemplateDirectory(defaultTemplateDirectory);
            }
            return;
        }
        if (StringUtils.isNotBlank((String)packager.getTemplateDirectory()) && !defaultTemplateDirectory.equals(packager.getTemplateDirectory().trim()) && !Files.exists(context.getBasedir().resolve(packager.getTemplateDirectory().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"distribution." + distribution.getName() + "." + packager.getType() + ".template", packager.getTemplateDirectory()}));
        }
        if (StringUtils.isBlank((String)packager.getTemplateDirectory())) {
            packager.setTemplateDirectory(defaultTemplateDirectory);
        }
    }

    public static void validateTemplate(JReleaserContext context, Assembler<?> assembler, Errors errors) {
        String defaultTemplateDirectory = "src/jreleaser/assemblers/" + assembler.getName() + "/" + assembler.getType();
        if (StringUtils.isNotBlank((String)assembler.getTemplateDirectory()) && !defaultTemplateDirectory.equals(assembler.getTemplateDirectory().trim()) && !Files.exists(context.getBasedir().resolve(assembler.getTemplateDirectory().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{assembler.getType() + "." + assembler.getName() + ".template", assembler.getTemplateDirectory()}));
        }
        if (StringUtils.isBlank((String)assembler.getTemplateDirectory())) {
            assembler.setTemplateDirectory(defaultTemplateDirectory);
        }
    }

    public static void validateTemplate(JReleaserContext context, Distribution distribution, DockerSpec spec, DockerPackager docker, Errors errors) {
        String defaultTemplateDirectory = "src/jreleaser/distributions/" + distribution.getName() + "/" + docker.getType() + "/" + spec.getName();
        if (StringUtils.isNotBlank((String)spec.getTemplateDirectory()) && !defaultTemplateDirectory.equals(spec.getTemplateDirectory().trim()) && !Files.exists(context.getBasedir().resolve(spec.getTemplateDirectory().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"distribution." + distribution.getName() + ".docker." + spec.getName() + ".template", spec.getTemplateDirectory()}));
        }
        if (StringUtils.isBlank((String)spec.getTemplateDirectory())) {
            spec.setTemplateDirectory(defaultTemplateDirectory);
        }
    }

    public static void validateTemplate(JReleaserContext context, Distribution distribution, JibSpec spec, JibPackager jib, Errors errors) {
        String defaultTemplateDirectory = "src/jreleaser/distributions/" + distribution.getName() + "/" + jib.getType() + "/" + spec.getName();
        if (StringUtils.isNotBlank((String)spec.getTemplateDirectory()) && !defaultTemplateDirectory.equals(spec.getTemplateDirectory().trim()) && !Files.exists(context.getBasedir().resolve(spec.getTemplateDirectory().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"distribution." + distribution.getName() + ".jib." + spec.getName() + ".template", spec.getTemplateDirectory()}));
        }
        if (StringUtils.isBlank((String)spec.getTemplateDirectory())) {
            spec.setTemplateDirectory(defaultTemplateDirectory);
        }
    }
}

