/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.release;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Active;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.model.api.common.Apply;
import org.jreleaser.model.api.release.Releaser;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.CommitAuthor;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.EnabledAware;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.Changelog;
import org.jreleaser.model.internal.release.Releaser;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.Env;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.SemanticVersion;

public abstract class BaseReleaser<A extends org.jreleaser.model.api.release.Releaser, S extends BaseReleaser<A, S>>
extends AbstractModelObject<S>
implements Releaser<A> {
    private static final long serialVersionUID = 1051555604419029072L;
    @JsonIgnore
    private final String serviceName;
    private final Changelog changelog = new Changelog();
    private final Milestone milestone = new Milestone();
    private final Issues issues = new Issues();
    private final CommitAuthor commitAuthor = new CommitAuthor();
    private final Update update = new Update();
    private final Prerelease prerelease = new Prerelease();
    @JsonIgnore
    private final boolean releaseSupported;
    @JsonIgnore
    private boolean match = true;
    private Boolean enabled;
    private String host;
    private String owner;
    private String name;
    private String repoUrl;
    private String repoCloneUrl;
    private String commitUrl;
    private String srcUrl;
    private String downloadUrl;
    private String releaseNotesUrl;
    private String latestReleaseUrl;
    private String issueTrackerUrl;
    private String username;
    private String token;
    private String tagName;
    private String previousTagName;
    private String releaseName;
    private String branch;
    private String branchPush;
    protected Boolean sign;
    protected Boolean skipTag;
    protected Boolean skipRelease;
    protected Boolean overwrite;
    private String apiEndpoint;
    private int connectTimeout;
    private int readTimeout;
    protected Boolean artifacts;
    protected Boolean files;
    protected Boolean checksums;
    protected Boolean signatures;
    protected Boolean catalogs;
    private Active uploadAssets;
    protected Boolean uploadAssetsEnabled;
    @JsonIgnore
    private String cachedBranchPush;
    @JsonIgnore
    private String cachedTagName;
    @JsonIgnore
    private String cachedPreviousTagName;
    @JsonIgnore
    private String cachedReleaseName;

    protected BaseReleaser(String serviceName, boolean releaseSupported) {
        this.serviceName = serviceName;
        this.releaseSupported = releaseSupported;
    }

    @Override
    public boolean isReleaseSupported() {
        return this.releaseSupported;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public void merge(S source) {
        this.match = ((BaseReleaser)source).isMatch();
        this.enabled = this.merge(this.enabled, ((BaseReleaser)source).isEnabled());
        this.host = this.merge(this.host, ((BaseReleaser)source).getHost());
        this.owner = this.merge(this.owner, ((BaseReleaser)source).getOwner());
        this.name = this.merge(this.name, ((BaseReleaser)source).getName());
        this.repoUrl = this.merge(this.repoUrl, ((BaseReleaser)source).getRepoUrl());
        this.repoCloneUrl = this.merge(this.repoCloneUrl, ((BaseReleaser)source).getRepoCloneUrl());
        this.commitUrl = this.merge(this.commitUrl, ((BaseReleaser)source).getCommitUrl());
        this.srcUrl = this.merge(this.srcUrl, ((BaseReleaser)source).getSrcUrl());
        this.downloadUrl = this.merge(this.downloadUrl, ((BaseReleaser)source).getDownloadUrl());
        this.releaseNotesUrl = this.merge(this.releaseNotesUrl, ((BaseReleaser)source).getReleaseNotesUrl());
        this.latestReleaseUrl = this.merge(this.latestReleaseUrl, ((BaseReleaser)source).getLatestReleaseUrl());
        this.issueTrackerUrl = this.merge(this.issueTrackerUrl, ((BaseReleaser)source).getIssueTrackerUrl());
        this.username = this.merge(this.username, ((BaseReleaser)source).getUsername());
        this.token = this.merge(this.token, ((BaseReleaser)source).getToken());
        this.tagName = this.merge(this.tagName, ((BaseReleaser)source).getTagName());
        this.previousTagName = this.merge(this.previousTagName, ((BaseReleaser)source).getPreviousTagName());
        this.releaseName = this.merge(this.releaseName, ((BaseReleaser)source).getReleaseName());
        this.branch = this.merge(this.branch, ((BaseReleaser)source).getBranch());
        this.branchPush = this.merge(this.branchPush, ((BaseReleaser)source).getBranchPush());
        this.sign = this.merge(this.sign, ((BaseReleaser)source).sign);
        this.skipTag = this.merge(this.skipTag, ((BaseReleaser)source).skipTag);
        this.skipRelease = this.merge(this.skipRelease, ((BaseReleaser)source).skipRelease);
        this.overwrite = this.merge(this.overwrite, ((BaseReleaser)source).overwrite);
        this.apiEndpoint = this.merge(this.apiEndpoint, ((BaseReleaser)source).getApiEndpoint());
        this.connectTimeout = this.merge(this.getConnectTimeout(), ((BaseReleaser)source).getConnectTimeout());
        this.readTimeout = this.merge(this.getReadTimeout(), ((BaseReleaser)source).getReadTimeout());
        this.artifacts = this.merge(this.artifacts, ((BaseReleaser)source).artifacts);
        this.files = this.merge(this.files, ((BaseReleaser)source).files);
        this.checksums = this.merge(this.checksums, ((BaseReleaser)source).checksums);
        this.signatures = this.merge(this.signatures, ((BaseReleaser)source).signatures);
        this.catalogs = this.merge(this.catalogs, ((BaseReleaser)source).catalogs);
        this.uploadAssets = this.merge(this.uploadAssets, ((BaseReleaser)source).getUploadAssets());
        this.uploadAssetsEnabled = this.merge(this.uploadAssetsEnabled, ((BaseReleaser)source).uploadAssetsEnabled);
        this.setCommitAuthor(((BaseReleaser)source).getCommitAuthor());
        this.setUpdate(((BaseReleaser)source).getUpdate());
        this.setPrerelease(((BaseReleaser)source).getPrerelease());
        this.setChangelog(((BaseReleaser)source).getChangelog());
        this.setMilestone(((BaseReleaser)source).getMilestone());
        this.setIssues(((BaseReleaser)source).getIssues());
    }

    protected Boolean getUploadAssetsEnabled() {
        return this.uploadAssetsEnabled;
    }

    public abstract String getReverseRepoHost();

    public boolean isPrerelease() {
        return this.getPrerelease().isEnabled();
    }

    public String getCanonicalRepoName() {
        if (StringUtils.isNotBlank((String)this.owner)) {
            return this.owner + "/" + this.name;
        }
        return this.name;
    }

    public String getResolvedBranchPush(JReleaserModel model) {
        if (StringUtils.isBlank((String)this.cachedBranchPush)) {
            this.cachedBranchPush = Templates.resolveTemplate((String)this.branchPush, (TemplateContext)this.props(model));
        }
        if (StringUtils.isNotBlank((String)this.cachedBranchPush) && this.cachedBranchPush.contains("{{")) {
            this.cachedBranchPush = Templates.resolveTemplate((String)this.cachedBranchPush, (TemplateContext)this.props(model));
        }
        return this.cachedBranchPush;
    }

    public String getResolvedPreviousTagName(JReleaserModel model) {
        if (StringUtils.isBlank((String)this.cachedPreviousTagName) && StringUtils.isNotBlank((String)this.previousTagName)) {
            this.cachedPreviousTagName = Templates.resolveTemplate((String)this.previousTagName, (TemplateContext)this.props(model));
        }
        if (StringUtils.isNotBlank((String)this.cachedPreviousTagName) && this.cachedPreviousTagName.contains("{{")) {
            this.cachedPreviousTagName = Templates.resolveTemplate((String)this.cachedPreviousTagName, (TemplateContext)this.props(model));
        }
        return this.cachedPreviousTagName;
    }

    public String getResolvedTagName(JReleaserModel model) {
        if (StringUtils.isBlank((String)this.cachedTagName)) {
            this.cachedTagName = Templates.resolveTemplate((String)this.tagName, (TemplateContext)this.props(model));
        }
        if (StringUtils.isNotBlank((String)this.cachedTagName) && this.cachedTagName.contains("{{")) {
            this.cachedTagName = Templates.resolveTemplate((String)this.cachedTagName, (TemplateContext)this.props(model));
        }
        return this.cachedTagName;
    }

    public String getEffectiveTagName(JReleaserModel model) {
        if (model.getProject().isSnapshot()) {
            return model.getProject().getSnapshot().getResolvedLabel(model);
        }
        return this.cachedTagName;
    }

    public String getResolvedReleaseName(JReleaserModel model) {
        if (StringUtils.isBlank((String)this.cachedReleaseName)) {
            this.cachedReleaseName = Templates.resolveTemplate((String)this.releaseName, (TemplateContext)this.props(model));
        }
        if (StringUtils.isNotBlank((String)this.cachedReleaseName) && this.cachedReleaseName.contains("{{")) {
            this.cachedReleaseName = Templates.resolveTemplate((String)this.cachedReleaseName, (TemplateContext)this.props(model));
        }
        return this.cachedReleaseName;
    }

    public String getEffectiveReleaseName() {
        return this.cachedReleaseName;
    }

    public String getResolvedRepoUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.repoUrl, (TemplateContext)this.props(model));
    }

    public String getResolvedRepoCloneUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.repoCloneUrl, (TemplateContext)this.props(model));
    }

    public String getResolvedRepoUrl(JReleaserModel model, String repoOwner, String repoName) {
        if (!this.releaseSupported) {
            return "";
        }
        TemplateContext props = this.props(model);
        props.set("repoOwner", (Object)repoOwner);
        props.set("repoName", (Object)repoName);
        return Templates.resolveTemplate((String)this.repoUrl, (TemplateContext)props);
    }

    public String getResolvedRepoCloneUrl(JReleaserModel model, String repoOwner, String repoName) {
        if (!this.releaseSupported) {
            return "";
        }
        TemplateContext props = this.props(model);
        props.set("repoOwner", (Object)repoOwner);
        props.set("repoName", (Object)repoName);
        return Templates.resolveTemplate((String)this.repoCloneUrl, (TemplateContext)props);
    }

    public String getResolvedCommitUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.commitUrl, (TemplateContext)this.props(model));
    }

    public String getResolvedSrcUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.srcUrl, (TemplateContext)this.props(model));
    }

    public String getResolvedDownloadUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.downloadUrl, (TemplateContext)this.props(model));
    }

    public String getResolvedReleaseNotesUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.releaseNotesUrl, (TemplateContext)this.props(model));
    }

    public String getResolvedLatestReleaseUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.latestReleaseUrl, (TemplateContext)this.props(model));
    }

    public String getResolvedIssueTrackerUrl(JReleaserModel model, boolean appendSlash) {
        if (!this.releaseSupported) {
            return "";
        }
        String issueTracker = Templates.resolveTemplate((String)this.issueTrackerUrl, (TemplateContext)this.props(model));
        if (appendSlash && StringUtils.isNotBlank((String)issueTracker) && !issueTracker.endsWith("/")) {
            issueTracker = issueTracker + "/";
        }
        return issueTracker;
    }

    public boolean resolveUploadAssetsEnabled(Project project) {
        if (null == this.uploadAssets) {
            this.uploadAssets = Active.ALWAYS;
        }
        this.uploadAssetsEnabled = this.uploadAssets.check((Active.Releaseable)project, (Active.Prereleaseable)this);
        return this.uploadAssetsEnabled;
    }

    public boolean isMatch() {
        return this.match;
    }

    public void setMatch(boolean match) {
        this.match = match;
    }

    @Override
    public boolean isEnabled() {
        return null != this.enabled && this.enabled != false;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabledSet() {
        return null != this.enabled;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRepoUrl() {
        return this.repoUrl;
    }

    public void setRepoUrl(String repoUrl) {
        this.repoUrl = repoUrl;
    }

    public String getRepoCloneUrl() {
        return this.repoCloneUrl;
    }

    public void setRepoCloneUrl(String repoCloneUrl) {
        this.repoCloneUrl = repoCloneUrl;
    }

    public String getCommitUrl() {
        return this.commitUrl;
    }

    public void setCommitUrl(String commitUrl) {
        this.commitUrl = commitUrl;
    }

    public String getSrcUrl() {
        return this.srcUrl;
    }

    public void setSrcUrl(String srcUrl) {
        this.srcUrl = srcUrl;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public String getReleaseNotesUrl() {
        return this.releaseNotesUrl;
    }

    public void setReleaseNotesUrl(String releaseNotesUrl) {
        this.releaseNotesUrl = releaseNotesUrl;
    }

    public String getLatestReleaseUrl() {
        return this.latestReleaseUrl;
    }

    public void setLatestReleaseUrl(String latestReleaseUrl) {
        this.latestReleaseUrl = latestReleaseUrl;
    }

    public String getIssueTrackerUrl() {
        return this.issueTrackerUrl;
    }

    public void setIssueTrackerUrl(String issueTrackerUrl) {
        this.issueTrackerUrl = issueTrackerUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.cachedTagName = null;
        this.tagName = tagName;
    }

    public String getPreviousTagName() {
        return this.previousTagName;
    }

    public void setPreviousTagName(String previousTagName) {
        this.cachedPreviousTagName = null;
        this.previousTagName = previousTagName;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public void setReleaseName(String releaseName) {
        this.cachedReleaseName = null;
        this.releaseName = releaseName;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getBranchPush() {
        return this.branchPush;
    }

    public void setBranchPush(String branchPush) {
        this.branchPush = branchPush;
    }

    @Override
    public CommitAuthor getCommitAuthor() {
        return this.commitAuthor;
    }

    @Override
    public void setCommitAuthor(CommitAuthor commitAuthor) {
        this.commitAuthor.merge(commitAuthor);
    }

    public Prerelease getPrerelease() {
        return this.prerelease;
    }

    public void setPrerelease(Prerelease prerelease) {
        this.prerelease.merge(prerelease);
    }

    public boolean isSign() {
        return null != this.sign && this.sign != false;
    }

    public void setSign(Boolean sign) {
        this.sign = sign;
    }

    public Changelog getChangelog() {
        return this.changelog;
    }

    public void setChangelog(Changelog changelog) {
        this.changelog.merge(changelog);
    }

    public Milestone getMilestone() {
        return this.milestone;
    }

    public void setMilestone(Milestone milestone) {
        this.milestone.merge(milestone);
    }

    public Issues getIssues() {
        return this.issues;
    }

    public void setIssues(Issues issues) {
        this.issues.merge(issues);
    }

    public boolean isSkipTag() {
        return null != this.skipTag && this.skipTag != false;
    }

    public void setSkipTag(Boolean skipTag) {
        this.skipTag = skipTag;
    }

    public boolean isSkipTagSet() {
        return null != this.skipTag;
    }

    public boolean isSkipRelease() {
        return null != this.skipRelease && this.skipRelease != false;
    }

    public void setSkipRelease(Boolean skipRelease) {
        this.skipRelease = skipRelease;
    }

    public boolean isSkipReleaseSet() {
        return null != this.skipRelease;
    }

    public boolean isOverwrite() {
        return null != this.overwrite && this.overwrite != false;
    }

    public void setOverwrite(Boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isOverwriteSet() {
        return null != this.overwrite;
    }

    public Update getUpdate() {
        return this.update;
    }

    public void setUpdate(Update update) {
        this.update.merge(update);
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public void setApiEndpoint(String apiEndpoint) {
        this.apiEndpoint = apiEndpoint;
    }

    @Override
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isArtifactsSet() {
        return null != this.artifacts;
    }

    public boolean isArtifacts() {
        return null == this.artifacts || this.artifacts != false;
    }

    public void setArtifacts(Boolean artifacts) {
        this.artifacts = artifacts;
    }

    public boolean isFiles() {
        return null == this.files || this.files != false;
    }

    public void setFiles(Boolean files) {
        this.files = files;
    }

    public boolean isFilesSet() {
        return null != this.files;
    }

    public boolean isChecksumsSet() {
        return null != this.checksums;
    }

    public boolean isChecksums() {
        return null == this.checksums || this.checksums != false;
    }

    public void setChecksums(Boolean checksums) {
        this.checksums = checksums;
    }

    public boolean isCatalogsSet() {
        return null != this.catalogs;
    }

    public boolean isCatalogs() {
        return null == this.catalogs || this.catalogs != false;
    }

    public void setCatalogs(Boolean catalogs) {
        this.catalogs = catalogs;
    }

    public boolean isSignaturesSet() {
        return null != this.signatures;
    }

    public boolean isSignatures() {
        return null == this.signatures || this.signatures != false;
    }

    public void setSignatures(Boolean signatures) {
        this.signatures = signatures;
    }

    public Active getUploadAssets() {
        return this.uploadAssets;
    }

    public void setUploadAssets(Active uploadAssets) {
        this.uploadAssets = uploadAssets;
    }

    public void setUploadAssets(String str) {
        this.setUploadAssets(Active.of((String)str));
    }

    public boolean isUploadAssetsSet() {
        return null != this.uploadAssets;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("host", this.host);
        map.put("owner", this.owner);
        map.put("name", this.name);
        map.put("username", this.username);
        map.put("token", StringUtils.isNotBlank((String)this.token) ? "************" : "**unset**");
        if (this.releaseSupported) {
            map.put("uploadAssets", this.uploadAssets);
            map.put("artifacts", this.isArtifacts());
            map.put("files", this.isFiles());
            map.put("checksums", this.isChecksums());
            map.put("catalogs", this.isCatalogs());
            map.put("signatures", this.isSignatures());
            map.put("repoUrl", this.repoUrl);
            map.put("repoCloneUrl", this.repoCloneUrl);
            map.put("commitUrl", this.commitUrl);
            map.put("srcUrl", this.srcUrl);
            map.put("downloadUrl", this.downloadUrl);
            map.put("releaseNotesUrl", this.releaseNotesUrl);
            map.put("latestReleaseUrl", this.latestReleaseUrl);
            map.put("issueTrackerUrl", this.issueTrackerUrl);
        }
        map.put("tagName", this.tagName);
        map.put("previousTagName", this.previousTagName);
        if (this.releaseSupported) {
            map.put("releaseName", this.releaseName);
        }
        map.put("branch", this.branch);
        map.put("branchPush", this.branchPush);
        map.put("commitAuthor", this.commitAuthor.asMap(full));
        map.put("sign", this.isSign());
        map.put("skipTag", this.isSkipTag());
        map.put("skipRelease", this.isSkipRelease());
        map.put("overwrite", this.isOverwrite());
        if (this.releaseSupported) {
            map.put("update", this.update.asMap(full));
            map.put("apiEndpoint", this.apiEndpoint);
            map.put("connectTimeout", this.connectTimeout);
            map.put("readTimeout", this.readTimeout);
        }
        map.put("changelog", this.changelog.asMap(full));
        if (this.releaseSupported) {
            map.put("milestone", this.milestone.asMap(full));
            map.put("issues", this.issues.asMap(full));
        }
        map.put("prerelease", this.prerelease.asMap(full));
        return map;
    }

    public TemplateContext props(JReleaserModel model) {
        TemplateContext props = new TemplateContext();
        Project project = model.getProject();
        props.setAll(model.getEnvironment().getProperties());
        props.setAll(model.getEnvironment().getSourcedProperties());
        props.set("projectName", (Object)project.getName());
        props.set("projectNameCapitalized", (Object)StringUtils.getCapitalizedName((String)project.getName()));
        props.set("projectVersion", (Object)project.getVersion());
        props.set("projectStereotype", (Object)project.getStereotype());
        props.set("projectEffectiveVersion", (Object)project.getEffectiveVersion());
        props.set("projectSnapshot", (Object)String.valueOf(project.isSnapshot()));
        if (StringUtils.isNotBlank((String)project.getDescription())) {
            props.set("projectDescription", (Object)MustacheUtils.passThrough((String)project.getDescription()));
        }
        if (StringUtils.isNotBlank((String)project.getLongDescription())) {
            props.set("projectLongDescription", (Object)MustacheUtils.passThrough((String)project.getLongDescription()));
        }
        if (StringUtils.isNotBlank((String)project.getLicense())) {
            props.set("projectLicense", (Object)project.getLicense());
        }
        if (null != project.getInceptionYear()) {
            props.set("projectInceptionYear", (Object)project.getInceptionYear());
        }
        if (StringUtils.isNotBlank((String)project.getCopyright())) {
            props.set("projectCopyright", (Object)project.getCopyright());
        }
        if (StringUtils.isNotBlank((String)project.getVendor())) {
            props.set("projectVendor", (Object)project.getVendor());
        }
        project.getLinks().fillProps(props);
        if (project.getJava().isEnabled()) {
            props.setAll(project.getJava().resolvedExtraProperties());
            props.set("projectJavaGroupId", (Object)project.getJava().getGroupId());
            props.set("projectJavaArtifactId", (Object)project.getJava().getArtifactId());
            String javaVersion = project.getJava().getVersion();
            props.set("projectJavaVersion", (Object)javaVersion);
            props.set("projectJavaMainClass", (Object)project.getJava().getMainClass());
            if (StringUtils.isNotBlank((String)javaVersion)) {
                SemanticVersion jv = SemanticVersion.of((String)javaVersion);
                props.set("projectJavaVersionMajor", (Object)jv.getMajor());
                if (jv.hasMinor()) {
                    props.set("projectJavaVersionMinor", (Object)jv.getMinor());
                }
                if (jv.hasPatch()) {
                    props.set("projectJavaVersionPatch", (Object)jv.getPatch());
                }
                if (jv.hasTag()) {
                    props.set("projectJavaVersionTag", (Object)jv.getTag());
                }
                if (jv.hasBuild()) {
                    props.set("projectJavaVersionBuild", (Object)jv.getBuild());
                }
            }
        }
        project.parseVersion();
        props.setAll(project.resolvedExtraProperties());
        String osName = PlatformUtils.getDetectedOs();
        String osArch = PlatformUtils.getDetectedArch();
        props.set("osName", (Object)osName);
        props.set("osArch", (Object)osArch);
        props.set("osVersion", (Object)PlatformUtils.getDetectedVersion());
        props.set("osPlatform", (Object)PlatformUtils.getCurrentFull());
        props.set("osPlatformReplaced", (Object)model.getPlatform().applyReplacements(PlatformUtils.getCurrentFull()));
        props.set("repoHost", (Object)this.host);
        props.set("repoOwner", (Object)this.owner);
        props.set("repoName", (Object)this.name);
        props.set("repoBranch", (Object)this.branch);
        props.set("repoBranchPush", (Object)this.cachedBranchPush);
        props.set("reverseRepoHost", (Object)this.getReverseRepoHost());
        props.set("repoCanonicalName", (Object)this.getCanonicalRepoName());
        props.set("tagName", (Object)(project.isSnapshot() ? project.getSnapshot().getResolvedLabel(model) : this.cachedTagName));
        props.set("previousTagName", (Object)this.cachedPreviousTagName);
        props.set("releaseName", (Object)this.cachedReleaseName);
        props.set("milestoneName", (Object)this.milestone.getEffectiveName());
        MustacheUtils.applyTemplates((TemplateContext)props, project.resolvedExtraProperties());
        props.set("__ZonedDateTime_now__", (Object)model.getNow());
        return props;
    }

    public void fillProps(TemplateContext props, JReleaserModel model) {
        props.set("repoHost", (Object)this.host);
        props.set("repoOwner", (Object)this.owner);
        props.set("repoName", (Object)this.name);
        props.set("repoBranch", (Object)this.branch);
        props.set("repoBranchPush", (Object)this.getResolvedBranchPush(model));
        props.set("reverseRepoHost", (Object)this.getReverseRepoHost());
        props.set("repoCanonicalName", (Object)this.getCanonicalRepoName());
        props.set("tagName", (Object)this.getEffectiveTagName(model));
        props.set("previousTagName", (Object)this.getResolvedPreviousTagName(model));
        props.set("releaseName", (Object)this.getEffectiveReleaseName());
        props.set("milestoneName", (Object)this.milestone.getEffectiveName());
        props.set("repoUrl", (Object)this.getResolvedRepoUrl(model));
        props.set("repoCloneUrl", (Object)this.getResolvedRepoCloneUrl(model));
        props.set("commitsUrl", (Object)this.getResolvedCommitUrl(model));
        props.set("srcUrl", (Object)this.getResolvedSrcUrl(model));
        props.set("releaseNotesUrl", (Object)this.getResolvedReleaseNotesUrl(model));
        props.set("latestReleaseUrl", (Object)this.getResolvedLatestReleaseUrl(model));
        props.set("issueTrackerUrl", (Object)this.getResolvedIssueTrackerUrl(model, false));
    }

    public static final class Issues
    extends AbstractModelObject<Issues>
    implements Domain,
    EnabledAware {
        private static final long serialVersionUID = -8544658826532962076L;
        private final Label label = new Label();
        private Apply applyMilestone;
        private String comment;
        private Boolean enabled;
        @JsonIgnore
        private final Releaser.Issues immutable = new Releaser.Issues(){
            private static final long serialVersionUID = 7857893617001154950L;

            public String getComment() {
                return comment;
            }

            public Apply getApplyMilestone() {
                return applyMilestone;
            }

            public Releaser.Issues.Label getLabel() {
                return label.asImmutable();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }
        };

        public Releaser.Issues asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Issues source) {
            this.comment = this.merge(this.comment, source.comment);
            this.enabled = this.merge(this.enabled, source.enabled);
            this.applyMilestone = this.merge(this.applyMilestone, source.applyMilestone);
            this.setLabel(source.label);
        }

        @Override
        public boolean isEnabled() {
            return null != this.enabled && this.enabled != false;
        }

        @Override
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabledSet() {
            return null != this.enabled;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public Label getLabel() {
            return this.label;
        }

        public void setLabel(Label label) {
            this.label.merge(label);
        }

        public Apply getApplyMilestone() {
            return this.applyMilestone;
        }

        public void setApplyMilestone(Apply applyMilestone) {
            this.applyMilestone = applyMilestone;
        }

        public void setApplyMilestone(String str) {
            this.setApplyMilestone(Apply.of((String)str));
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("comment", this.comment);
            map.put("label", this.label.asMap(full));
            map.put("applyMilestone", this.applyMilestone);
            return map;
        }

        public static final class Label
        extends AbstractModelObject<Label>
        implements Domain {
            private static final long serialVersionUID = 6951467063217168128L;
            private String name;
            private String color;
            private String description;
            @JsonIgnore
            private final Releaser.Issues.Label immutable = new Releaser.Issues.Label(){
                private static final long serialVersionUID = 8642359487826561699L;

                public String getName() {
                    return name;
                }

                public String getColor() {
                    return color;
                }

                public String getDescription() {
                    return description;
                }

                public Map<String, Object> asMap(boolean full) {
                    return Collections.unmodifiableMap(this.asMap(full));
                }
            };

            public Releaser.Issues.Label asImmutable() {
                return this.immutable;
            }

            @Override
            public void merge(Label source) {
                this.name = this.merge(this.name, source.name);
                this.color = this.merge(this.color, source.color);
                this.description = this.merge(this.description, source.description);
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getColor() {
                return this.color;
            }

            public void setColor(String color) {
                this.color = color;
            }

            public String getDescription() {
                return this.description;
            }

            public void setDescription(String description) {
                this.description = description;
            }

            @Override
            public Map<String, Object> asMap(boolean full) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("name", this.name);
                map.put("color", this.color);
                map.put("description", this.description);
                return map;
            }
        }
    }

    public static final class Milestone
    extends AbstractModelObject<Milestone>
    implements Domain {
        private static final long serialVersionUID = 5385291379888571159L;
        private Boolean close;
        private String name;
        @JsonIgnore
        private final Releaser.Milestone immutable = new Releaser.Milestone(){
            private static final long serialVersionUID = 2957887352276816797L;

            public boolean isClose() {
                return this.isClose();
            }

            public String getName() {
                return name;
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };
        @JsonIgnore
        private String cachedName;

        public Releaser.Milestone asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Milestone source) {
            this.close = this.merge(this.close, source.close);
            this.name = this.merge(this.name, source.name);
        }

        public String getConfiguredName() {
            return Env.env((String)"MILESTONE_NAME", (String)this.cachedName);
        }

        public String getResolvedName(TemplateContext props) {
            if (StringUtils.isBlank((String)this.cachedName)) {
                this.cachedName = this.getConfiguredName();
            }
            if (StringUtils.isBlank((String)this.cachedName)) {
                this.cachedName = Templates.resolveTemplate((String)this.name, (TemplateContext)props);
            } else if (this.cachedName.contains("{{")) {
                this.cachedName = Templates.resolveTemplate((String)this.cachedName, (TemplateContext)props);
            }
            return this.cachedName;
        }

        public String getEffectiveName() {
            return this.cachedName;
        }

        public boolean isClose() {
            return null == this.close || this.close != false;
        }

        public void setClose(Boolean close) {
            this.close = close;
        }

        public boolean isCloseSet() {
            return null != this.close;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", this.name);
            map.put("close", this.isClose());
            return map;
        }
    }

    public static final class Prerelease
    extends AbstractModelObject<Prerelease>
    implements Domain,
    EnabledAware {
        private static final long serialVersionUID = -7358833182369685133L;
        private Boolean enabled;
        private String pattern;
        @JsonIgnore
        private final Releaser.Prerelease immutable = new Releaser.Prerelease(){
            private static final long serialVersionUID = -862797136353472181L;

            public boolean isPrerelease(String version) {
                return this.isPrerelease(version);
            }

            public String getPattern() {
                return pattern;
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }
        };

        public Releaser.Prerelease asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Prerelease source) {
            this.enabled = this.merge(this.enabled, source.enabled);
            this.pattern = this.merge(this.pattern, source.pattern);
        }

        public void disable() {
            this.enabled = false;
        }

        @Override
        public boolean isEnabled() {
            return null != this.enabled && this.enabled != false;
        }

        @Override
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabledSet() {
            return null != this.enabled;
        }

        public boolean isPrerelease(String version) {
            if (null == this.enabled) {
                String configuredPattern = this.getConfiguredPattern();
                this.enabled = StringUtils.isNotBlank((String)configuredPattern) ? Boolean.valueOf(version.matches(configuredPattern)) : Boolean.valueOf(false);
            }
            return this.enabled;
        }

        public String getConfiguredPattern() {
            return Env.env((String)"PRERELEASE_PATTERN", (String)this.pattern);
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("pattern", this.getConfiguredPattern());
            return map;
        }
    }

    public static final class Update
    extends AbstractModelObject<Update>
    implements Domain,
    EnabledAware {
        private static final long serialVersionUID = -3809529510256990035L;
        private final Set<UpdateSection> sections = new LinkedHashSet<UpdateSection>();
        private Boolean enabled;
        @JsonIgnore
        private final Releaser.Update immutable = new Releaser.Update(){
            private static final long serialVersionUID = -7253526159752557224L;

            public Set<UpdateSection> getSections() {
                return Collections.unmodifiableSet(sections);
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }
        };

        public Releaser.Update asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Update source) {
            this.enabled = this.merge(this.enabled, source.enabled);
            this.setSections(this.merge(this.sections, source.sections));
        }

        @Override
        public boolean isEnabled() {
            return null != this.enabled && this.enabled != false;
        }

        @Override
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabledSet() {
            return null != this.enabled;
        }

        public Set<UpdateSection> getSections() {
            return this.sections;
        }

        public void setSections(Set<UpdateSection> sections) {
            this.sections.clear();
            this.sections.addAll(sections);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("sections", this.sections);
            return map;
        }
    }
}

