/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.api.common.Domain;
import org.jreleaser.model.api.packagers.WingetPackager;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.packagers.AbstractRepositoryPackager;
import org.jreleaser.model.internal.packagers.PackagerRepository;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class WingetPackager
extends AbstractRepositoryPackager<org.jreleaser.model.api.packagers.WingetPackager, WingetPackager> {
    private static final long serialVersionUID = -9015011090998365168L;
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private final WingetRepository repository = new WingetRepository();
    private final List<String> tags = new ArrayList<String>();
    @JsonProperty(value="package")
    private final Package pack = new Package();
    private final Publisher publisher = new Publisher();
    private final Installer installer = new Installer();
    private String defaultLocale;
    private String author;
    private String moniker;
    private String minimumOsVersion;
    private String productCode;
    @JsonIgnore
    private final org.jreleaser.model.api.packagers.WingetPackager immutable = new org.jreleaser.model.api.packagers.WingetPackager(){
        private static final long serialVersionUID = 4117704008560830372L;

        public WingetPackager.Package getPackage() {
            return WingetPackager.this.getPackage().asImmutable();
        }

        public WingetPackager.Publisher getPublisher() {
            return WingetPackager.this.getPublisher().asImmutable();
        }

        public WingetPackager.Installer getInstaller() {
            return WingetPackager.this.getInstaller().asImmutable();
        }

        public String getDefaultLocale() {
            return WingetPackager.this.getDefaultLocale();
        }

        public String getAuthor() {
            return WingetPackager.this.getAuthor();
        }

        public String getMoniker() {
            return WingetPackager.this.getMoniker();
        }

        public List<String> getTags() {
            return Collections.unmodifiableList(WingetPackager.this.getTags());
        }

        public String getMinimumOsVersion() {
            return WingetPackager.this.getMinimumOsVersion();
        }

        public String getProductCode() {
            return WingetPackager.this.getProductCode();
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getRepository() {
            return WingetPackager.this.repository.asImmutable();
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getPackagerRepository() {
            return this.getRepository();
        }

        public CommitAuthor getCommitAuthor() {
            return WingetPackager.this.getCommitAuthor().asImmutable();
        }

        public String getTemplateDirectory() {
            return WingetPackager.this.getTemplateDirectory();
        }

        public List<String> getSkipTemplates() {
            return Collections.unmodifiableList(WingetPackager.this.getSkipTemplates());
        }

        public String getType() {
            return WingetPackager.this.getType();
        }

        public String getDownloadUrl() {
            return WingetPackager.this.getDownloadUrl();
        }

        public boolean supportsPlatform(String platform) {
            return WingetPackager.this.supportsPlatform(platform);
        }

        public boolean supportsDistribution(Distribution.DistributionType distributionType) {
            return WingetPackager.this.supportsDistribution(distributionType);
        }

        public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
            return WingetPackager.this.getSupportedFileExtensions(distributionType);
        }

        public Set<Stereotype> getSupportedStereotypes() {
            return WingetPackager.this.getSupportedStereotypes();
        }

        public boolean isSnapshotSupported() {
            return WingetPackager.this.isSnapshotSupported();
        }

        public boolean isContinueOnError() {
            return WingetPackager.this.isContinueOnError();
        }

        public Active getActive() {
            return WingetPackager.this.getActive();
        }

        public boolean isEnabled() {
            return WingetPackager.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(WingetPackager.this.asMap(full));
        }

        public String getPrefix() {
            return WingetPackager.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(WingetPackager.this.getExtraProperties());
        }
    };

    public WingetPackager() {
        super("winget");
    }

    @Override
    public org.jreleaser.model.api.packagers.WingetPackager asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(WingetPackager source) {
        super.merge(source);
        this.defaultLocale = this.merge(this.defaultLocale, source.defaultLocale);
        this.author = this.merge(this.author, source.author);
        this.moniker = this.merge(this.moniker, source.moniker);
        this.minimumOsVersion = this.merge(this.minimumOsVersion, source.minimumOsVersion);
        this.productCode = this.merge(this.productCode, source.productCode);
        this.setPackage(source.pack);
        this.setPublisher(source.publisher);
        this.setInstaller(source.installer);
        this.setRepository(source.repository);
        this.setTags(this.merge(this.tags, source.tags));
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(String defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getMoniker() {
        return this.moniker;
    }

    public void setMoniker(String moniker) {
        this.moniker = moniker;
    }

    public String getMinimumOsVersion() {
        return this.minimumOsVersion;
    }

    public void setMinimumOsVersion(String minimumOsVersion) {
        this.minimumOsVersion = minimumOsVersion;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags.clear();
        this.tags.addAll(tags);
    }

    @JsonProperty(value="package")
    public Package getPackage() {
        return this.pack;
    }

    public void setPackage(Package pack) {
        this.pack.merge(pack);
    }

    public Publisher getPublisher() {
        return this.publisher;
    }

    public void setPublisher(Publisher publisher) {
        this.publisher.merge(publisher);
    }

    public Installer getInstaller() {
        return this.installer;
    }

    public void setInstaller(Installer installer) {
        this.installer.merge(installer);
    }

    public WingetRepository getRepository() {
        return this.repository;
    }

    public void setRepository(WingetRepository repository) {
        this.repository.merge(repository);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("defaultLocale", this.defaultLocale);
        props.put("author", this.author);
        props.put("moniker", this.moniker);
        props.put("minimumOsVersion", this.minimumOsVersion);
        props.put("productCode", this.productCode);
        props.put("package", this.pack.asMap(full));
        props.put("publisher", this.publisher.asMap(full));
        props.put("installer", this.installer.asMap(full));
        props.put("repository", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.getPackagerRepository();
    }

    public PackagerRepository getPackagerRepository() {
        return this.getRepository();
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isWindows((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution.DistributionType distributionType) {
        return SUPPORTED.containsKey(distributionType);
    }

    @Override
    public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault(distributionType, Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get("skipWinget"));
    }

    static {
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, CollectionUtils.setOf((Object[])new String[]{FileType.ZIP.extension()}));
        SUPPORTED.put(Distribution.DistributionType.BINARY, CollectionUtils.setOf((Object[])new String[]{FileType.ZIP.extension()}));
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, CollectionUtils.setOf((Object[])new String[]{FileType.ZIP.extension()}));
        SUPPORTED.put(Distribution.DistributionType.JLINK, CollectionUtils.setOf((Object[])new String[]{FileType.ZIP.extension()}));
        SUPPORTED.put(Distribution.DistributionType.NATIVE_PACKAGE, CollectionUtils.setOf((Object[])new String[]{FileType.MSI.extension(), FileType.EXE.extension()}));
    }

    public static final class Installer
    extends AbstractModelObject<Installer>
    implements Domain {
        private static final long serialVersionUID = -5585999592531263933L;
        private final Set<WingetPackager.Installer.Mode> modes = new LinkedHashSet<WingetPackager.Installer.Mode>();
        private WingetPackager.Installer.Type type = WingetPackager.Installer.Type.WIX;
        private WingetPackager.Installer.Scope scope = WingetPackager.Installer.Scope.MACHINE;
        private WingetPackager.Installer.UpgradeBehavior upgradeBehavior = WingetPackager.Installer.UpgradeBehavior.INSTALL;
        private String command;
        @JsonIgnore
        private final WingetPackager.Installer immutable = new WingetPackager.Installer(){
            private static final long serialVersionUID = 1422885238324458482L;

            public WingetPackager.Installer.Type getType() {
                return this.getType();
            }

            public WingetPackager.Installer.Scope getScope() {
                return this.getScope();
            }

            public Set<WingetPackager.Installer.Mode> getModes() {
                return Collections.unmodifiableSet(this.getModes());
            }

            public WingetPackager.Installer.UpgradeBehavior getUpgradeBehavior() {
                return this.getUpgradeBehavior();
            }

            public String getCommand() {
                return this.getCommand();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public WingetPackager.Installer asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Installer source) {
            this.type = this.merge(this.type, source.type);
            this.scope = this.merge(this.scope, source.scope);
            this.upgradeBehavior = this.merge(this.upgradeBehavior, source.upgradeBehavior);
            this.command = this.merge(this.command, source.command);
            this.setModes(this.merge(this.modes, source.modes));
        }

        public WingetPackager.Installer.Type getType() {
            return this.type;
        }

        public void setType(WingetPackager.Installer.Type type) {
            this.type = type;
        }

        public void setType(String str) {
            this.setType(WingetPackager.Installer.Type.of((String)str));
        }

        public WingetPackager.Installer.Scope getScope() {
            return this.scope;
        }

        public void setScope(WingetPackager.Installer.Scope scope) {
            this.scope = scope;
        }

        public void setScope(String str) {
            this.setScope(WingetPackager.Installer.Scope.of((String)str));
        }

        public WingetPackager.Installer.UpgradeBehavior getUpgradeBehavior() {
            return this.upgradeBehavior;
        }

        public void setUpgradeBehavior(WingetPackager.Installer.UpgradeBehavior upgradeBehavior) {
            this.upgradeBehavior = upgradeBehavior;
        }

        public void setUpgradeBehavior(String str) {
            this.setUpgradeBehavior(WingetPackager.Installer.UpgradeBehavior.of((String)str));
        }

        public Set<WingetPackager.Installer.Mode> getModes() {
            return this.modes;
        }

        public void setModes(Set<WingetPackager.Installer.Mode> modes) {
            this.modes.clear();
            this.modes.addAll(modes);
        }

        public String getCommand() {
            return this.command;
        }

        public void setCommand(String command) {
            this.command = command;
        }

        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("type", this.type);
            props.put("scope", this.scope);
            props.put("upgradeBehavior", this.upgradeBehavior);
            props.put("modes", this.modes);
            props.put("command", this.command);
            return props;
        }
    }

    public static final class Publisher
    extends AbstractModelObject<Publisher>
    implements Domain {
        private static final long serialVersionUID = -3812598331451051428L;
        private String name;
        private String url;
        private String supportUrl;
        @JsonIgnore
        private final WingetPackager.Publisher immutable = new WingetPackager.Publisher(){
            private static final long serialVersionUID = -5458105963902729331L;

            public String getName() {
                return this.getName();
            }

            public String getUrl() {
                return this.getUrl();
            }

            public String getSupportUrl() {
                return this.getSupportUrl();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public WingetPackager.Publisher asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Publisher source) {
            this.name = this.merge(this.name, source.name);
            this.url = this.merge(this.url, source.url);
            this.supportUrl = this.merge(this.supportUrl, source.supportUrl);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getSupportUrl() {
            return this.supportUrl;
        }

        public void setSupportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
        }

        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("name", this.name);
            props.put("url", this.url);
            props.put("supportUrl", this.supportUrl);
            return props;
        }
    }

    public static final class Package
    extends AbstractModelObject<Package>
    implements Domain {
        private static final long serialVersionUID = -8531840172639009180L;
        private String identifier;
        private String name;
        private String version;
        private String url;
        @JsonIgnore
        private final WingetPackager.Package immutable = new WingetPackager.Package(){
            private static final long serialVersionUID = -681067573112565263L;

            public String getIdentifier() {
                return this.getIdentifier();
            }

            public String getName() {
                return this.getName();
            }

            public String getUrl() {
                return this.getUrl();
            }

            public String getVersion() {
                return this.getVersion();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public WingetPackager.Package asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Package source) {
            this.identifier = this.merge(this.identifier, source.identifier);
            this.name = this.merge(this.name, source.name);
            this.version = this.merge(this.version, source.version);
            this.url = this.merge(this.url, source.url);
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("identifier", this.identifier);
            props.put("name", this.name);
            props.put("version", this.version);
            props.put("url", this.url);
            return props;
        }
    }

    public static final class WingetRepository
    extends PackagerRepository {
        private static final long serialVersionUID = -3859984358170896375L;

        public WingetRepository() {
            super("winget", "winget");
        }
    }
}

