/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.util.Set;
import org.jreleaser.cli.AbstractCommand;
import org.jreleaser.cli.AbstractModelCommand;
import org.jreleaser.cli.Main;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.workflow.Workflows;
import picocli.CommandLine;

@CommandLine.Command(name="download")
public class Download
extends AbstractModelCommand<Main> {
    @CommandLine.Option(names={"--dry-run"})
    Boolean dryrun;
    @CommandLine.ArgGroup
    Composite composite;

    @Override
    protected void collectCandidateDeprecatedArgs(Set<AbstractCommand.DeprecatedArg> args) {
        super.collectCandidateDeprecatedArgs(args);
        args.add(new AbstractCommand.DeprecatedArg("-d", "--downloader", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-dn", "--downloader-name", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-xd", "--exclude-downloader", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-xdn", "--exclude-downloader-name", "1.5.0"));
    }

    @Override
    protected void doExecute(JReleaserContext context) {
        if (null != this.composite) {
            context.setIncludedDownloaderTypes(this.collectEntries(this.composite.includedDownloaderTypes(), true));
            context.setIncludedDownloaderNames(this.collectEntries(this.composite.includedDownloaderNames()));
            context.setExcludedDownloaderTypes(this.collectEntries(this.composite.excludedDownloaderTypes(), true));
            context.setExcludedDownloaderNames(this.collectEntries(this.composite.excludedDownloaderNames()));
        }
        Workflows.download((JReleaserContext)context).execute();
    }

    @Override
    protected Boolean dryrun() {
        return this.dryrun;
    }

    @Override
    protected JReleaserContext.Mode getMode() {
        return JReleaserContext.Mode.DOWNLOAD;
    }

    static class Exclude {
        @CommandLine.Option(names={"-xd", "--exclude-downloader"}, paramLabel="<downloader>")
        String[] excludedDownloaderTypes;
        @CommandLine.Option(names={"-xdn", "--exclude-downloader-name"}, paramLabel="<name>")
        String[] excludedDownloaderNames;

        Exclude() {
        }
    }

    static class Include {
        @CommandLine.Option(names={"-d", "--downloader"}, paramLabel="<downloader>")
        String[] includedDownloaderTypes;
        @CommandLine.Option(names={"-dn", "--downloader-name"}, paramLabel="<name>")
        String[] includedDownloaderNames;

        Include() {
        }
    }

    static class Composite {
        @CommandLine.ArgGroup(exclusive=false, order=1, headingKey="include.filter.header")
        Include include;
        @CommandLine.ArgGroup(exclusive=false, order=2, headingKey="exclude.filter.header")
        Exclude exclude;

        Composite() {
        }

        String[] includedDownloaderTypes() {
            return null != this.include ? this.include.includedDownloaderTypes : null;
        }

        String[] includedDownloaderNames() {
            return null != this.include ? this.include.includedDownloaderNames : null;
        }

        String[] excludedDownloaderTypes() {
            return null != this.exclude ? this.exclude.excludedDownloaderTypes : null;
        }

        String[] excludedDownloaderNames() {
            return null != this.exclude ? this.exclude.excludedDownloaderNames : null;
        }
    }
}

