/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.distributions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.JReleaserOutput;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.common.Artifact;
import org.jreleaser.model.api.common.Executable;
import org.jreleaser.model.api.common.Java;
import org.jreleaser.model.api.packagers.AppImagePackager;
import org.jreleaser.model.api.packagers.AsdfPackager;
import org.jreleaser.model.api.packagers.BrewPackager;
import org.jreleaser.model.api.packagers.ChocolateyPackager;
import org.jreleaser.model.api.packagers.DockerPackager;
import org.jreleaser.model.api.packagers.FlatpakPackager;
import org.jreleaser.model.api.packagers.GofishPackager;
import org.jreleaser.model.api.packagers.JbangPackager;
import org.jreleaser.model.api.packagers.MacportsPackager;
import org.jreleaser.model.api.packagers.ScoopPackager;
import org.jreleaser.model.api.packagers.SdkmanPackager;
import org.jreleaser.model.api.packagers.SnapPackager;
import org.jreleaser.model.api.packagers.SpecPackager;
import org.jreleaser.model.api.packagers.WingetPackager;
import org.jreleaser.model.api.platform.Platform;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.packagers.Packager;
import org.jreleaser.model.internal.packagers.Packagers;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.SemanticVersion;

public final class Distribution
extends Packagers<Distribution>
implements Domain,
Activatable,
ExtraProperties {
    private static final long serialVersionUID = -1492592986871135365L;
    private final List<String> tags = new ArrayList<String>();
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private final Set<org.jreleaser.model.internal.common.Artifact> artifacts = new LinkedHashSet<org.jreleaser.model.internal.common.Artifact>();
    private final org.jreleaser.model.internal.common.Java java = new org.jreleaser.model.internal.common.Java();
    private final org.jreleaser.model.internal.platform.Platform platform = new org.jreleaser.model.internal.platform.Platform();
    private final org.jreleaser.model.internal.common.Executable executable = new org.jreleaser.model.internal.common.Executable();
    private String name;
    private Distribution.DistributionType type = Distribution.DistributionType.JAVA_BINARY;
    private Stereotype stereotype;
    @JsonIgnore
    private final org.jreleaser.model.api.distributions.Distribution immutable = new org.jreleaser.model.api.distributions.Distribution(){
        private static final long serialVersionUID = -3718386189666939473L;
        private Set<? extends Artifact> artifacts;

        public Platform getPlatform() {
            return Distribution.this.platform.asImmutable();
        }

        public Distribution.DistributionType getType() {
            return Distribution.this.type;
        }

        public Stereotype getStereotype() {
            return Distribution.this.stereotype;
        }

        public String getName() {
            return Distribution.this.name;
        }

        public Executable getExecutable() {
            return Distribution.this.executable.asImmutable();
        }

        public Set<? extends Artifact> getArtifacts() {
            if (null == this.artifacts) {
                this.artifacts = Distribution.this.artifacts.stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.artifacts;
        }

        public List<String> getTags() {
            return Collections.unmodifiableList(Distribution.this.tags);
        }

        public Java getJava() {
            return Distribution.this.java.asImmutable();
        }

        public Active getActive() {
            return Distribution.this.getActive();
        }

        public boolean isEnabled() {
            return Distribution.this.isEnabled();
        }

        public String getPrefix() {
            return Distribution.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(Distribution.this.extraProperties);
        }

        public AppImagePackager getAppImage() {
            return Distribution.this.appImage.asImmutable();
        }

        public AsdfPackager getAsdf() {
            return Distribution.this.asdf.asImmutable();
        }

        public BrewPackager getBrew() {
            return Distribution.this.brew.asImmutable();
        }

        public ChocolateyPackager getChocolatey() {
            return Distribution.this.chocolatey.asImmutable();
        }

        public DockerPackager getDocker() {
            return Distribution.this.docker.asImmutable();
        }

        public GofishPackager getGofish() {
            return Distribution.this.gofish.asImmutable();
        }

        public FlatpakPackager getFlatpak() {
            return Distribution.this.flatpak.asImmutable();
        }

        public JbangPackager getJbang() {
            return Distribution.this.jbang.asImmutable();
        }

        public MacportsPackager getMacports() {
            return Distribution.this.macports.asImmutable();
        }

        public ScoopPackager getScoop() {
            return Distribution.this.scoop.asImmutable();
        }

        public SdkmanPackager getSdkman() {
            return Distribution.this.sdkman.asImmutable();
        }

        public SnapPackager getSnap() {
            return Distribution.this.snap.asImmutable();
        }

        public SpecPackager getSpec() {
            return Distribution.this.spec.asImmutable();
        }

        public WingetPackager getWinget() {
            return Distribution.this.winget.asImmutable();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Distribution.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.distributions.Distribution asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Distribution source) {
        super.merge(source);
        this.name = this.merge(this.name, source.name);
        this.type = this.merge(this.type, source.type);
        this.stereotype = this.merge(this.stereotype, source.stereotype);
        this.setExecutable(source.executable);
        this.setPlatform(source.platform);
        this.setJava(source.java);
        this.setTags(this.merge(this.tags, source.tags));
        this.setExtraProperties(this.merge(this.extraProperties, source.extraProperties));
        this.setArtifacts(this.merge(this.artifacts, source.artifacts));
    }

    public TemplateContext props() {
        TemplateContext props = new TemplateContext();
        MustacheUtils.applyTemplates((TemplateContext)props, this.resolvedExtraProperties());
        props.set("distributionName", (Object)this.name);
        props.set("distributionStereotype", (Object)this.getStereotype());
        props.set("distributionExecutable", (Object)this.executable.getName());
        props.set("distributionExecutableName", (Object)this.executable.getName());
        props.set("distributionExecutableUnix", (Object)this.executable.resolveExecutable("linux"));
        props.set("distributionExecutableWindows", (Object)this.executable.resolveExecutable("windows"));
        props.set("distributionExecutableExtensionUnix", (Object)this.executable.resolveUnixExtension(), (Object)"");
        props.set("distributionExecutableExtensionWindows", (Object)this.executable.resolveWindowsExtension(), (Object)"");
        props.set("distributionTagsBySpace", (Object)String.join((CharSequence)" ", this.tags));
        props.set("distributionTagsByComma", (Object)String.join((CharSequence)",", this.tags));
        props.setAll(this.java.resolvedExtraProperties());
        props.set("distributionJavaGroupId", (Object)this.java.getGroupId(), (Object)"");
        props.set("distributionJavaArtifactId", (Object)this.java.getArtifactId(), (Object)"");
        props.set("distributionJavaMainClass", (Object)this.java.getMainClass(), (Object)"");
        if (StringUtils.isNotBlank((String)this.java.getVersion())) {
            props.set("distributionJavaVersion", (Object)this.java.getVersion());
            SemanticVersion jv = SemanticVersion.of((String)this.java.getVersion());
            props.set("distributionJavaVersionMajor", (Object)jv.getMajor(), (Object)"");
            props.set("distributionJavaVersionMinor", (Object)jv.getMinor(), (Object)"");
            props.set("distributionJavaVersionPatch", (Object)jv.getPatch(), (Object)"");
            props.set("distributionJavaVersionTag", (Object)jv.getTag(), (Object)"");
            props.set("distributionJavaVersionBuild", (Object)jv.getBuild(), (Object)"");
        } else {
            props.set("distributionJavaVersion", (Object)"");
            props.set("distributionJavaVersionMajor", (Object)"");
            props.set("distributionJavaVersionMinor", (Object)"");
            props.set("distributionJavaVersionPatch", (Object)"");
            props.set("distributionJavaVersionTag", (Object)"");
            props.set("distributionJavaVersionBuild", (Object)"");
        }
        return props;
    }

    public org.jreleaser.model.internal.platform.Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(org.jreleaser.model.internal.platform.Platform platform) {
        this.platform.merge(platform);
    }

    @Override
    public String prefix() {
        return "distribution";
    }

    public Distribution.DistributionType getType() {
        return this.type;
    }

    public void setType(Distribution.DistributionType type) {
        if (type == Distribution.DistributionType.NATIVE_IMAGE) {
            JReleaserOutput.nag((String)"NATIVE_IMAGE is deprecated since 1.4.0 and will be removed in 2.0.0. Use BINARY instead");
            this.type = Distribution.DistributionType.BINARY;
        } else {
            this.type = type;
        }
    }

    public void setType(String type) {
        this.type = Distribution.DistributionType.of((String)type);
    }

    public Stereotype getStereotype() {
        return this.stereotype;
    }

    public void setStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
    }

    public void setStereotype(String str) {
        this.setStereotype(Stereotype.of((String)str));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public org.jreleaser.model.internal.common.Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(org.jreleaser.model.internal.common.Executable executable) {
        this.executable.merge(executable);
    }

    public Set<org.jreleaser.model.internal.common.Artifact> getArtifacts() {
        return org.jreleaser.model.internal.common.Artifact.sortArtifacts(this.artifacts);
    }

    public void setArtifacts(Set<org.jreleaser.model.internal.common.Artifact> artifacts) {
        this.artifacts.clear();
        this.artifacts.addAll(artifacts);
    }

    public void addArtifacts(Set<org.jreleaser.model.internal.common.Artifact> artifacts) {
        this.artifacts.addAll(artifacts);
    }

    public void addArtifact(org.jreleaser.model.internal.common.Artifact artifact) {
        if (null != artifact) {
            this.artifacts.add(artifact);
        }
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags.clear();
        this.tags.addAll(tags);
    }

    public void addTags(List<String> tags) {
        this.tags.addAll(tags);
    }

    public void addTag(String tag) {
        if (StringUtils.isNotBlank((String)tag)) {
            this.tags.add(tag.trim());
        }
    }

    public org.jreleaser.model.internal.common.Java getJava() {
        return this.java;
    }

    public void setJava(org.jreleaser.model.internal.common.Java java) {
        this.java.merge(java);
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    public void mergeExtraProperties(Map<String, Object> extraProperties) {
        extraProperties.forEach((k, v) -> {
            if (!this.extraProperties.containsKey(k)) {
                this.extraProperties.put((String)k, v);
            }
        });
    }

    public <T extends Packager<?>> T findPackager(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new JReleaserException(RB.$((String)"ERROR_packager_name_not_blank", (Object[])new Object[0]));
        }
        return this.resolvePackager(name);
    }

    private <T extends Packager<?>> T resolvePackager(String name) {
        switch (name.toLowerCase(Locale.ENGLISH).trim()) {
            case "appimage": {
                return (T)this.getAppImage();
            }
            case "asdf": {
                return (T)this.getAsdf();
            }
            case "brew": {
                return (T)this.getBrew();
            }
            case "chocolatey": {
                return (T)this.getChocolatey();
            }
            case "docker": {
                return (T)this.getDocker();
            }
            case "flatpak": {
                return (T)this.getFlatpak();
            }
            case "gofish": {
                return (T)this.getGofish();
            }
            case "jbang": {
                return (T)this.getJbang();
            }
            case "macports": {
                return (T)this.getMacports();
            }
            case "scoop": {
                return (T)this.getScoop();
            }
            case "sdkman": {
                return (T)this.getSdkman();
            }
            case "snap": {
                return (T)this.getSnap();
            }
            case "spec": {
                return (T)this.getSpec();
            }
            case "winget": {
                return (T)this.getWinget();
            }
        }
        throw new JReleaserException(RB.$((String)"ERROR_unsupported_packager", (Object[])new Object[]{name}));
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", this.getActive());
        props.put("type", this.type);
        props.put("executable", this.executable.asMap(full));
        if (full || this.platform.isSet()) {
            props.put("platform", this.platform.asMap(full));
        }
        LinkedHashMap<String, Map<String, Object>> mappedArtifacts = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (org.jreleaser.model.internal.common.Artifact artifact : this.getArtifacts()) {
            mappedArtifacts.put("artifact " + i++, artifact.asMap(full));
        }
        props.put("artifacts", mappedArtifacts);
        props.put("tags", this.tags);
        props.put("stereotype", this.stereotype);
        props.put("extraProperties", this.getExtraProperties());
        if (this.java.isEnabled()) {
            props.put("java", this.java.asMap(full));
        }
        props.putAll(super.asMap(full));
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.name, props);
        return map;
    }
}

