/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.release;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Changelog;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.release.Changelog;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.EnabledAware;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.util.StringUtils;

public final class Changelog
extends AbstractModelObject<Changelog>
implements Domain,
EnabledAware,
ExtraProperties {
    private static final long serialVersionUID = -2693712593082430980L;
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private final Set<String> includeLabels = new LinkedHashSet<String>();
    private final Set<String> excludeLabels = new LinkedHashSet<String>();
    private final Set<Category> categories = new TreeSet<Category>(Category.ORDER_COMPARATOR);
    private final List<Replacer> replacers = new ArrayList<Replacer>();
    private final Set<Labeler> labelers = new TreeSet<Labeler>(Labeler.ORDER_COMPARATOR);
    private final Hide hide = new Hide();
    private final Contributors contributors = new Contributors();
    private final Append append = new Append();
    private Boolean enabled;
    private Boolean links;
    private Boolean skipMergeCommits;
    private Changelog.Sort sort;
    private String external;
    private Active formatted;
    private String format;
    private String categoryTitleFormat;
    private String contributorsTitleFormat;
    private String content;
    private String contentTemplate;
    private String preset;
    @JsonIgnore
    private final org.jreleaser.model.api.release.Changelog immutable = new org.jreleaser.model.api.release.Changelog(){
        private static final long serialVersionUID = 3830727279862963658L;
        private Set<? extends Changelog.Category> categories;
        private List<? extends Changelog.Replacer> replacers;
        private Set<? extends Changelog.Labeler> labelers;

        public boolean isLinks() {
            return Changelog.this.isLinks();
        }

        public boolean isSkipMergeCommits() {
            return Changelog.this.isSkipMergeCommits();
        }

        public Changelog.Sort getSort() {
            return Changelog.this.sort;
        }

        public String getExternal() {
            return Changelog.this.external;
        }

        public Active getFormatted() {
            return Changelog.this.formatted;
        }

        public Set<String> getIncludeLabels() {
            return Collections.unmodifiableSet(Changelog.this.includeLabels);
        }

        public Set<String> getExcludeLabels() {
            return Collections.unmodifiableSet(Changelog.this.excludeLabels);
        }

        public Set<? extends Changelog.Category> getCategories() {
            if (null == this.categories) {
                this.categories = Changelog.this.categories.stream().map(Category::asImmutable).collect(Collectors.toSet());
            }
            return this.categories;
        }

        public List<? extends Changelog.Replacer> getReplacers() {
            if (null == this.replacers) {
                this.replacers = Changelog.this.replacers.stream().map(Replacer::asImmutable).collect(Collectors.toList());
            }
            return this.replacers;
        }

        public Set<? extends Changelog.Labeler> getLabelers() {
            if (null == this.labelers) {
                this.labelers = Changelog.this.labelers.stream().map(Labeler::asImmutable).collect(Collectors.toSet());
            }
            return this.labelers;
        }

        public String getPrefix() {
            return Changelog.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(Changelog.this.getExtraProperties());
        }

        public String getFormat() {
            return Changelog.this.format;
        }

        public String getCategoryTitleFormat() {
            return Changelog.this.categoryTitleFormat;
        }

        public String getContributorsTitleFormat() {
            return Changelog.this.contributorsTitleFormat;
        }

        public String getContent() {
            return Changelog.this.content;
        }

        public String getContentTemplate() {
            return Changelog.this.contentTemplate;
        }

        public String getPreset() {
            return Changelog.this.preset;
        }

        public Changelog.Hide getHide() {
            return Changelog.this.hide.asImmutable();
        }

        public Changelog.Contributors getContributors() {
            return Changelog.this.contributors.asImmutable();
        }

        public Changelog.Append getAppend() {
            return Changelog.this.append.asImmutable();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Changelog.this.asMap(full));
        }

        public boolean isEnabled() {
            return Changelog.this.isEnabled();
        }
    };

    public org.jreleaser.model.api.release.Changelog asImmutable() {
        return this.immutable;
    }

    public boolean isSet() {
        return !this.includeLabels.isEmpty() || !this.excludeLabels.isEmpty() || !this.categories.isEmpty() || !this.replacers.isEmpty() || !this.labelers.isEmpty() || this.hide.isSet() || this.contributors.isSet() || this.append.isSet() || null != this.links || null != this.skipMergeCommits || null != this.sort || null != this.formatted || StringUtils.isNotBlank((String)this.external) || StringUtils.isNotBlank((String)this.format) || StringUtils.isNotBlank((String)this.categoryTitleFormat) || StringUtils.isNotBlank((String)this.contributorsTitleFormat) || StringUtils.isNotBlank((String)this.content) || StringUtils.isNotBlank((String)this.contentTemplate) || StringUtils.isNotBlank((String)this.preset) || !this.extraProperties.isEmpty();
    }

    @Override
    public void merge(Changelog source) {
        this.enabled = this.merge(this.enabled, source.enabled);
        this.links = this.merge(this.links, source.links);
        this.skipMergeCommits = this.merge(this.skipMergeCommits, source.skipMergeCommits);
        this.sort = this.merge(this.sort, source.sort);
        this.external = this.merge(this.external, source.external);
        this.formatted = this.merge(this.formatted, source.formatted);
        this.format = this.merge(this.format, source.format);
        this.categoryTitleFormat = this.merge(this.categoryTitleFormat, source.categoryTitleFormat);
        this.contributorsTitleFormat = this.merge(this.contributorsTitleFormat, source.contributorsTitleFormat);
        this.content = this.merge(this.content, source.content);
        this.contentTemplate = this.merge(this.contentTemplate, source.contentTemplate);
        this.preset = this.merge(this.preset, source.preset);
        this.setIncludeLabels(this.merge(this.includeLabels, source.includeLabels));
        this.setExcludeLabels(this.merge(this.excludeLabels, source.excludeLabels));
        this.setCategories(this.merge(this.categories, source.categories));
        this.setReplacers(this.merge(this.replacers, source.replacers));
        this.setLabelers(this.merge(this.labelers, source.labelers));
        this.setHide(source.hide);
        this.setContributors(source.contributors);
        this.setAppend(source.append);
        this.setExtraProperties(this.merge(this.extraProperties, source.getExtraProperties()));
    }

    @Override
    public String prefix() {
        return "changelog";
    }

    public boolean resolveFormatted(Project project) {
        if (null == this.formatted) {
            this.formatted = Active.NEVER;
        }
        return this.formatted.check((Active.Releaseable)project);
    }

    public Reader getResolvedContentTemplate(JReleaserContext context) {
        if (StringUtils.isNotBlank((String)this.content)) {
            return new StringReader(this.content);
        }
        Path templatePath = context.getBasedir().resolve(this.contentTemplate);
        try {
            return Files.newBufferedReader(templatePath);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    @Override
    public boolean isEnabled() {
        return null != this.enabled && this.enabled != false;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabledSet() {
        return null != this.enabled;
    }

    public boolean isLinks() {
        return null != this.links && this.links != false;
    }

    public void setLinks(Boolean links) {
        this.links = links;
    }

    public boolean isSkipMergeCommits() {
        return null != this.skipMergeCommits && this.skipMergeCommits != false;
    }

    public void setSkipMergeCommits(Boolean skipMergeCommits) {
        this.skipMergeCommits = skipMergeCommits;
    }

    public Changelog.Sort getSort() {
        return this.sort;
    }

    public void setSort(Changelog.Sort sort) {
        this.sort = sort;
    }

    public void setSort(String sort) {
        if (StringUtils.isNotBlank((String)sort)) {
            this.setSort(Changelog.Sort.valueOf((String)sort.toUpperCase(Locale.ENGLISH)));
        }
    }

    public String getExternal() {
        return this.external;
    }

    public void setExternal(String external) {
        this.external = external;
    }

    public Active getFormatted() {
        return this.formatted;
    }

    public void setFormatted(Active formatted) {
        this.formatted = formatted;
    }

    public void setFormatted(String str) {
        this.setFormatted(Active.of((String)str));
    }

    public boolean isFormattedSet() {
        return null != this.formatted;
    }

    public Set<String> getIncludeLabels() {
        return this.includeLabels;
    }

    public void setIncludeLabels(Set<String> includeLabels) {
        this.includeLabels.clear();
        this.includeLabels.addAll(includeLabels.stream().map(String::trim).collect(Collectors.toSet()));
    }

    public Set<String> getExcludeLabels() {
        return this.excludeLabels;
    }

    public void setExcludeLabels(Set<String> excludeLabels) {
        this.excludeLabels.clear();
        this.excludeLabels.addAll(excludeLabels.stream().map(String::trim).collect(Collectors.toSet()));
    }

    public Set<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(Set<Category> categories) {
        this.categories.clear();
        this.categories.addAll(categories);
    }

    public List<Replacer> getReplacers() {
        return this.replacers;
    }

    public void setReplacers(List<Replacer> replacers) {
        this.replacers.clear();
        this.replacers.addAll(replacers);
    }

    public Set<Labeler> getLabelers() {
        return this.labelers;
    }

    public void setLabelers(Set<Labeler> labelers) {
        this.labelers.clear();
        this.labelers.addAll(labelers);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getCategoryTitleFormat() {
        return this.categoryTitleFormat;
    }

    public void setCategoryTitleFormat(String categoryTitleFormat) {
        this.categoryTitleFormat = categoryTitleFormat;
    }

    public String getContributorsTitleFormat() {
        return this.contributorsTitleFormat;
    }

    public void setContributorsTitleFormat(String contributorsTitleFormat) {
        this.contributorsTitleFormat = contributorsTitleFormat;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContentTemplate() {
        return this.contentTemplate;
    }

    public void setContentTemplate(String contentTemplate) {
        this.contentTemplate = contentTemplate;
    }

    public String getPreset() {
        return this.preset;
    }

    public void setPreset(String preset) {
        this.preset = preset;
    }

    public Hide getHide() {
        return this.hide;
    }

    public void setHide(Hide hide) {
        this.hide.merge(hide);
    }

    public Contributors getContributors() {
        return this.contributors;
    }

    public void setContributors(Contributors contributors) {
        this.contributors.merge(contributors);
    }

    public Append getAppend() {
        return this.append;
    }

    public void setAppend(Append append) {
        this.append.merge(append);
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("external", this.external);
        map.put("append", this.append.asMap(full));
        map.put("links", this.isLinks());
        map.put("skipMergeCommits", this.isSkipMergeCommits());
        map.put("sort", this.sort);
        map.put("formatted", this.formatted);
        map.put("preset", this.preset);
        map.put("format", this.format);
        map.put("categoryTitleFormat", this.categoryTitleFormat);
        map.put("contributorsTitleFormat", this.contributorsTitleFormat);
        map.put("content", this.content);
        map.put("contentTemplate", this.contentTemplate);
        map.put("includeLabels", this.includeLabels);
        map.put("excludeLabels", this.excludeLabels);
        map.put("hide", this.hide.asMap(full));
        map.put("contributors", this.contributors.asMap(full));
        LinkedHashMap<String, Map<String, Object>> m = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Category category : this.categories) {
            m.put("category " + i++, category.asMap(full));
        }
        map.put("categories", m);
        m = new LinkedHashMap();
        i = 0;
        for (Labeler labeler : this.labelers) {
            m.put("labeler " + i++, labeler.asMap(full));
        }
        map.put("labelers", m);
        m = new LinkedHashMap();
        i = 0;
        for (Replacer replacer : this.replacers) {
            m.put("replacer " + i++, replacer.asMap(full));
        }
        map.put("replacers", m);
        map.put("extraProperties", this.resolvedExtraProperties());
        return map;
    }

    public static final class Hide
    extends AbstractModelObject<Hide>
    implements Domain {
        private static final long serialVersionUID = 314185207203186567L;
        private final Set<String> categories = new LinkedHashSet<String>();
        private final Set<String> contributors = new LinkedHashSet<String>();
        private Boolean uncategorized;
        @JsonIgnore
        private final Changelog.Hide immutable = new Changelog.Hide(){
            private static final long serialVersionUID = 4820100134325634530L;

            public boolean isUncategorized() {
                return this.isUncategorized();
            }

            public Set<String> getCategories() {
                return Collections.unmodifiableSet(categories);
            }

            public boolean containsCategory(String category) {
                return this.containsCategory(category);
            }

            public Set<String> getContributors() {
                return Collections.unmodifiableSet(contributors);
            }

            public boolean containsContributor(String name) {
                return this.containsContributor(name);
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Changelog.Hide asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Hide source) {
            this.uncategorized = this.merge(this.uncategorized, source.uncategorized);
            this.setCategories(this.merge(this.categories, source.categories));
            this.setContributors(this.merge(this.contributors, source.contributors));
        }

        public boolean isUncategorized() {
            return null != this.uncategorized && this.uncategorized != false;
        }

        public void setUncategorized(Boolean uncategorized) {
            this.uncategorized = uncategorized;
        }

        public Set<String> getCategories() {
            return this.categories;
        }

        public void setCategories(Set<String> categories) {
            this.categories.clear();
            this.categories.addAll(categories.stream().map(String::trim).collect(Collectors.toSet()));
        }

        public void addCategories(Set<String> categories) {
            this.categories.addAll(categories.stream().map(String::trim).collect(Collectors.toSet()));
        }

        public void addCategory(String category) {
            if (StringUtils.isNotBlank((String)category)) {
                this.categories.add(category.trim());
            }
        }

        public boolean containsCategory(String category) {
            if (StringUtils.isNotBlank((String)category)) {
                return this.categories.contains(category.trim());
            }
            return false;
        }

        public Set<String> getContributors() {
            return this.contributors;
        }

        public void setContributors(Set<String> contributors) {
            this.contributors.clear();
            this.contributors.addAll(contributors.stream().map(String::trim).collect(Collectors.toSet()));
        }

        public void addContributors(Set<String> contributors) {
            this.contributors.addAll(contributors.stream().map(String::trim).collect(Collectors.toSet()));
        }

        public void addContributor(String contributor) {
            if (StringUtils.isNotBlank((String)contributor)) {
                this.contributors.add(contributor.trim());
            }
        }

        public boolean containsContributor(String name) {
            if (StringUtils.isNotBlank((String)name)) {
                String n = name.trim();
                for (String contributor : this.contributors) {
                    if (!n.contains(contributor) && !n.matches(contributor)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("uncategorized", this.uncategorized);
            map.put("categories", this.categories);
            map.put("contributors", this.contributors);
            return map;
        }

        public boolean isSet() {
            return !this.categories.isEmpty() || !this.contributors.isEmpty() || null != this.uncategorized;
        }
    }

    public static final class Contributors
    extends AbstractModelObject<Contributors>
    implements Domain,
    EnabledAware {
        private static final long serialVersionUID = 3162308397837135084L;
        private Boolean enabled;
        private String format;
        @JsonIgnore
        private final Changelog.Contributors immutable = new Changelog.Contributors(){
            private static final long serialVersionUID = 1849581704581927871L;

            public String getFormat() {
                return format;
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }
        };

        public Changelog.Contributors asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Contributors source) {
            this.enabled = this.merge(this.enabled, source.enabled);
            this.format = this.merge(this.format, source.format);
        }

        @Override
        public boolean isEnabled() {
            return null != this.enabled && this.enabled != false;
        }

        @Override
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabledSet() {
            return null != this.enabled;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.enabled);
            map.put("format", this.format);
            return map;
        }

        public boolean isSet() {
            return StringUtils.isNotBlank((String)this.format) || null != this.enabled;
        }
    }

    public static final class Labeler
    extends AbstractModelObject<Labeler>
    implements Domain {
        public static final Comparator<Labeler> ORDER_COMPARATOR = (o1, o2) -> {
            if (null == o1.getOrder()) {
                return 1;
            }
            if (null == o2.getOrder()) {
                return -1;
            }
            return o1.getOrder().compareTo(o2.getOrder());
        };
        private static final long serialVersionUID = 1510091671085545316L;
        private String label;
        private String title;
        private String body;
        private Integer order;
        @JsonIgnore
        private final Changelog.Labeler immutable = new Changelog.Labeler(){
            private static final long serialVersionUID = -6780960364911032512L;

            public String getLabel() {
                return label;
            }

            public String getTitle() {
                return title;
            }

            public String getBody() {
                return body;
            }

            public Integer getOrder() {
                return order;
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Changelog.Labeler asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Labeler source) {
            this.label = this.merge(this.label, source.label);
            this.title = this.merge(this.title, source.title);
            this.body = this.merge(this.body, source.body);
            this.order = this.merge(this.order, source.order);
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public Integer getOrder() {
            return this.order;
        }

        public void setOrder(Integer order) {
            this.order = order;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            Labeler labeler = (Labeler)o;
            return Objects.equals(this.title, labeler.title) && Objects.equals(this.body, labeler.body);
        }

        public int hashCode() {
            return Objects.hash(this.title, this.body);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("label", this.label);
            map.put("title", this.title);
            map.put("body", this.body);
            map.put("order", this.order);
            return map;
        }
    }

    public static final class Replacer
    extends AbstractModelObject<Replacer>
    implements Domain {
        private static final long serialVersionUID = -3996062461946189421L;
        private String search;
        private String replace = "";
        @JsonIgnore
        private final Changelog.Replacer immutable = new Changelog.Replacer(){
            private static final long serialVersionUID = -8515498818759834354L;

            public String getSearch() {
                return search;
            }

            public String getReplace() {
                return replace;
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Changelog.Replacer asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Replacer source) {
            this.search = this.merge(this.search, source.search);
            this.replace = this.merge(this.replace, source.replace);
        }

        public String getSearch() {
            return this.search;
        }

        public void setSearch(String search) {
            this.search = search;
        }

        public String getReplace() {
            return this.replace;
        }

        public void setReplace(String replace) {
            this.replace = replace;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("search", this.search);
            map.put("replace", this.replace);
            return map;
        }
    }

    public static final class Category
    extends AbstractModelObject<Category>
    implements Domain {
        public static final Comparator<Category> ORDER_COMPARATOR = (o1, o2) -> {
            if (null == o1.getOrder()) {
                return 1;
            }
            if (null == o2.getOrder()) {
                return -1;
            }
            return o1.getOrder().compareTo(o2.getOrder());
        };
        private static final long serialVersionUID = 8812582603331073781L;
        private final Set<String> labels = new LinkedHashSet<String>();
        private String key;
        private String title;
        private String format;
        private Integer order;
        @JsonIgnore
        private final Changelog.Category immutable = new Changelog.Category(){
            private static final long serialVersionUID = -6331412945094114818L;

            public String getFormat() {
                return format;
            }

            public String getKey() {
                return key;
            }

            public String getTitle() {
                return title;
            }

            public Set<String> getLabels() {
                return Collections.unmodifiableSet(labels);
            }

            public Integer getOrder() {
                return order;
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Changelog.Category asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Category source) {
            this.key = this.merge(this.key, source.key);
            this.title = this.merge(this.title, source.title);
            this.format = this.merge(this.format, source.format);
            this.order = this.merge(this.order, source.order);
            this.setLabels(this.merge(this.labels, source.labels));
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
            if (StringUtils.isBlank((String)this.key)) {
                this.key = title;
            }
        }

        public Set<String> getLabels() {
            return this.labels;
        }

        public void setLabels(Set<String> labels) {
            this.labels.clear();
            this.labels.addAll(labels);
        }

        public void addLabels(Set<String> labels) {
            this.labels.addAll(labels);
        }

        public Integer getOrder() {
            return this.order;
        }

        public void setOrder(Integer order) {
            this.order = order;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("key", this.key);
            map.put("title", this.title);
            map.put("labels", this.labels);
            map.put("format", this.format);
            map.put("order", this.order);
            return map;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            Category category = (Category)o;
            return this.key.equals(category.key);
        }

        public int hashCode() {
            return Objects.hash(this.title);
        }

        public static Set<Category> sort(Set<Category> categories) {
            TreeSet<Category> tmp = new TreeSet<Category>(ORDER_COMPARATOR);
            tmp.addAll(categories);
            return tmp;
        }

        public static Category of(String key, String title, String format, String ... labels) {
            Category category = new Category();
            category.key = key;
            category.title = title;
            category.format = format;
            category.labels.addAll(Arrays.asList(labels));
            return category;
        }
    }

    public static final class Append
    extends AbstractModelObject<Append>
    implements Domain {
        private static final long serialVersionUID = -7396820796498154377L;
        private Boolean enabled;
        private String title;
        private String target;
        private String content;
        private String contentTemplate;
        @JsonIgnore
        private final Changelog.Append immutable = new Changelog.Append(){
            private static final long serialVersionUID = -5635998660542618226L;

            public boolean isEnabled() {
                return this.isEnabled();
            }

            public String getTitle() {
                return title;
            }

            public String getTarget() {
                return target;
            }

            public String getContent() {
                return content;
            }

            public String getContentTemplate() {
                return contentTemplate;
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Changelog.Append asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Append source) {
            this.enabled = this.merge(this.enabled, source.enabled);
            this.title = this.merge(this.title, source.title);
            this.target = this.merge(this.target, source.target);
            this.content = this.merge(this.content, source.content);
            this.contentTemplate = this.merge(this.contentTemplate, source.contentTemplate);
        }

        public boolean isEnabled() {
            return null != this.enabled && this.enabled != false;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getContentTemplate() {
            return this.contentTemplate;
        }

        public void setContentTemplate(String contentTemplate) {
            this.contentTemplate = contentTemplate;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("title", this.title);
            map.put("target", this.target);
            map.put("content", this.content);
            map.put("contentTemplate", this.contentTemplate);
            return map;
        }

        public boolean isSet() {
            return StringUtils.isNotBlank((String)this.title) || StringUtils.isNotBlank((String)this.target) || StringUtils.isNotBlank((String)this.content) || StringUtils.isNotBlank((String)this.contentTemplate) || null != this.enabled;
        }

        public Reader getResolvedContentTemplate(JReleaserContext context) {
            if (StringUtils.isNotBlank((String)this.content)) {
                return new StringReader(this.content);
            }
            Path templatePath = context.getBasedir().resolve(this.contentTemplate);
            try {
                return Files.newBufferedReader(templatePath);
            }
            catch (IOException e) {
                throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
            }
        }
    }
}

