/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.api.packagers.SnapPackager;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.packagers.AbstractRepositoryPackager;
import org.jreleaser.model.internal.packagers.PackagerRepository;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class SnapPackager
extends AbstractRepositoryPackager<org.jreleaser.model.api.packagers.SnapPackager, SnapPackager> {
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private static final long serialVersionUID = 4351951573944850125L;
    private final Set<String> localPlugs = new LinkedHashSet<String>();
    private final Set<String> localSlots = new LinkedHashSet<String>();
    private final List<Plug> plugs = new ArrayList<Plug>();
    private final List<Slot> slots = new ArrayList<Slot>();
    private final List<Architecture> architectures = new ArrayList<Architecture>();
    private final SnapRepository snap = new SnapRepository();
    private String packageName;
    private String base = "core20";
    private String grade = "stable";
    private String confinement = "strict";
    private String exportedLogin;
    private Boolean remoteBuild;
    @JsonIgnore
    private final org.jreleaser.model.api.packagers.SnapPackager immutable = new org.jreleaser.model.api.packagers.SnapPackager(){
        private static final long serialVersionUID = -8321640926545215502L;
        private List<? extends SnapPackager.Architecture> architectures;
        private List<? extends SnapPackager.Slot> slots;
        private List<? extends SnapPackager.Plug> plugs;

        public String getPackageName() {
            return SnapPackager.this.packageName;
        }

        public String getBase() {
            return SnapPackager.this.base;
        }

        public String getGrade() {
            return SnapPackager.this.grade;
        }

        public String getConfinement() {
            return SnapPackager.this.confinement;
        }

        public Set<String> getLocalPlugs() {
            return Collections.unmodifiableSet(SnapPackager.this.localPlugs);
        }

        public Set<String> getLocalSlots() {
            return Collections.unmodifiableSet(SnapPackager.this.localSlots);
        }

        public List<? extends SnapPackager.Plug> getPlugs() {
            if (null == this.plugs) {
                this.plugs = SnapPackager.this.plugs.stream().map(Plug::asImmutable).collect(Collectors.toList());
            }
            return this.plugs;
        }

        public List<? extends SnapPackager.Slot> getSlots() {
            if (null == this.slots) {
                this.slots = SnapPackager.this.slots.stream().map(Slot::asImmutable).collect(Collectors.toList());
            }
            return this.slots;
        }

        public List<? extends SnapPackager.Architecture> getArchitectures() {
            if (null == this.architectures) {
                this.architectures = SnapPackager.this.architectures.stream().map(Architecture::asImmutable).collect(Collectors.toList());
            }
            return this.architectures;
        }

        public String getExportedLogin() {
            return SnapPackager.this.exportedLogin;
        }

        public boolean isRemoteBuild() {
            return SnapPackager.this.isRemoteBuild();
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getSnap() {
            return SnapPackager.this.snap.asImmutable();
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getPackagerRepository() {
            return this.getSnap();
        }

        public CommitAuthor getCommitAuthor() {
            return SnapPackager.this.getCommitAuthor().asImmutable();
        }

        public String getTemplateDirectory() {
            return SnapPackager.this.getTemplateDirectory();
        }

        public List<String> getSkipTemplates() {
            return Collections.unmodifiableList(SnapPackager.this.getSkipTemplates());
        }

        public String getType() {
            return SnapPackager.this.getType();
        }

        public String getDownloadUrl() {
            return SnapPackager.this.getDownloadUrl();
        }

        public boolean supportsPlatform(String platform) {
            return SnapPackager.this.supportsPlatform(platform);
        }

        public boolean supportsDistribution(Distribution.DistributionType distributionType) {
            return SnapPackager.this.supportsDistribution(distributionType);
        }

        public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
            return SnapPackager.this.getSupportedFileExtensions(distributionType);
        }

        public Set<Stereotype> getSupportedStereotypes() {
            return SnapPackager.this.getSupportedStereotypes();
        }

        public boolean isSnapshotSupported() {
            return SnapPackager.this.isSnapshotSupported();
        }

        public boolean isContinueOnError() {
            return SnapPackager.this.isContinueOnError();
        }

        public Active getActive() {
            return SnapPackager.this.getActive();
        }

        public boolean isEnabled() {
            return SnapPackager.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(SnapPackager.this.asMap(full));
        }

        public String getPrefix() {
            return SnapPackager.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(SnapPackager.this.getExtraProperties());
        }
    };

    public SnapPackager() {
        super("snap");
    }

    @Override
    public org.jreleaser.model.api.packagers.SnapPackager asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(SnapPackager source) {
        super.merge(source);
        this.packageName = this.merge(this.packageName, source.packageName);
        this.base = this.merge(this.base, source.base);
        this.grade = this.merge(this.grade, source.grade);
        this.confinement = this.merge(this.confinement, source.confinement);
        this.exportedLogin = this.merge(this.exportedLogin, source.exportedLogin);
        this.remoteBuild = this.merge(this.remoteBuild, source.remoteBuild);
        this.setLocalPlugs(this.merge(this.localPlugs, source.localPlugs));
        this.setLocalSlots(this.merge(this.localSlots, source.localSlots));
        this.setPlugs(this.merge(this.plugs, source.plugs));
        this.setSlots(this.merge(this.slots, source.slots));
        this.setArchitectures(this.merge(this.architectures, source.architectures));
        this.setSnap(source.snap);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public String getConfinement() {
        return this.confinement;
    }

    public void setConfinement(String confinement) {
        this.confinement = confinement;
    }

    public Set<String> getLocalPlugs() {
        return this.localPlugs;
    }

    public void setLocalPlugs(Set<String> localPlugs) {
        this.localPlugs.clear();
        this.localPlugs.addAll(localPlugs);
    }

    public Set<String> getLocalSlots() {
        return this.localSlots;
    }

    public void setLocalSlots(Set<String> localSlots) {
        this.localSlots.clear();
        this.localSlots.addAll(localSlots);
    }

    public List<Plug> getPlugs() {
        return this.plugs;
    }

    public void setPlugs(List<Plug> plugs) {
        this.plugs.clear();
        this.plugs.addAll(plugs);
    }

    public List<Slot> getSlots() {
        return this.slots;
    }

    public void setSlots(List<Slot> slots) {
        this.slots.clear();
        this.slots.addAll(slots);
    }

    public List<Architecture> getArchitectures() {
        return this.architectures;
    }

    public void setArchitectures(List<Architecture> architectures) {
        this.architectures.clear();
        this.architectures.addAll(architectures);
    }

    public void addArchitecture(List<Architecture> architectures) {
        this.architectures.addAll(architectures);
    }

    public void addArchitecture(Architecture architecture) {
        if (null != architecture) {
            this.architectures.add(architecture);
        }
    }

    public String getExportedLogin() {
        return this.exportedLogin;
    }

    public void setExportedLogin(String exportedLogin) {
        this.exportedLogin = exportedLogin;
    }

    public boolean isRemoteBuild() {
        return null != this.remoteBuild && this.remoteBuild != false;
    }

    public void setRemoteBuild(Boolean remoteBuild) {
        this.remoteBuild = remoteBuild;
    }

    public boolean isRemoteBuildSet() {
        return null != this.remoteBuild;
    }

    public SnapRepository getSnap() {
        return this.snap;
    }

    public void setSnap(SnapRepository repository) {
        this.snap.merge(repository);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        int i;
        super.asMap(full, props);
        props.put("packageName", this.packageName);
        props.put("base", this.base);
        props.put("grade", this.grade);
        props.put("confinement", this.confinement);
        props.put("exportedLogin", this.exportedLogin);
        props.put("remoteBuild", this.isRemoteBuild());
        props.put("snap", this.snap.asMap(full));
        props.put("localPlugs", this.localPlugs);
        props.put("localSlots", this.localSlots);
        LinkedHashMap<String, Map<String, Object>> mapped = new LinkedHashMap<String, Map<String, Object>>();
        for (i = 0; i < this.plugs.size(); ++i) {
            mapped.put("plug " + i, this.plugs.get(i).asMap(full));
        }
        props.put("plugs", mapped);
        mapped = new LinkedHashMap();
        for (i = 0; i < this.slots.size(); ++i) {
            mapped.put("slot " + i, this.slots.get(i).asMap(full));
        }
        props.put("slots", mapped);
        mapped = new LinkedHashMap();
        for (i = 0; i < this.architectures.size(); ++i) {
            mapped.put("architecture " + i, this.architectures.get(i).asMap(full));
        }
        props.put("architectures", mapped);
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.getPackagerRepository();
    }

    public PackagerRepository getPackagerRepository() {
        return this.getSnap();
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isUnix((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution.DistributionType distributionType) {
        return SUPPORTED.containsKey(distributionType);
    }

    @Override
    public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault(distributionType, Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get("skipSnap"));
    }

    static {
        Set extensions = CollectionUtils.setOf((Object[])new String[]{FileType.TAR_BZ2.extension(), FileType.TAR_GZ.extension(), FileType.TAR_XZ.extension(), FileType.TBZ2.extension(), FileType.TGZ.extension(), FileType.TXZ.extension(), FileType.TAR.extension()});
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_PACKAGE, CollectionUtils.setOf((Object[])new String[]{FileType.DEB.extension(), FileType.RPM.extension()}));
        SUPPORTED.put(Distribution.DistributionType.SINGLE_JAR, CollectionUtils.setOf((Object[])new String[]{FileType.JAR.extension()}));
        SUPPORTED.put(Distribution.DistributionType.FLAT_BINARY, Collections.emptySet());
    }

    public static final class Architecture
    extends AbstractModelObject<Architecture>
    implements Domain {
        private static final long serialVersionUID = 1878739013053454056L;
        private final List<String> buildOn = new ArrayList<String>();
        private final List<String> runOn = new ArrayList<String>();
        private Boolean ignoreError;
        @JsonIgnore
        private final SnapPackager.Architecture immutable = new SnapPackager.Architecture(){
            private static final long serialVersionUID = 7707062117835809382L;

            public List<String> getBuildOn() {
                return Collections.unmodifiableList(buildOn);
            }

            public List<String> getRunOn() {
                return Collections.unmodifiableList(runOn);
            }

            public boolean isIgnoreError() {
                return this.isIgnoreError();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public SnapPackager.Architecture asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Architecture source) {
            this.ignoreError = this.merge(this.ignoreError, source.ignoreError);
            this.setBuildOn(this.merge(this.buildOn, source.buildOn));
            this.setRunOn(this.merge(this.runOn, source.runOn));
        }

        public List<String> getBuildOn() {
            return this.buildOn;
        }

        public void setBuildOn(List<String> buildOn) {
            this.buildOn.clear();
            this.buildOn.addAll(buildOn);
        }

        public List<String> getRunOn() {
            return this.runOn;
        }

        public void setRunOn(List<String> runOn) {
            this.runOn.clear();
            this.runOn.addAll(runOn);
        }

        public boolean hasBuildOn() {
            return !this.buildOn.isEmpty();
        }

        public boolean hasRunOn() {
            return !this.runOn.isEmpty();
        }

        public boolean isIgnoreError() {
            return null != this.ignoreError && this.ignoreError != false;
        }

        public void setIgnoreError(Boolean ignoreError) {
            this.ignoreError = ignoreError;
        }

        public boolean isIgnoreErrorSet() {
            return null != this.ignoreError;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("buildOn", this.buildOn);
            map.put("runOn", this.runOn);
            map.put("ignoreError", this.isIgnoreError());
            return map;
        }
    }

    public static final class SnapRepository
    extends PackagerRepository {
        private static final long serialVersionUID = 4117738159449060256L;

        public SnapRepository() {
            super("snap", "snap");
        }
    }

    public static final class Plug
    extends AbstractModelObject<Plug>
    implements Domain {
        private static final long serialVersionUID = -2210365052943258689L;
        private final Map<String, String> attributes = new LinkedHashMap<String, String>();
        private final List<String> reads = new ArrayList<String>();
        private final List<String> writes = new ArrayList<String>();
        private String name;
        @JsonIgnore
        private final SnapPackager.Plug immutable = new SnapPackager.Plug(){
            private static final long serialVersionUID = -5689359361910963388L;

            public String getName() {
                return name;
            }

            public Map<String, String> getAttributes() {
                return Collections.unmodifiableMap(attributes);
            }

            public List<String> getReads() {
                return Collections.unmodifiableList(reads);
            }

            public List<String> getWrites() {
                return Collections.unmodifiableList(writes);
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public SnapPackager.Plug asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Plug source) {
            this.name = this.merge(this.name, source.name);
            this.setAttributes(this.merge(this.attributes, source.attributes));
            this.setReads(this.merge(this.reads, source.reads));
            this.setWrites(this.merge(this.writes, source.writes));
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes.clear();
            this.attributes.putAll(attributes);
        }

        public Collection<Attribute> getAttrs() {
            return this.attributes.entrySet().stream().map(e -> new Attribute((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        }

        public List<String> getReads() {
            return this.reads;
        }

        public void setReads(List<String> reads) {
            this.reads.clear();
            this.reads.addAll(reads);
        }

        public List<String> getWrites() {
            return this.writes;
        }

        public void setWrites(List<String> writes) {
            this.writes.clear();
            this.writes.addAll(writes);
        }

        public boolean getHasRead() {
            return !this.reads.isEmpty();
        }

        public boolean getHasWrite() {
            return !this.writes.isEmpty();
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(this.name, this.attributes);
            map.put("reads", this.reads);
            map.put("writes", this.writes);
            return map;
        }

        public static Plug copyOf(Plug other) {
            Plug copy = new Plug();
            copy.setName(other.getName());
            copy.setAttributes(other.getAttributes());
            copy.setReads(other.getReads());
            copy.setWrites(other.getWrites());
            return copy;
        }
    }

    public static final class Slot
    extends AbstractModelObject<Slot>
    implements Domain {
        private static final long serialVersionUID = 8422045649925759163L;
        private final Map<String, String> attributes = new LinkedHashMap<String, String>();
        private final List<String> reads = new ArrayList<String>();
        private final List<String> writes = new ArrayList<String>();
        private String name;
        @JsonIgnore
        private final SnapPackager.Slot immutable = new SnapPackager.Slot(){
            private static final long serialVersionUID = -3518924698578544847L;

            public String getName() {
                return name;
            }

            public Map<String, String> getAttributes() {
                return Collections.unmodifiableMap(attributes);
            }

            public List<String> getReads() {
                return Collections.unmodifiableList(reads);
            }

            public List<String> getWrites() {
                return Collections.unmodifiableList(writes);
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public SnapPackager.Slot asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Slot source) {
            this.name = this.merge(this.name, source.name);
            this.setAttributes(this.merge(this.attributes, source.attributes));
            this.setReads(this.merge(this.reads, source.reads));
            this.setWrites(this.merge(this.writes, source.writes));
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes.clear();
            this.attributes.putAll(attributes);
        }

        public Collection<Attribute> getAttrs() {
            return this.attributes.entrySet().stream().map(e -> new Attribute((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        }

        public List<String> getReads() {
            return this.reads;
        }

        public void setReads(List<String> reads) {
            this.reads.clear();
            this.reads.addAll(reads);
        }

        public List<String> getWrites() {
            return this.writes;
        }

        public void setWrites(List<String> writes) {
            this.writes.clear();
            this.writes.addAll(writes);
        }

        public boolean getHasReads() {
            return !this.reads.isEmpty();
        }

        public boolean getHasWrites() {
            return !this.writes.isEmpty();
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(this.name, this.attributes);
            map.put("read", this.reads);
            map.put("write", this.writes);
            return map;
        }

        public static Slot copyOf(Slot other) {
            Slot copy = new Slot();
            copy.setName(other.getName());
            copy.setAttributes(other.getAttributes());
            copy.setReads(other.getReads());
            copy.setWrites(other.getWrites());
            return copy;
        }
    }

    public static final class Attribute {
        public final String key;
        public final String value;

        public Attribute(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

