/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.workflow;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.context.ModelValidator;
import org.jreleaser.extensions.api.ExtensionManagerHolder;
import org.jreleaser.extensions.api.workflow.WorkflowListenerException;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.hooks.ExecutionEvent;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.util.TimeUtils;
import org.jreleaser.workflow.Workflow;
import org.jreleaser.workflow.WorkflowItem;

class WorkflowImpl
implements Workflow {
    private final JReleaserContext context;
    private final List<WorkflowItem> items = new ArrayList<WorkflowItem>();

    public WorkflowImpl(JReleaserContext context, List<WorkflowItem> items) {
        this.context = context;
        ModelValidator.validate(context);
        this.items.addAll(items);
    }

    @Override
    public void execute() {
        try {
            this.doExecute();
        }
        finally {
            ExtensionManagerHolder.cleanup();
            this.context.getLogger().close();
        }
    }

    private void doExecute() {
        Instant start;
        Throwable endSessionException;
        Throwable startSessionException;
        Throwable listenerException;
        RuntimeException stepException;
        block25: {
            block22: {
                stepException = null;
                listenerException = null;
                startSessionException = null;
                endSessionException = null;
                start = Instant.now();
                this.context.getLogger().info(RB.$((String)"workflow.dryrun", (Object[])new Object[0]), new Object[]{this.context.isDryrun()});
                this.logFilters("workflow.included.downloader.types", this.context.getIncludedDownloaderTypes());
                this.logFilters("workflow.excluded.downloader.types", this.context.getExcludedDownloaderTypes());
                this.logFilters("workflow.included.downloader.names", this.context.getIncludedDownloaderNames());
                this.logFilters("workflow.excluded.downloader.names", this.context.getExcludedDownloaderNames());
                this.logFilters("workflow.included.assemblers", this.context.getIncludedAssemblers());
                this.logFilters("workflow.excluded.assemblers", this.context.getExcludedAssemblers());
                this.logFilters("workflow.included.distributions", this.context.getIncludedDistributions());
                this.logFilters("workflow.excluded.distributions", this.context.getExcludedDistributions());
                this.logFilters("workflow.included.catalogers", this.context.getIncludedCatalogers());
                this.logFilters("workflow.excluded.catalogers", this.context.getExcludedCatalogers());
                this.logFilters("workflow.included.packagers", this.context.getIncludedPackagers());
                this.logFilters("workflow.excluded.packagers", this.context.getExcludedPackagers());
                this.logFilters("workflow.included.deployer.types", this.context.getIncludedDeployerTypes());
                this.logFilters("workflow.excluded.deployer.types", this.context.getExcludedDeployerTypes());
                this.logFilters("workflow.included.deployer.names", this.context.getIncludedDeployerNames());
                this.logFilters("workflow.excluded.deployer.names", this.context.getExcludedDeployerNames());
                this.logFilters("workflow.included.uploader.types", this.context.getIncludedUploaderTypes());
                this.logFilters("workflow.excluded.uploader.types", this.context.getExcludedUploaderTypes());
                this.logFilters("workflow.included.uploader.names", this.context.getIncludedUploaderNames());
                this.logFilters("workflow.excluded.uploader.names", this.context.getExcludedUploaderNames());
                this.logFilters("workflow.included.announcers", this.context.getIncludedAnnouncers());
                this.logFilters("workflow.excluded.announcers", this.context.getExcludedAnnouncers());
                try {
                    this.context.fireSessionStartEvent();
                }
                catch (WorkflowListenerException e) {
                    this.context.getLogger().error(RB.$((String)"listener.failure", (Object[])new Object[]{e.getListener().getClass().getName()}));
                    this.context.getLogger().trace((Throwable)e);
                    if (e.getListener().isContinueOnError()) break block22;
                    startSessionException = e.getCause();
                }
            }
            if (null == startSessionException) {
                for (WorkflowItem item : this.items) {
                    boolean failure;
                    block24: {
                        block23: {
                            failure = false;
                            try {
                                this.context.fireWorkflowEvent(ExecutionEvent.before((String)item.getCommand().toStep()));
                            }
                            catch (WorkflowListenerException beforeException) {
                                this.context.getLogger().error(RB.$((String)"listener.failure", (Object[])new Object[]{beforeException.getListener().getClass().getName()}));
                                this.context.getLogger().trace((Throwable)beforeException);
                                if (beforeException.getListener().isContinueOnError()) break block23;
                                listenerException = beforeException.getCause();
                                break;
                            }
                        }
                        try {
                            item.invoke(this.context);
                        }
                        catch (RuntimeException e) {
                            failure = true;
                            stepException = e;
                            try {
                                this.context.fireWorkflowEvent(ExecutionEvent.failure((String)item.getCommand().toStep(), (Throwable)e));
                            }
                            catch (WorkflowListenerException failureException) {
                                this.context.getLogger().error(RB.$((String)"listener.failure", (Object[])new Object[]{failureException.getListener().getClass().getName()}));
                                this.context.getLogger().trace((Throwable)failureException);
                                if (failureException.getListener().isContinueOnError()) break block24;
                                listenerException = failureException.getCause();
                                break;
                            }
                        }
                    }
                    if (failure) continue;
                    try {
                        this.context.fireWorkflowEvent(ExecutionEvent.success((String)item.getCommand().toStep()));
                    }
                    catch (WorkflowListenerException afterException) {
                        this.context.getLogger().error(RB.$((String)"listener.failure", (Object[])new Object[]{afterException.getListener().getClass().getName()}));
                        this.context.getLogger().trace((Throwable)afterException);
                        if (afterException.getListener().isContinueOnError()) continue;
                        listenerException = afterException.getCause();
                        break;
                    }
                }
            }
            try {
                this.context.fireSessionEndEvent();
            }
            catch (WorkflowListenerException e) {
                this.context.getLogger().error(RB.$((String)"listener.failure", (Object[])new Object[]{e.getListener().getClass().getName()}));
                this.context.getLogger().trace((Throwable)e);
                if (e.getListener().isContinueOnError()) break block25;
                endSessionException = e.getCause();
            }
        }
        Instant end = Instant.now();
        double duration = (double)Duration.between(start, end).toMillis() / 1000.0;
        this.context.getLogger().reset();
        this.context.report();
        if (null != startSessionException) {
            this.context.getLogger().error(RB.$((String)"workflow.failure", (Object[])new Object[0]), new Object[]{TimeUtils.formatDuration((double)duration)});
            this.context.getLogger().trace(startSessionException);
            if (startSessionException instanceof RuntimeException) {
                throw (RuntimeException)startSessionException;
            }
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), startSessionException);
        }
        if (null != endSessionException) {
            this.context.getLogger().error(RB.$((String)"workflow.failure", (Object[])new Object[0]), new Object[]{TimeUtils.formatDuration((double)duration)});
            this.context.getLogger().trace(endSessionException);
            if (endSessionException instanceof RuntimeException) {
                throw (RuntimeException)endSessionException;
            }
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), endSessionException);
        }
        if (null == stepException) {
            if (null != listenerException) {
                if (listenerException instanceof RuntimeException) {
                    throw (RuntimeException)listenerException;
                }
                throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), listenerException);
            }
        } else {
            this.context.getLogger().error(RB.$((String)"workflow.failure", (Object[])new Object[0]), new Object[]{TimeUtils.formatDuration((double)duration)});
            this.context.getLogger().trace((Throwable)stepException);
            throw stepException;
        }
        this.context.getLogger().info(RB.$((String)"workflow.success", (Object[])new Object[0]), new Object[]{TimeUtils.formatDuration((double)duration)});
    }

    private void logFilters(String key, List<String> input) {
        if (!input.isEmpty()) {
            this.context.getLogger().info(RB.$((String)key, (Object[])new Object[]{input}));
        }
    }
}

