/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.release.Releasers;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Screenshot;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.FlatpakPackager;
import org.jreleaser.model.internal.packagers.TemplatePackager;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.release.GithubReleaser;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.packagers.AppdataUtils;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.StringUtils;

public class FlatpakPackagerProcessor
extends AbstractRepositoryPackagerProcessor<FlatpakPackager> {
    public FlatpakPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPrepareDistribution(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        this.setupPrepare(distribution, props);
        super.doPrepareDistribution(distribution, props);
    }

    private void setupPrepare(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        Artifact artifact = (Artifact)props.get("distributionArtifact");
        Path artifactPath = artifact.getResolvedPath(this.context, distribution);
        String artifactFileName = StringUtils.getFilename((String)artifactPath.getFileName().toString(), (Collection)((FlatpakPackager)this.packager).getSupportedFileExtensions(distribution.getType()));
        if (distribution.getType() == Distribution.DistributionType.FLAT_BINARY) {
            props.set("specDirectories", Collections.emptyList());
            props.set("specBinaries", Collections.singletonList(distribution.getExecutable().resolveExecutable("linux")));
            props.set("specFiles", Collections.emptyList());
        } else {
            try {
                FileUtils.CategorizedArchive categorizedArchive = FileUtils.categorizeUnixArchive((String)artifactFileName, (String)distribution.getExecutable().resolveWindowsExtension(), (Path)artifactPath);
                props.set("flatpakDirectories", (Object)categorizedArchive.getDirectories());
                props.set("flatpakBinaries", (Object)categorizedArchive.getBinaries());
                props.set("flatpakFiles", (Object)categorizedArchive.getFiles());
            }
            catch (IOException e) {
                throw new PackagerProcessingException("ERROR", (Throwable)e);
            }
        }
        BaseReleaser releaser = this.context.getModel().getRelease().getReleaser();
        try {
            props.set("flatpakReleases", Releasers.releaserFor(this.context).listReleases(releaser.getOwner(), releaser.getName()).stream().filter(r -> AppdataUtils.isReleaseIncluded(((FlatpakPackager)this.packager).getSkipReleases(), r.getVersion().toString())).map(r -> AppdataUtils.Release.of(r.getUrl(), r.getVersion().toString(), r.getPublishedAt())).collect(Collectors.toList()));
        }
        catch (IOException e) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
        props.set("flatpakScreenshots", ((FlatpakPackager)this.packager).getScreenshots().stream().map(Screenshot::asScreenshotTemplate).collect(Collectors.toList()));
        this.context.getLogger().debug(RB.$((String)"packager.fetch.icons", (Object[])new Object[0]));
        props.set("flatpakIcons", (Object)((FlatpakPackager)this.packager).getIcons());
        AppdataUtils.resolveIcons(this.context, (TemplatePackager)this.packager, distribution, props, ((FlatpakPackager)this.packager).getIcons());
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, TemplateContext props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(props);
    }

    @Override
    protected void fillPackagerProperties(TemplateContext props, Distribution distribution) {
        props.set("projectAuthors", (Object)this.context.getModel().getProject().getAuthors());
        props.set("flatpakUrls", (Object)this.context.getModel().getProject().getLinks().asLinkTemplates());
        props.set("flatpakComponentId", (Object)((FlatpakPackager)this.getPackager()).getComponentId());
        props.set("flatpakCategories", (Object)((FlatpakPackager)this.getPackager()).getCategories());
        props.set("flatpakCategoriesByComma", (Object)String.join((CharSequence)",", ((FlatpakPackager)this.getPackager()).getCategories()));
        props.set("flatpakCategoriesBySemicolon", (Object)(String.join((CharSequence)";", ((FlatpakPackager)this.getPackager()).getCategories()) + (((FlatpakPackager)this.getPackager()).getCategories().size() > 1 ? ";" : "")));
        props.set("flatpakDeveloperName", (Object)((FlatpakPackager)this.getPackager()).getDeveloperName());
        props.set("flatpakRepoOwner", (Object)((FlatpakPackager)this.packager).getRepository().getOwner());
        props.set("flatpakRepoName", (Object)((FlatpakPackager)this.packager).getRepository().getName());
        props.set("flatpakHasSdkExtensions", (Object)(!((FlatpakPackager)this.packager).getSdkExtensions().isEmpty() ? 1 : 0));
        props.set("flatpakSdkExtensions", (Object)((FlatpakPackager)this.packager).getSdkExtensions());
        props.set("flatpakHasFinishArgs", (Object)(!((FlatpakPackager)this.packager).getFinishArgs().isEmpty() ? 1 : 0));
        props.set("flatpakFinishArgs", ((FlatpakPackager)this.packager).getFinishArgs().stream().map(MustacheUtils::passThrough).collect(Collectors.toList()));
        props.set("flatpakRuntime", (Object)((FlatpakPackager)this.packager).getRuntime().runtime());
        props.set("flatpakRuntimeVersion", (Object)((FlatpakPackager)this.packager).getRuntimeVersion());
        props.set("flatpakSdk", (Object)((FlatpakPackager)this.packager).getRuntime().sdk());
        props.set("flatpakIncludeOpenJdk", (Object)StringUtils.isFalse(((FlatpakPackager)this.packager).getExtraProperties().get("skipOpenjdk")));
    }

    @Override
    protected void writeFile(Distribution distribution, String content, TemplateContext props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        Optional<Stereotype> stereotype;
        BaseReleaser gitService = this.context.getModel().getRelease().getReleaser();
        if (fileName.contains("github") && !(gitService instanceof GithubReleaser)) {
            return;
        }
        if (fileName.contains("-github")) {
            fileName = org.apache.commons.lang3.StringUtils.remove((String)fileName, (String)"-github");
        }
        if ((stereotype = this.resolveStereotype(fileName = TemplateUtils.trimTplExtension((String)fileName))).isPresent()) {
            if (distribution.getStereotype() == stereotype.get()) {
                fileName = fileName.substring(distribution.getStereotype().toString().length() + 1);
            } else {
                return;
            }
        }
        Path outputFile = outputDirectory.resolve(fileName);
        if ("app.yml".equals(fileName)) {
            outputFile = outputDirectory.resolve(((FlatpakPackager)this.getPackager()).getComponentId() + ".yml");
        } else if ("app.desktop".equals(fileName)) {
            outputFile = outputDirectory.resolve(((FlatpakPackager)this.getPackager()).getComponentId() + ".desktop");
        } else if ("metainfo.xml".equals(fileName)) {
            outputFile = outputDirectory.resolve(((FlatpakPackager)this.getPackager()).getComponentId() + ".metainfo.xml");
        }
        this.writeFile(content, outputFile);
    }
}

