/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jreleaser.cli.AbstractModelCommand;
import org.jreleaser.util.PlatformUtils;
import picocli.CommandLine;

@CommandLine.Command
public abstract class AbstractPlatformAwareModelCommand
extends AbstractModelCommand {
    @CommandLine.Option(names={"-scp", "--select-current-platform"})
    Boolean selectCurrentPlatform;
    @CommandLine.Option(names={"-sp", "--select-platform"}, paramLabel="<platform>")
    String[] selectPlatforms;
    @CommandLine.Option(names={"-rp", "--reject-platform"}, paramLabel="<platform>")
    String[] rejectedPlatforms;

    @Override
    protected List<String> collectSelectedPlatforms() {
        boolean resolvedSelectCurrentPlatform = this.resolveBoolean("SELECT_CURRENT_PLATFORM", this.selectCurrentPlatform);
        if (resolvedSelectCurrentPlatform) {
            return Collections.singletonList(PlatformUtils.getCurrentFull());
        }
        ArrayList<String> list = new ArrayList<String>();
        if (this.selectPlatforms != null && this.selectPlatforms.length > 0) {
            Collections.addAll(list, this.selectPlatforms);
        }
        return this.resolveCollection("SELECT_PLATFORMS", list);
    }

    @Override
    protected List<String> collectRejectedPlatforms() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.rejectedPlatforms != null && this.rejectedPlatforms.length > 0) {
            Collections.addAll(list, this.rejectedPlatforms);
        }
        return this.resolveCollection("REJECT_PLATFORMS", list);
    }
}

