/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.ScoopPackager;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.Templates;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.StringUtils;

public class ScoopPackagerProcessor
extends AbstractRepositoryPackagerProcessor<ScoopPackager> {
    public ScoopPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
    }

    @Override
    protected void fillPackagerProperties(Map<String, Object> props, Distribution distribution) throws PackagerProcessingException {
        BaseReleaser releaser = this.context.getModel().getRelease().getReleaser();
        props.put("scoopBucketRepoUrl", releaser.getResolvedRepoUrl(this.context.getModel(), ((ScoopPackager)this.packager).getBucket().getOwner(), ((ScoopPackager)this.packager).getBucket().getResolvedName()));
        props.put("scoopBucketRepoCloneUrl", releaser.getResolvedRepoCloneUrl(this.context.getModel(), ((ScoopPackager)this.packager).getBucket().getOwner(), ((ScoopPackager)this.packager).getBucket().getResolvedName()));
        props.put("scoopPackageName", ((ScoopPackager)this.packager).getPackageName());
        props.put("scoopCheckverUrl", this.resolveCheckverUrl(props));
        props.put("scoopAutoupdateUrl", this.resolveAutoupdateUrl(props, distribution));
        String autoupdateExtractDir = (String)props.get("distributionArtifactFileName");
        autoupdateExtractDir = autoupdateExtractDir.replace(this.context.getModel().getProject().getEffectiveVersion(), "$version");
        props.put("scoopAutoupdateExtractDir", autoupdateExtractDir);
    }

    private Object resolveCheckverUrl(Map<String, Object> props) {
        if (!((ScoopPackager)this.getPackager()).getCheckverUrl().contains("{{")) {
            return ((ScoopPackager)this.getPackager()).getCheckverUrl();
        }
        return Templates.resolveTemplate((String)((ScoopPackager)this.getPackager()).getCheckverUrl(), props);
    }

    private Object resolveAutoupdateUrl(Map<String, Object> props, Distribution distribution) {
        String url = ((ScoopPackager)this.getPackager()).getAutoupdateUrl();
        if (StringUtils.isBlank((String)url)) {
            Artifact artifact = (Artifact)props.get("distributionArtifact");
            url = Artifacts.resolveDownloadUrl((JReleaserContext)this.context, (String)"scoop", (Distribution)distribution, (Artifact)artifact);
        }
        String artifactFile = (String)props.get("distributionArtifactFile");
        String projectVersion = (String)props.get("projectVersion");
        String tagName = (String)props.get("tagName");
        url = url.replace(projectVersion, "$version");
        artifactFile = artifactFile.replace(projectVersion, "$version");
        tagName = tagName.replace(projectVersion, "$version");
        LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(props);
        copy.put("projectVersion", "$version");
        copy.put("projectEffectiveVersion", "$version");
        copy.put("tagName", tagName);
        copy.put("artifactFile", artifactFile);
        return Templates.resolveTemplate((String)url, copy);
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        Path outputFile = "manifest.json".equals(fileName = TemplateUtils.trimTplExtension((String)fileName)) ? outputDirectory.resolve("bucket").resolve(((ScoopPackager)this.packager).getPackageName().concat(".json")) : outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }
}

