/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.context;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.release.Releasers;
import org.jreleaser.extensions.api.ExtensionManager;
import org.jreleaser.extensions.api.ExtensionManagerHolder;
import org.jreleaser.extensions.internal.DefaultExtensionManager;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModelPrinter;
import org.jreleaser.model.internal.extensions.Extension;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class ModelValidator {
    public static void validate(JReleaserContext context) {
        try {
            Errors errors = context.validateModel();
            new JReleaserModelPrinter.Plain(context.getLogger().getTracer()).print((Object)context.getModel().asMap(true));
            if (context.isStrict() && errors.hasWarnings()) {
                throw new JReleaserException(RB.$((String)"ERROR_context_configurer_jreleaser_misconfigured", (Object[])new Object[0]) + System.lineSeparator() + errors.warningsAsString());
            }
            switch (context.getMode()) {
                case ANNOUNCE: 
                case CHANGELOG: 
                case DOWNLOAD: 
                case ASSEMBLE: 
                case DEPLOY: {
                    if (errors.hasConfigurationErrors()) {
                        throw new JReleaserException(RB.$((String)"ERROR_context_configurer_jreleaser_misconfigured", (Object[])new Object[0]) + System.lineSeparator() + errors.asString());
                    }
                    break;
                }
                default: {
                    if (errors.hasErrors()) {
                        throw new JReleaserException(RB.$((String)"ERROR_context_configurer_jreleaser_misconfigured", (Object[])new Object[0]) + System.lineSeparator() + errors.asString());
                    }
                }
            }
        }
        catch (JReleaserException e) {
            context.getLogger().trace((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            context.getLogger().trace((Throwable)e);
            throw new JReleaserException(RB.$((String)"ERROR_context_configurer_jreleaser_misconfigured", (Object[])new Object[0]), (Throwable)e);
        }
        if (!context.getMode().validateStandalone()) {
            context.setReleaser(Releasers.releaserFor(context));
        }
        ModelValidator.report(context);
        ModelValidator.loadExtensions(context);
    }

    private static void report(JReleaserContext context) {
        String version = context.getModel().getProject().getVersion();
        context.getModel().getProject().parseVersion();
        context.getLogger().info(RB.$((String)"context.creator.report.project-version", (Object[])new Object[0]), new Object[]{version});
        context.getLogger().info(RB.$((String)"context.creator.report.release", (Object[])new Object[0]), new Object[]{context.getModel().getProject().isSnapshot() ? " " : " " + RB.$((String)"not", (Object[])new Object[0]) + " "});
        context.getLogger().info(RB.$((String)"context.creator.report.timestamp", (Object[])new Object[0]), new Object[]{context.getModel().getTimestamp()});
        if (context.getModel().getCommit() != null) {
            context.getLogger().info(RB.$((String)"context.creator.report.head", (Object[])new Object[0]), new Object[]{context.getModel().getCommit().getShortHash()});
        }
        context.getLogger().info(RB.$((String)"context.creator.report.platform", (Object[])new Object[0]), new Object[]{PlatformUtils.getCurrentFull()});
    }

    private static void loadExtensions(JReleaserContext context) {
        ExtensionManager em = ExtensionManagerHolder.get();
        if (!(em instanceof DefaultExtensionManager)) {
            context.getLogger().warn(RB.$((String)"context.creator.extension.manager.error", (Object[])new Object[0]));
            return;
        }
        DefaultExtensionManager extensionManager = (DefaultExtensionManager)em;
        for (Map.Entry e : context.getModel().getExtensions().entrySet()) {
            Extension extension = (Extension)e.getValue();
            DefaultExtensionManager.ExtensionBuilder builder = extensionManager.configureExtension((String)e.getKey()).withEnabled(extension.isEnabled());
            if (StringUtils.isNotBlank((String)extension.getGav())) {
                builder = builder.withGav(extension.getGav());
            }
            if (StringUtils.isNotBlank((String)extension.getDirectory())) {
                builder = builder.withDirectory(extension.getDirectory());
            }
            for (Extension.Provider provider : extension.getProviders()) {
                builder = builder.withExtensionPoint(provider.getType(), provider.getProperties());
            }
            builder.build();
        }
        extensionManager.load(context);
    }
}

