/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.signing;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Signing;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.api.signing.Keyring;
import org.jreleaser.model.api.signing.Signing;
import org.jreleaser.model.api.signing.SigningException;
import org.jreleaser.sdk.command.CommandException;
import org.jreleaser.sdk.signing.GpgCommandSigner;

public class SigningUtils {
    public static void sign(JReleaserContext context, Path file) throws SigningException {
        if (context.getModel().getSigning().getMode() == Signing.Mode.COMMAND) {
            SigningUtils.cmdSign(context, file);
        } else if (context.getModel().getSigning().getMode() != Signing.Mode.COSIGN) {
            SigningUtils.bcSign(context, file);
        }
    }

    private static void cmdSign(JReleaserContext context, Path input) throws SigningException {
        FilePair pair = SigningUtils.checkInput(context, input);
        if (pair.isValid()) {
            return;
        }
        SigningUtils.sign(context, pair);
        SigningUtils.verify(context, pair);
    }

    private static void bcSign(JReleaserContext context, Path input) throws SigningException {
        Keyring keyring = context.createKeyring();
        FilePair pair = SigningUtils.checkInput(context, input);
        if (pair.isValid()) {
            return;
        }
        SigningUtils.sign(context, keyring, pair);
        SigningUtils.verify(context, keyring, pair);
    }

    private static FilePair checkInput(JReleaserContext context, Path input) {
        Signing signing = context.getModel().getSigning();
        String extension = ".sig";
        if (signing.getMode() != Signing.Mode.COSIGN) {
            extension = signing.isArmored() ? ".asc" : ".sig";
        }
        Path output = input.getParent().resolve(input.getFileName().toString().concat(extension));
        FilePair pair = new FilePair(input, output);
        pair.setValid(SigningUtils.isValid(context, pair));
        return pair;
    }

    public static boolean verify(JReleaserContext context, Keyring keyring, FilePair filePair) throws SigningException {
        context.getLogger().setPrefix("verify");
        try {
            int ch;
            context.getLogger().debug("{}", new Object[]{context.relativizeToBasedir(filePair.signatureFile)});
            InputStream sigInputStream = PGPUtil.getDecoderStream((InputStream)new BufferedInputStream(new FileInputStream(filePair.signatureFile.toFile())));
            PGPObjectFactory pgpObjFactory = new PGPObjectFactory(sigInputStream, keyring.getKeyFingerPrintCalculator());
            Iterable pgpSigList = null;
            Object obj = pgpObjFactory.nextObject();
            if (obj instanceof PGPCompressedData) {
                PGPCompressedData c1 = (PGPCompressedData)obj;
                pgpObjFactory = new PGPObjectFactory(c1.getDataStream(), keyring.getKeyFingerPrintCalculator());
                pgpSigList = (Iterable)pgpObjFactory.nextObject();
            } else {
                pgpSigList = (Iterable)obj;
            }
            BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(filePair.inputFile.toFile()));
            PGPSignature sig = (PGPSignature)pgpSigList.iterator().next();
            PGPPublicKey pubKey = keyring.readPublicKey();
            sig.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pubKey);
            while ((ch = ((InputStream)fileInputStream).read()) >= 0) {
                sig.update((byte)ch);
            }
            ((InputStream)fileInputStream).close();
            sigInputStream.close();
            boolean bl = sig.verify();
            return bl;
        }
        catch (IOException | PGPException e) {
            throw new SigningException(RB.$((String)"ERROR_signing_verify_signature", (Object[])new Object[]{context.relativizeToBasedir(filePair.inputFile)}), e);
        }
        finally {
            context.getLogger().restorePrefix();
        }
    }

    public static boolean verify(JReleaserContext context, FilePair filePair) throws SigningException {
        context.getLogger().setPrefix("verify");
        try {
            context.getLogger().debug("{}", new Object[]{context.relativizeToBasedir(filePair.signatureFile)});
            GpgCommandSigner commandSigner = SigningUtils.initCommandSigner(context);
            boolean bl = commandSigner.verify(filePair.signatureFile, filePair.inputFile);
            return bl;
        }
        catch (CommandException e) {
            throw new SigningException(RB.$((String)"ERROR_signing_verify_signature", (Object[])new Object[]{context.relativizeToBasedir(filePair.inputFile)}), (Throwable)e);
        }
        finally {
            context.getLogger().restorePrefix();
        }
    }

    private static void sign(JReleaserContext context, FilePair pair) throws SigningException {
        GpgCommandSigner commandSigner = SigningUtils.initCommandSigner(context);
        SigningUtils.sign(context, commandSigner, pair.inputFile, pair.signatureFile);
    }

    public static GpgCommandSigner initCommandSigner(JReleaserContext context) {
        GpgCommandSigner cmd = new GpgCommandSigner(context.getLogger());
        Signing signing = context.getModel().getSigning();
        cmd.setExecutable(signing.getCommand().getExecutable());
        cmd.setPassphrase(signing.getPassphrase());
        cmd.setHomeDir(signing.getCommand().getHomeDir());
        cmd.setKeyName(signing.getCommand().getKeyName());
        cmd.setPublicKeyring(signing.getCommand().getPublicKeyring());
        cmd.setDefaultKeyring(signing.getCommand().isDefaultKeyring());
        cmd.setArgs(signing.getCommand().getArgs());
        return cmd;
    }

    public static void sign(JReleaserContext context, GpgCommandSigner commandSigner, Path input, Path output) throws SigningException {
        try {
            context.getLogger().info("{}", new Object[]{context.relativizeToBasedir(input)});
            commandSigner.sign(input, output);
        }
        catch (CommandException e) {
            throw new SigningException(RB.$((String)"ERROR_unexpected_error_signing", (Object[])new Object[]{input.toAbsolutePath()}), (Throwable)e);
        }
    }

    private static void sign(JReleaserContext context, Keyring keyring, FilePair pair) throws SigningException {
        PGPSignatureGenerator signatureGenerator = SigningUtils.initSignatureGenerator(context.getModel().getSigning(), keyring);
        SigningUtils.sign(context, signatureGenerator, pair.inputFile, pair.signatureFile);
    }

    public static PGPSignatureGenerator initSignatureGenerator(Signing signing, Keyring keyring) throws SigningException {
        try {
            PGPSecretKey pgpSecretKey = keyring.getSecretKey();
            PGPPrivateKey pgpPrivKey = pgpSecretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(signing.getPassphrase().toCharArray()));
            PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(pgpSecretKey.getPublicKey().getAlgorithm(), 2).setProvider("BC"));
            signatureGenerator.init(0, pgpPrivKey);
            return signatureGenerator;
        }
        catch (PGPException e) {
            throw new SigningException(RB.$((String)"ERROR_unexpected_error_signature_gen", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public static void sign(JReleaserContext context, PGPSignatureGenerator signatureGenerator, Path input, Path output) throws SigningException {
        try {
            context.getLogger().info("{}", new Object[]{context.relativizeToBasedir(input)});
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(output.toFile()));
            if (context.getModel().getSigning().isArmored()) {
                out = new ArmoredOutputStream((OutputStream)out);
            }
            PGPCompressedDataGenerator compressionStreamGenerator = new PGPCompressedDataGenerator(0);
            BCPGOutputStream bOut = new BCPGOutputStream(compressionStreamGenerator.open((OutputStream)out));
            FileInputStream in = new FileInputStream(input.toFile());
            byte[] buffer = new byte[8192];
            int length = 0;
            while ((length = in.read(buffer)) >= 0) {
                signatureGenerator.update(buffer, 0, length);
            }
            signatureGenerator.generate().encode((OutputStream)bOut);
            compressionStreamGenerator.close();
            in.close();
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        }
        catch (IOException | PGPException e) {
            throw new SigningException(RB.$((String)"ERROR_unexpected_error_signing", (Object[])new Object[]{input.toAbsolutePath()}), e);
        }
    }

    public static boolean isValid(JReleaserContext context, FilePair pair) {
        if (Files.notExists(pair.getSignatureFile(), new LinkOption[0])) {
            context.getLogger().debug(RB.$((String)"signing.signature.not.exist", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(pair.getSignatureFile())});
            return false;
        }
        if (pair.inputFile.toFile().lastModified() > pair.signatureFile.toFile().lastModified()) {
            context.getLogger().debug(RB.$((String)"signing.file.newer", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(pair.inputFile), context.relativizeToBasedir(pair.signatureFile)});
            return false;
        }
        try {
            return SigningUtils.verify(context, pair);
        }
        catch (SigningException e) {
            return false;
        }
    }

    public static boolean isValid(JReleaserContext context, Keyring keyring, FilePair pair) {
        if (null == keyring) {
            return SigningUtils.isValid(context, pair);
        }
        if (Files.notExists(pair.getSignatureFile(), new LinkOption[0])) {
            context.getLogger().debug(RB.$((String)"signing.signature.not.exist", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(pair.getSignatureFile())});
            return false;
        }
        if (pair.inputFile.toFile().lastModified() > pair.signatureFile.toFile().lastModified()) {
            context.getLogger().debug(RB.$((String)"signing.file.newer", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(pair.inputFile), context.relativizeToBasedir(pair.signatureFile)});
            return false;
        }
        try {
            return SigningUtils.verify(context, keyring, pair);
        }
        catch (SigningException e) {
            return false;
        }
    }

    static {
        Provider bcProvider = Security.getProvider("BC");
        Security.removeProvider("BC");
        Security.setProperty("crypto.policy", "unlimited");
        Security.addProvider(bcProvider != null ? bcProvider : new BouncyCastleProvider());
    }

    public static class FilePair {
        private final Path inputFile;
        private final Path signatureFile;
        private boolean valid;

        public FilePair(Path inputFile, Path signatureFile) {
            this.inputFile = inputFile;
            this.signatureFile = signatureFile;
        }

        public Path getInputFile() {
            return this.inputFile;
        }

        public Path getSignatureFile() {
            return this.signatureFile;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        public boolean isInvalid() {
            return !this.valid;
        }
    }
}

