/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.config.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import org.jreleaser.config.JReleaserConfigParser;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.util.StringUtils;

public class JsonJReleaserConfigParser
implements JReleaserConfigParser {
    public String getPreferredFileExtension() {
        return "json";
    }

    public boolean supports(Path configFile) {
        return this.supports(configFile.getFileName().toString());
    }

    public boolean supports(String resource) {
        return StringUtils.isNotBlank((String)resource) && resource.endsWith(".json");
    }

    public void validate(Path configFile) throws IOException {
    }

    public JReleaserModel parse(InputStream inputStream) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (JReleaserModel)objectMapper.readValue(inputStream, JReleaserModel.class);
    }

    public <T> T load(Class<T> type, InputStream inputStream) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (T)objectMapper.readValue(inputStream, type);
    }

    public Map<String, String> properties(InputStream inputStream) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (Map)objectMapper.readValue(inputStream, Map.class);
    }
}

