/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.exec.listener;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.listener.ProcessListener;

public class CompositeProcessListener
extends ProcessListener
implements Cloneable {
    private final List<ProcessListener> children = new CopyOnWriteArrayList<ProcessListener>();

    public CompositeProcessListener() {
    }

    public CompositeProcessListener(List<ProcessListener> children) {
        this.children.addAll(children);
    }

    public void add(ProcessListener listener) {
        this.children.add(listener);
    }

    public void remove(ProcessListener listener) {
        this.children.remove(listener);
    }

    public void removeAll(Class<? extends ProcessListener> type) {
        Iterator<ProcessListener> it = this.children.iterator();
        while (it.hasNext()) {
            if (!type.isInstance(it.next())) continue;
            it.remove();
        }
    }

    public void clear() {
        this.children.clear();
    }

    public CompositeProcessListener clone() {
        return new CompositeProcessListener(this.children);
    }

    @Override
    public void beforeStart(ProcessExecutor executor) {
        for (ProcessListener child : this.children) {
            child.beforeStart(executor);
        }
    }

    @Override
    public void afterStart(Process process, ProcessExecutor executor) {
        for (ProcessListener child : this.children) {
            child.afterStart(process, executor);
        }
    }

    @Override
    public void afterFinish(Process process, ProcessResult result) {
        for (ProcessListener child : this.children) {
            child.afterFinish(process, result);
        }
    }

    @Override
    public void afterStop(Process process) {
        for (ProcessListener child : this.children) {
            child.afterStop(process);
        }
    }
}

