/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.version;

import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.Version;

public class CalVer
implements Version<CalVer> {
    private static final Map<String, String> PATTERNS = new LinkedHashMap<String, String>();
    private static final String YEAR = "YEAR";
    private static final String YEAR_LONG = "YYYY";
    private static final String YEAR_SHORT = "YY";
    private static final String YEAR_ZERO = "0Y";
    private static final String MONTH = "MONTH";
    private static final String MONTH_SHORT = "MM";
    private static final String MONTH_ZERO = "0M";
    private static final String WEEK = "WEEK";
    private static final String WEEK_SHORT = "WW";
    private static final String WEEK_ZERO = "0W";
    private static final String DAY = "DAY";
    private static final String DAY_SHORT = "DD";
    private static final String DAY_ZERO = "0D";
    private static final String MINOR = "MINOR";
    private static final String MICRO = "MICRO";
    private static final String MODIFIER = "MODIFIER";
    private static final String MODIFIER_OP = "[MODIFIER]";
    private static final String MODIFIER_OP2 = "MODIFIER]";
    private static final String[] YEARS = new String[]{"0Y", "YY", "YYYY"};
    private static final String[] MONTHS = new String[]{"0M", "MM"};
    private static final String[] WEEKS = new String[]{"0W", "WW"};
    private static final String[] DAYS = new String[]{"0D", "DD"};
    private static final String[] NUMBERS = new String[]{"MICRO", "MINOR"};
    private final String year;
    private final String month;
    private final String week;
    private final String day;
    private final String minor;
    private final String micro;
    private final String modifier;
    private final String pattern;
    private final int yearAsInt;
    private final int monthAsInt;
    private final int weekAsInt;
    private final int dayAsInt;
    private final int minorAsInt;
    private final int microAsInt;

    public CalVer(String pattern, Map<String, String> elements) {
        String y = elements.get(YEAR);
        String m = elements.get(MONTH);
        String w = elements.get(WEEK);
        String d = elements.get(DAY);
        String n = elements.get(MINOR);
        String r = elements.get(MICRO);
        String o = elements.get(MODIFIER);
        this.pattern = pattern;
        this.year = StringUtils.isNotBlank((String)y) ? y.trim() : null;
        this.month = StringUtils.isNotBlank((String)m) ? m.trim() : null;
        this.week = StringUtils.isNotBlank((String)w) ? w.trim() : null;
        this.day = StringUtils.isNotBlank((String)d) ? d.trim() : null;
        this.minor = StringUtils.isNotBlank((String)n) ? n.trim() : null;
        this.micro = StringUtils.isNotBlank((String)r) ? r.trim() : null;
        this.modifier = StringUtils.isNotBlank((String)o) ? o.trim() : null;
        this.yearAsInt = StringUtils.isBlank((String)this.year) ? -1 : CalVer.parseInt(this.year);
        this.monthAsInt = StringUtils.isBlank((String)this.month) ? -1 : CalVer.parseInt(this.month);
        this.weekAsInt = StringUtils.isBlank((String)this.week) ? -1 : CalVer.parseInt(this.week);
        this.dayAsInt = StringUtils.isBlank((String)this.day) ? -1 : CalVer.parseInt(this.day);
        this.minorAsInt = StringUtils.isBlank((String)this.minor) ? -1 : CalVer.parseInt(this.minor);
        int n2 = this.microAsInt = StringUtils.isBlank((String)this.micro) ? -1 : CalVer.parseInt(this.micro);
        if (this.yearAsInt != -1 && this.monthAsInt != -1 && this.dayAsInt != -1 && this.dayAsInt > YearMonth.of(this.yearAsInt, this.monthAsInt).lengthOfMonth()) {
            throw new IllegalArgumentException(RB.$((String)"ERROR_version_parse", (Object[])new Object[]{this}));
        }
    }

    public boolean hasYear() {
        return StringUtils.isNotBlank((String)this.year);
    }

    public boolean hasMonth() {
        return StringUtils.isNotBlank((String)this.month);
    }

    public boolean hasWeek() {
        return StringUtils.isNotBlank((String)this.week);
    }

    public boolean hasDay() {
        return StringUtils.isNotBlank((String)this.day);
    }

    public boolean hasMinor() {
        return StringUtils.isNotBlank((String)this.minor);
    }

    public boolean hasMicro() {
        return StringUtils.isNotBlank((String)this.micro);
    }

    public boolean hasModifier() {
        return StringUtils.isNotBlank((String)this.modifier);
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getYear() {
        return this.year;
    }

    public String getMonth() {
        return this.month;
    }

    public String getWeek() {
        return this.week;
    }

    public String getDay() {
        return this.day;
    }

    public String getMinor() {
        return this.minor;
    }

    public String getMicro() {
        return this.micro;
    }

    public String getModifier() {
        return this.modifier;
    }

    public int getYearAsInt() {
        return this.yearAsInt;
    }

    public int getMonthAsInt() {
        return this.monthAsInt;
    }

    public int getWeekAsInt() {
        return this.weekAsInt;
    }

    public int getDayAsInt() {
        return this.dayAsInt;
    }

    public int getMinorAsInt() {
        return this.minorAsInt;
    }

    public int getMicroAsInt() {
        return this.microAsInt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalVer version = (CalVer)o;
        return Objects.equals(this.pattern, version.pattern) && Objects.equals(this.year, version.year) && Objects.equals(this.month, version.month) && Objects.equals(this.week, version.week) && Objects.equals(this.day, version.day) && Objects.equals(this.minor, version.minor) && Objects.equals(this.micro, version.micro) && Objects.equals(this.modifier, version.modifier);
    }

    @Override
    public String toRpmVersion() {
        return this.toString().replace("-", "_");
    }

    public String toString() {
        String str = this.safeReplace(this.pattern, YEAR_LONG, this.year);
        str = this.safeReplace(str, YEAR_SHORT, this.year);
        str = this.safeReplace(str, YEAR_ZERO, this.year);
        str = this.safeReplace(str, MONTH_SHORT, this.month);
        str = this.safeReplace(str, MONTH_ZERO, this.month);
        str = this.safeReplace(str, WEEK_SHORT, this.week);
        str = this.safeReplace(str, WEEK_ZERO, this.week);
        str = this.safeReplace(str, DAY_SHORT, this.day);
        str = this.safeReplace(str, DAY_ZERO, this.day);
        str = this.safeReplace(str, MINOR, this.minor);
        str = this.safeReplace(str, MICRO, this.micro);
        str = this.safeReplace(str, MODIFIER, this.modifier);
        str = this.safeReplace(str, "[", "");
        str = this.safeReplace(str, "]", "");
        return str;
    }

    private String safeReplace(String str, CharSequence target, CharSequence replacement) {
        if (null != replacement) {
            return str.replace(target, replacement);
        }
        return str;
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.year, this.month, this.week, this.day, this.minor, this.micro, this.modifier);
    }

    @Override
    public int compareTo(CalVer other) {
        int result = this.pattern.compareTo(other.pattern);
        if (result == 0) {
            result = this.yearAsInt - (other.hasYear() ? other.yearAsInt : 0);
        }
        if (result == 0) {
            int n = this.hasMonth() ? this.monthAsInt - (other.hasMonth() ? other.monthAsInt : 0) : (result = 0);
        }
        if (result == 0) {
            int n = this.hasWeek() ? this.weekAsInt - (other.hasWeek() ? other.weekAsInt : 0) : (result = 0);
        }
        if (result == 0) {
            int n = this.hasDay() ? this.dayAsInt - (other.hasDay() ? other.dayAsInt : 0) : (result = 0);
        }
        if (result == 0) {
            int n = this.hasMinor() ? this.minorAsInt - (other.hasMinor() ? other.minorAsInt : 0) : (result = 0);
        }
        if (result == 0) {
            int n = this.hasMicro() ? this.microAsInt - (other.hasMicro() ? other.microAsInt : 0) : (result = 0);
        }
        if (result == 0 && StringUtils.isNotBlank((String)this.modifier)) {
            result = StringUtils.isNotBlank((String)other.modifier) ? this.modifier.compareTo(other.modifier) : -1;
        }
        return result;
    }

    @Override
    public boolean equalsSpec(CalVer version) {
        return this.pattern.equals(version.pattern);
    }

    private static int parseInt(String str) {
        if ("0".equals(str)) {
            return 0;
        }
        if (str.startsWith("0")) {
            return Integer.parseInt(str.substring(1));
        }
        return Integer.parseInt(str);
    }

    public static CalVer of(String format, String version) {
        Pattern pattern;
        Matcher matcher;
        StringUtils.requireNonBlank((String)format, (String)"Argument 'format' must not be blank");
        StringUtils.requireNonBlank((String)version, (String)"Argument 'version' must not be blank");
        ArrayList<String> tokens = new ArrayList<String>();
        List delims = CollectionUtils.listOf((Object[])new Character[]{Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('-'), Character.valueOf('[')});
        String f = format.trim();
        String y = null;
        String m = null;
        String w = null;
        String d = null;
        String n = null;
        String r = null;
        String o = null;
        int i = 0;
        Tuple s = CalVer.take(f, i, delims);
        if (Arrays.binarySearch(YEARS, s.token) < 0) {
            throw new IllegalArgumentException(RB.$((String)"ERROR_calver_year", (Object[])new Object[]{f}));
        }
        y = s.token;
        tokens.add(y);
        if (StringUtils.isNotBlank((String)s.sep)) {
            tokens.add(s.sep);
        }
        if (Arrays.binarySearch(MONTHS, (s = CalVer.take(f, i = y.length() + 1, delims)).token) >= 0) {
            if (f.contains(WEEK_ZERO) || f.contains(WEEK_SHORT)) {
                throw new IllegalArgumentException(RB.$((String)"ERROR_calver_month", (Object[])new Object[]{f}));
            }
            m = s.token;
            tokens.add(m);
            if (StringUtils.isNotBlank((String)s.sep)) {
                tokens.add(s.sep);
            }
            if (Arrays.binarySearch(DAYS, (s = CalVer.take(f, i += m.length() + 1, delims)).token) >= 0) {
                d = s.token;
                tokens.add(d);
                if (StringUtils.isNotBlank((String)s.sep)) {
                    tokens.add(s.sep);
                }
                s = CalVer.take(f, i += d.length() + 1, delims);
            }
        } else if (Arrays.binarySearch(WEEKS, s.token) >= 0) {
            if (f.contains(MONTH_ZERO) || f.contains(MONTH_SHORT)) {
                throw new IllegalArgumentException(RB.$((String)"ERROR_calver_week_month", (Object[])new Object[]{f}));
            }
            if (f.contains(DAY_ZERO) || f.contains(DAY_SHORT)) {
                throw new IllegalArgumentException(RB.$((String)"ERROR_calver_week_day", (Object[])new Object[]{f}));
            }
            w = s.token;
            tokens.add(w);
            if (StringUtils.isNotBlank((String)s.sep)) {
                tokens.add(s.sep);
            }
            s = CalVer.take(f, i += w.length() + 1, delims);
        }
        boolean micro = false;
        boolean done = false;
        if (Arrays.binarySearch(NUMBERS, s.token) >= 0) {
            tokens.add(s.token);
            if (StringUtils.isNotBlank((String)s.sep)) {
                tokens.add(s.sep);
            }
            i += s.token.length() + 1;
            micro = MICRO.equals(s.token);
            n = !micro ? s.token : null;
            r = micro ? s.token : null;
            s = CalVer.take(f, i, delims);
            done = StringUtils.isBlank((String)s.token);
        } else {
            s = CalVer.take(f, i, Collections.emptyList());
            o = s.token;
            if (StringUtils.isNotBlank((String)o)) {
                tokens.add(o);
            }
            done = true;
        }
        if (!done) {
            if (Arrays.binarySearch(NUMBERS, s.token) >= 0) {
                if (micro) {
                    if (MICRO.equals(s.token)) {
                        throw new IllegalArgumentException(RB.$((String)"ERROR_calver_micro_duplicate", (Object[])new Object[]{f}));
                    }
                    throw new IllegalArgumentException(RB.$((String)"ERROR_calver_micro_minor", (Object[])new Object[]{f}));
                }
                if (MINOR.equals(s.token)) {
                    throw new IllegalArgumentException(RB.$((String)"ERROR_calver_minor_duplicate", (Object[])new Object[]{f}));
                }
                tokens.add(s.token);
                if (StringUtils.isNotBlank((String)s.sep)) {
                    tokens.add(s.sep);
                }
                if (StringUtils.isNotBlank((String)(o = (s = CalVer.take(f, i += (r = s.token).length() + 1, Collections.emptyList())).token))) {
                    tokens.add(o);
                }
            } else {
                s = CalVer.take(f, i, Collections.emptyList());
                o = s.token;
                if (StringUtils.isNotBlank((String)o)) {
                    tokens.add(o);
                }
            }
        }
        if (tokens.size() > 0 && ((String)tokens.get(tokens.size() - 1)).endsWith(MODIFIER_OP2)) {
            String sep = (String)tokens.remove(tokens.size() - 2);
            String mod = "(?:" + sep + PATTERNS.get(MODIFIER_OP);
            tokens.set(tokens.size() - 1, mod);
        }
        if ((matcher = (pattern = Pattern.compile("^" + tokens.stream().map(t -> PATTERNS.getOrDefault(t, (String)t)).collect(Collectors.joining("")) + "$")).matcher(version.trim())).matches()) {
            i = 1;
            LinkedHashMap<String, String> elements = new LinkedHashMap<String, String>();
            elements.put(YEAR, matcher.group(i++));
            if (StringUtils.isNotBlank((String)w)) {
                elements.put(WEEK, matcher.group(i++));
            }
            if (StringUtils.isNotBlank((String)m)) {
                elements.put(MONTH, matcher.group(i++));
            }
            if (StringUtils.isNotBlank((String)d)) {
                elements.put(DAY, matcher.group(i++));
            }
            if (StringUtils.isNotBlank((String)n)) {
                elements.put(MINOR, matcher.group(i++));
            }
            if (StringUtils.isNotBlank((String)r)) {
                elements.put(MICRO, matcher.group(i++));
            }
            if (i <= matcher.groupCount()) {
                elements.put(MODIFIER, matcher.group(matcher.groupCount()));
            }
            return new CalVer(format, elements);
        }
        throw new IllegalArgumentException(RB.$((String)"ERROR_version_parse_with", (Object[])new Object[]{version, f}));
    }

    public static CalVer defaultOf(String format) {
        StringUtils.requireNonBlank((String)format, (String)"Argument 'format' must not be blank");
        return CalVer.of(format, format.replace(YEAR_LONG, "2000").replace(YEAR_SHORT, "0").replace(YEAR_ZERO, "0").replace(MONTH_SHORT, "1").replace(MONTH_ZERO, "01").replace(WEEK_SHORT, "1").replace(WEEK_ZERO, "01").replace(DAY_SHORT, "1").replace(DAY_ZERO, "01").replace(MINOR, "0").replace(MICRO, "0").replace(MODIFIER, "A").replace("[", "").replace("]", ""));
    }

    private static Tuple take(String str, int index, List<Character> delims) {
        StringBuilder b = new StringBuilder();
        for (int i = index; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (delims.contains(Character.valueOf(c))) {
                if (c == '[' && str.length() > i + 1) {
                    c = str.charAt(i + 1);
                }
                return new Tuple(b.toString(), c);
            }
            b.append(c);
        }
        return new Tuple(b.toString(), '\u0000');
    }

    static {
        PATTERNS.put(YEAR_LONG, "([2-9][0-9]{3})");
        PATTERNS.put(YEAR_SHORT, "([1-9]|[1-9][0-9]|[1-9][0-9]{2})");
        PATTERNS.put(YEAR_ZERO, "(0[1-9]|[1-9][0-9]|[1-9][0-9]{2})");
        PATTERNS.put(MONTH_SHORT, "([1-9]|1[0-2])");
        PATTERNS.put(MONTH_ZERO, "(0[1-9]|1[0-2])");
        PATTERNS.put(WEEK_SHORT, "([1-9]|[1-4][0-9]|5[0-2])");
        PATTERNS.put(WEEK_ZERO, "(0[1-9]|[1-4][0-9]|5[0-2])");
        PATTERNS.put(DAY_SHORT, "([1-9]|[1-2][0-9]|3[0-1])");
        PATTERNS.put(DAY_ZERO, "(0[1-9]|[1-2][0-9]|3[0-1])");
        PATTERNS.put(MINOR, "(0|[1-9]\\d*)");
        PATTERNS.put(MICRO, "(0|[1-9]\\d*)");
        PATTERNS.put(MODIFIER, "([a-zA-Z\\-][0-9a-zA-Z\\-]*)");
        PATTERNS.put(MODIFIER_OP, "([a-zA-Z\\-][0-9a-zA-Z\\-]*))?");
    }

    private static class Tuple {
        private final String token;
        private final String sep;

        private Tuple(String token, char sep) {
            this.token = token;
            this.sep = sep != '\u0000' ? Tuple.escape(sep) : "";
        }

        private static String escape(char sep) {
            if ('.' == sep) {
                return "\\.";
            }
            return String.valueOf(sep);
        }
    }
}

