/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.common;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Screenshot;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.Assembler;
import org.jreleaser.model.internal.common.CommitAuthor;
import org.jreleaser.model.internal.common.CommitAuthorAware;
import org.jreleaser.model.internal.common.FileSet;
import org.jreleaser.model.internal.common.Glob;
import org.jreleaser.model.internal.common.Icon;
import org.jreleaser.model.internal.common.OwnerAware;
import org.jreleaser.model.internal.common.Screenshot;
import org.jreleaser.model.internal.common.TimeoutAware;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.environment.Environment;
import org.jreleaser.model.internal.packagers.Packager;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public class Validator {
    public static String checkProperty(JReleaserContext context, String key, String property, String value, Errors errors) {
        if (StringUtils.isNotBlank((String)value)) {
            return value;
        }
        Environment environment = context.getModel().getEnvironment();
        String dsl = context.getConfigurer().toString();
        String configFilePath = environment.getPropertiesFile().toAbsolutePath().normalize().toString();
        return Env.check((String)key, (String)environment.getVariable(key), (String)property, (String)dsl, (String)configFilePath, (Errors)errors);
    }

    public static String checkProperty(JReleaserContext context, String key, String property, String value, Errors errors, boolean dryrun) {
        if (StringUtils.isNotBlank((String)value)) {
            return value;
        }
        Environment environment = context.getModel().getEnvironment();
        String dsl = context.getConfigurer().toString();
        String configFilePath = environment.getPropertiesFile().toAbsolutePath().normalize().toString();
        return Env.check((String)key, (String)environment.getVariable(key), (String)property, (String)dsl, (String)configFilePath, (Errors)(dryrun ? new Errors() : errors));
    }

    public static Integer checkProperty(JReleaserContext context, String key, String property, Integer value, Errors errors, boolean dryrun) {
        if (null != value) {
            return value;
        }
        Environment environment = context.getModel().getEnvironment();
        String dsl = context.getConfigurer().toString();
        String configFilePath = environment.getPropertiesFile().toAbsolutePath().normalize().toString();
        String val = Env.check((String)key, (String)environment.getVariable(key), (String)property, (String)dsl, (String)configFilePath, (Errors)(dryrun ? new Errors() : errors));
        return StringUtils.isNotBlank((String)val) ? Integer.valueOf(Integer.parseInt(val)) : null;
    }

    public static String checkProperty(JReleaserContext context, String key, String property, String value, String defaultValue) {
        if (StringUtils.isNotBlank((String)value)) {
            return value;
        }
        Environment environment = context.getModel().getEnvironment();
        String dsl = context.getConfigurer().toString();
        String configFilePath = environment.getPropertiesFile().toAbsolutePath().normalize().toString();
        Errors errors = new Errors();
        String result = Env.check((String)key, (String)environment.getVariable(key), (String)property, (String)dsl, (String)configFilePath, (Errors)errors);
        return !errors.hasErrors() ? result : defaultValue;
    }

    public static boolean checkProperty(JReleaserContext context, String key, String property, Boolean value, boolean defaultValue) {
        if (null != value) {
            return value;
        }
        Environment environment = context.getModel().getEnvironment();
        String dsl = context.getConfigurer().toString();
        String configFilePath = environment.getPropertiesFile().toAbsolutePath().normalize().toString();
        Errors errors = new Errors();
        String result = Env.check((String)key, (String)environment.getVariable(key), (String)property, (String)dsl, (String)configFilePath, (Errors)errors);
        return !errors.hasErrors() ? Boolean.parseBoolean(result) : defaultValue;
    }

    public static <T extends Enum<T>> String checkProperty(JReleaserContext context, String key, String property, T value, T defaultValue) {
        if (null != value) {
            return value.name();
        }
        Environment environment = context.getModel().getEnvironment();
        String dsl = context.getConfigurer().toString();
        String configFilePath = environment.getPropertiesFile().toAbsolutePath().normalize().toString();
        Errors errors = new Errors();
        String result = Env.check((String)key, (String)environment.getVariable(key), (String)property, (String)dsl, (String)configFilePath, (Errors)errors);
        return !errors.hasErrors() ? result : (null != defaultValue ? defaultValue.name() : null);
    }

    public static String checkProperty(JReleaserContext context, Collection<String> keys, String property, String value, Errors errors) {
        if (StringUtils.isNotBlank((String)value)) {
            return value;
        }
        Environment environment = context.getModel().getEnvironment();
        String dsl = context.getConfigurer().toString();
        String configFilePath = environment.getPropertiesFile().toAbsolutePath().normalize().toString();
        return Env.check(keys, (Properties)environment.getVars(), (String)property, (String)dsl, (String)configFilePath, (Errors)errors);
    }

    public static String checkProperty(JReleaserContext context, Collection<String> keys, String property, String value, Errors errors, boolean dryrun) {
        if (StringUtils.isNotBlank((String)value)) {
            return value;
        }
        Environment environment = context.getModel().getEnvironment();
        String dsl = context.getConfigurer().toString();
        String configFilePath = environment.getPropertiesFile().toAbsolutePath().normalize().toString();
        return Env.check(keys, (Properties)environment.getVars(), (String)property, (String)dsl, (String)configFilePath, (Errors)(dryrun ? new Errors() : errors));
    }

    public static Integer checkProperty(JReleaserContext context, Collection<String> keys, String property, Integer value, Errors errors, boolean dryrun) {
        if (null != value) {
            return value;
        }
        Environment environment = context.getModel().getEnvironment();
        String dsl = context.getConfigurer().toString();
        String configFilePath = environment.getPropertiesFile().toAbsolutePath().normalize().toString();
        String val = Env.check(keys, (Properties)environment.getVars(), (String)property, (String)dsl, (String)configFilePath, (Errors)(dryrun ? new Errors() : errors));
        return StringUtils.isNotBlank((String)val) ? Integer.valueOf(Integer.parseInt(val)) : null;
    }

    public static String checkProperty(JReleaserContext context, Collection<String> keys, String property, String value, String defaultValue) {
        if (StringUtils.isNotBlank((String)value)) {
            return value;
        }
        Environment environment = context.getModel().getEnvironment();
        String dsl = context.getConfigurer().toString();
        String configFilePath = environment.getPropertiesFile().toAbsolutePath().normalize().toString();
        Errors errors = new Errors();
        String result = Env.check(keys, (Properties)environment.getVars(), (String)property, (String)dsl, (String)configFilePath, (Errors)errors);
        return !errors.hasErrors() ? result : defaultValue;
    }

    public static boolean checkProperty(JReleaserContext context, Collection<String> keys, String property, Boolean value, boolean defaultValue) {
        if (null != value) {
            return value;
        }
        Environment environment = context.getModel().getEnvironment();
        String dsl = context.getConfigurer().toString();
        String configFilePath = environment.getPropertiesFile().toAbsolutePath().normalize().toString();
        Errors errors = new Errors();
        String result = Env.check(keys, (Properties)environment.getVars(), (String)property, (String)dsl, (String)configFilePath, (Errors)errors);
        return !errors.hasErrors() ? Boolean.parseBoolean(result) : defaultValue;
    }

    public static <T extends Enum<T>> String checkProperty(JReleaserContext context, Collection<String> keys, String property, T value, T defaultValue) {
        if (null != value) {
            return value.name();
        }
        Environment environment = context.getModel().getEnvironment();
        String dsl = context.getConfigurer().toString();
        String configFilePath = environment.getPropertiesFile().toAbsolutePath().normalize().toString();
        Errors errors = new Errors();
        String result = Env.check(keys, (Properties)environment.getVars(), (String)property, (String)dsl, (String)configFilePath, (Errors)errors);
        return !errors.hasErrors() ? result : (null != defaultValue ? defaultValue.name() : null);
    }

    public static void validateOwner(OwnerAware self, OwnerAware other) {
        if (StringUtils.isBlank((String)self.getOwner())) {
            self.setOwner(other.getOwner());
        }
    }

    public static void validateContinueOnError(Packager self, Packager other) {
        if (!self.isContinueOnErrorSet()) {
            self.setContinueOnError(other.isContinueOnError());
        }
    }

    public static void validateCommitAuthor(CommitAuthorAware self, CommitAuthorAware other) {
        CommitAuthor author = new CommitAuthor();
        author.setName(self.getCommitAuthor().getName());
        author.setEmail(self.getCommitAuthor().getEmail());
        if (StringUtils.isBlank((String)author.getName())) {
            author.setName(other.getCommitAuthor().getName());
        }
        if (StringUtils.isBlank((String)author.getEmail())) {
            author.setEmail(other.getCommitAuthor().getEmail());
        }
        self.setCommitAuthor(author);
    }

    public static void validateTimeout(TimeoutAware self) {
        if (null == self.getConnectTimeout() || self.getConnectTimeout() <= 0 || self.getConnectTimeout() > 300) {
            self.setConnectTimeout(20);
        }
        if (null == self.getReadTimeout() || self.getReadTimeout() <= 0 || self.getReadTimeout() > 300) {
            self.setReadTimeout(60);
        }
    }

    public static void validateTap(JReleaserContext context, Distribution distribution, RepositoryTap tap, RepositoryTap parentTap, String property) {
        Validator.validateOwner(tap, parentTap);
        if (StringUtils.isBlank((String)tap.getCommitMessage()) && StringUtils.isNotBlank((String)parentTap.getCommitMessage())) {
            tap.setCommitMessage(parentTap.getCommitMessage());
        }
        if (StringUtils.isBlank((String)tap.getCommitMessage())) {
            tap.setCommitMessage("{{distributionName}} {{tagName}}");
        }
        if (StringUtils.isBlank((String)tap.getTagName()) && StringUtils.isNotBlank((String)parentTap.getTagName())) {
            tap.setTagName(parentTap.getTagName());
        }
        if (StringUtils.isBlank((String)tap.getBranch()) && StringUtils.isNotBlank((String)parentTap.getBranch())) {
            tap.setBranch(parentTap.getBranch());
        }
        if (StringUtils.isBlank((String)tap.getName()) && StringUtils.isNotBlank((String)parentTap.getName())) {
            tap.setName(parentTap.getName());
        }
        if (StringUtils.isBlank((String)tap.getUsername()) && StringUtils.isNotBlank((String)parentTap.getUsername())) {
            tap.setUsername(parentTap.getUsername());
        }
        if (StringUtils.isBlank((String)tap.getToken()) && StringUtils.isNotBlank((String)parentTap.getToken())) {
            tap.setToken(parentTap.getToken());
        }
        BaseReleaser<?, ?> service = context.getModel().getRelease().getReleaser();
        tap.setUsername(Validator.checkProperty(context, Env.toVar((String)(tap.getBasename() + "_" + service.getServiceName())) + "_USERNAME", "distributions." + distribution.getName() + "." + property + ".username", tap.getUsername(), service.getUsername()));
        tap.setToken(Validator.checkProperty(context, Env.toVar((String)(tap.getBasename() + "_" + service.getServiceName())) + "_TOKEN", "distributions." + distribution.getName() + "." + property + ".token", tap.getToken(), service.getToken()));
        tap.setBranch(Validator.checkProperty(context, Env.toVar((String)(tap.getBasename() + "_" + service.getServiceName())) + "_BRANCH", "distributions." + distribution.getName() + "." + property + ".branch", tap.getBranch(), "HEAD"));
    }

    public static void validateGlobs(JReleaserContext context, Collection<Glob> globs, String property, Errors errors) {
        int i = 0;
        for (Glob glob : globs) {
            if (!StringUtils.isBlank((String)glob.getPattern())) continue;
            errors.configuration(RB.$((String)"validation_must_define_pattern", (Object[])new Object[]{property + "[" + i + "]"}));
        }
    }

    public static void validateFileSet(JReleaserContext context, JReleaserContext.Mode mode, Assembler assembler, FileSet fileSet, int index, Errors errors) {
        if (mode.validateStandalone() && StringUtils.isBlank((String)fileSet.getInput())) {
            errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{assembler.getType() + "." + assembler.getName() + ".fileSet[" + index + "].input"}));
        }
    }

    public static void validateScreenshots(JReleaserContext context, JReleaserContext.Mode mode, List<Screenshot> screenshots, Errors errors, String base) {
        if (screenshots.size() == 1) {
            screenshots.get(0).setPrimary(true);
        }
        if (screenshots.stream().mapToInt(s -> s.isPrimary() ? 1 : 0).sum() > 1) {
            errors.configuration(RB.$((String)"validation_multiple_primary_screenshots", (Object[])new Object[]{base}));
        }
        for (int i = 0; i < screenshots.size(); ++i) {
            Screenshot screenshot = screenshots.get(i);
            if (StringUtils.isBlank((String)screenshot.getUrl())) {
                errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{base + ".screenshots[" + i + "].url"}));
            }
            if (screenshot.getType() == Screenshot.Type.THUMBNAIL) {
                if (null == screenshot.getWidth()) {
                    errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{base + ".screenshots[" + i + "].width"}));
                }
                if (null != screenshot.getHeight()) continue;
                errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{base + ".screenshots[" + i + "].height"}));
                continue;
            }
            if (null == screenshot.getWidth() && null != screenshot.getHeight()) {
                errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{base + ".screenshots[" + i + "].width"}));
                continue;
            }
            if (null == screenshot.getWidth() || null != screenshot.getHeight()) continue;
            errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{base + ".screenshots[" + i + "].height"}));
        }
    }

    public static void validateIcons(JReleaserContext context, JReleaserContext.Mode mode, List<Icon> icons, Errors errors, String base) {
        Validator.validateIcons(context, mode, icons, errors, base, true);
    }

    public static void validateIcons(JReleaserContext context, JReleaserContext.Mode mode, List<Icon> icons, Errors errors, String base, boolean validatePrimary) {
        if (validatePrimary) {
            if (icons.size() == 1) {
                icons.get(0).setPrimary(true);
            }
            if (icons.stream().mapToInt(s -> s.isPrimary() ? 1 : 0).sum() > 1) {
                errors.configuration(RB.$((String)"validation_multiple_primary_icons", (Object[])new Object[]{base}));
            }
        }
        for (int i = 0; i < icons.size(); ++i) {
            Icon icon = icons.get(i);
            if (StringUtils.isBlank((String)icon.getUrl())) {
                errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{base + ".icons[" + i + "].url"}));
            }
            if (null == icon.getWidth()) {
                errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{base + ".icons[" + i + "].width"}));
            }
            if (null != icon.getHeight()) continue;
            errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{base + ".icons[" + i + "].height"}));
        }
    }
}

