/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Archive;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.JavaArchiveAssembler;
import org.jreleaser.model.internal.common.FileSet;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class JavaArchiveAssemblerValidator
extends Validator {
    public static void validateJavaArchive(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, JavaArchiveAssembler> archive = context.getModel().getAssemble().getJavaArchive();
        if (!archive.isEmpty()) {
            context.getLogger().debug("assemble.java-archive");
        }
        for (Map.Entry<String, JavaArchiveAssembler> e : archive.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateAssembly()) continue;
            JavaArchiveAssemblerValidator.validateJavaArchive(context, mode, e.getValue(), errors);
        }
    }

    private static void validateJavaArchive(JReleaserContext context, JReleaserContext.Mode mode, JavaArchiveAssembler archive, Errors errors) {
        context.getLogger().debug("assemble.java-archive.{}", new Object[]{archive.getName()});
        if (!archive.isActiveSet()) {
            archive.setActive(Active.NEVER);
        }
        if (!archive.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((String)archive.getName())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"java-archive.name"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            archive.disable();
            return;
        }
        if (null == archive.getStereotype()) {
            archive.setStereotype(context.getModel().getProject().getStereotype());
        }
        if (StringUtils.isBlank((String)archive.getArchiveName())) {
            archive.setArchiveName("{{distributionName}}-{{projectVersion}}");
        }
        if (StringUtils.isBlank((String)archive.getExecutable().getName())) {
            archive.getExecutable().setName(archive.getName());
        }
        if (StringUtils.isBlank((String)archive.getExecutable().getWindowsExtension())) {
            archive.getExecutable().setWindowsExtension("bat");
        }
        if (archive.getFormats().isEmpty()) {
            archive.addFormat(Archive.Format.ZIP);
        }
        if (archive.getJars().isEmpty() && StringUtils.isBlank((String)archive.getMainJar().getPath())) {
            errors.configuration(RB.$((String)"validation_java_archive_empty_jars", (Object[])new Object[]{archive.getName()}));
        } else {
            JavaArchiveAssemblerValidator.validateGlobs(context, archive.getJars(), "java-archive." + archive.getName() + ".jars", errors);
        }
        JavaArchiveAssemblerValidator.validateGlobs(context, archive.getFiles(), "java-archive." + archive.getName() + ".files", errors);
        int i = 0;
        for (FileSet fileSet : archive.getFileSets()) {
            JavaArchiveAssemblerValidator.validateFileSet(context, mode, archive, fileSet, i++, errors);
        }
        String defaultTemplateDirectory = "src/jreleaser/assemblers/" + archive.getName() + "/" + archive.getType();
        if (StringUtils.isNotBlank((String)archive.getTemplateDirectory()) && !defaultTemplateDirectory.equals(archive.getTemplateDirectory().trim()) && !Files.exists(context.getBasedir().resolve(archive.getTemplateDirectory().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{archive.getType() + "." + archive.getName() + ".template", archive.getTemplateDirectory()}));
        }
        if (StringUtils.isBlank((String)archive.getTemplateDirectory())) {
            archive.setTemplateDirectory(defaultTemplateDirectory);
        }
        context.getLogger().debug("assemble.java-archive.{}.java", new Object[]{archive.getName()});
        Project project = context.getModel().getProject();
        boolean mainJarIsSet = StringUtils.isNotBlank((String)archive.getMainJar().getPath());
        if (!mainJarIsSet) {
            if (StringUtils.isBlank((String)archive.getJava().getMainModule())) {
                archive.getJava().setMainModule(project.getJava().getMainModule());
            }
            if (StringUtils.isBlank((String)archive.getJava().getMainClass())) {
                archive.getJava().setMainClass(project.getJava().getMainClass());
            }
        }
        boolean mainClassIsSet = StringUtils.isNotBlank((String)archive.getJava().getMainClass());
        if (!mainJarIsSet && !mainClassIsSet) {
            errors.configuration(RB.$((String)"validation_java_archive_main_jar_or_class_missing", (Object[])new Object[]{archive.getName(), archive.getName()}));
        }
    }
}

