/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.checksum;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.Algorithm;

public final class Checksum
extends AbstractModelObject<Checksum>
implements Domain {
    private final Set<Algorithm> algorithms = new LinkedHashSet<Algorithm>();
    private Boolean individual;
    private String name;
    private Boolean files;
    private final org.jreleaser.model.api.checksum.Checksum immutable = new org.jreleaser.model.api.checksum.Checksum(){

        public String getName() {
            return Checksum.this.name;
        }

        public boolean isIndividual() {
            return Checksum.this.isIndividual();
        }

        public Set<Algorithm> getAlgorithms() {
            return Collections.unmodifiableSet(Checksum.this.algorithms);
        }

        public boolean isFiles() {
            return Checksum.this.isFiles();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Checksum.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.checksum.Checksum asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Checksum source) {
        this.name = this.merge(this.name, source.name);
        this.individual = this.merge(this.individual, source.individual);
        this.files = this.merge(this.files, source.files);
        this.setAlgorithms(this.merge(this.algorithms, source.algorithms));
    }

    public String getResolvedName(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        context.getModel().getRelease().getReleaser().fillProps(props, context.getModel());
        return Templates.resolveTemplate((String)this.name, props);
    }

    public String getResolvedName(JReleaserContext context, Algorithm algorithm) {
        String resolvedName = context.getModel().getChecksum().getResolvedName(context);
        int pos = resolvedName.lastIndexOf(".");
        resolvedName = pos != -1 ? resolvedName.substring(0, pos) + "_" + algorithm.formatted() + resolvedName.substring(pos) : resolvedName + "." + algorithm.formatted();
        return resolvedName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isIndividual() {
        return this.individual != null && this.individual != false;
    }

    public void setIndividual(Boolean individual) {
        this.individual = individual;
    }

    public boolean isIndividualSet() {
        return this.individual != null;
    }

    public Set<Algorithm> getAlgorithms() {
        return this.algorithms;
    }

    public void setAlgorithms(Set<Algorithm> algorithms) {
        this.algorithms.clear();
        this.algorithms.addAll(algorithms);
    }

    public boolean isFiles() {
        return this.files == null || this.files != false;
    }

    public void setFiles(Boolean files) {
        this.files = files;
    }

    public boolean isFilesSet() {
        return this.files != null;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("name", this.name);
        props.put("individual", this.isIndividual());
        props.put("algorithms", this.algorithms);
        props.put("files", this.isFiles());
        return props;
    }
}

