/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.signing;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.Signing;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.signing.Signing;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public abstract class SigningValidator
extends Validator {
    public static void validateSigning(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        if (!mode.validateConfig()) {
            errors = new Errors();
        }
        context.getLogger().debug("signing");
        Signing signing = context.getModel().getSigning();
        if (!signing.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!signing.isArmoredSet()) {
            signing.setArmored(true);
        }
        boolean cosign = signing.resolveMode() == Signing.Mode.COSIGN;
        signing.setPassphrase(SigningValidator.checkProperty(context, cosign ? "COSIGN_PASSWORD" : "GPG_PASSPHRASE", "signing.passphrase", signing.getPassphrase(), errors, context.isDryrun()));
        if (signing.resolveMode() == Signing.Mode.COMMAND) {
            signing.getCommand().setExecutable(SigningValidator.checkProperty(context, "GPG_EXECUTABLE", "signing.command.executable", signing.getCommand().getExecutable(), "gpg" + (PlatformUtils.isWindows() ? ".exe" : "")));
            signing.getCommand().setHomeDir(SigningValidator.checkProperty(context, "GPG_HOMEDIR", "signing.command.homeDir", signing.getCommand().getHomeDir(), ""));
            signing.getCommand().setKeyName(SigningValidator.checkProperty(context, "GPG_KEYNAME", "signing.command.keyName", signing.getCommand().getKeyName(), ""));
            signing.getCommand().setPublicKeyring(SigningValidator.checkProperty(context, "GPG_PUBLIC_KEYRING", "signing.command.publicKeyRing", signing.getCommand().getPublicKeyring(), ""));
        } else if (signing.resolveMode() == Signing.Mode.COSIGN) {
            if (StringUtils.isBlank((String)signing.getCosign().getVersion())) {
                errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{"signing.cosign.version"}));
            }
            signing.getCosign().setPrivateKeyFile(SigningValidator.checkProperty(context, "COSIGN_PRIVATE_KEY", "signing.cosign.privateKeyFile", signing.getCosign().getPrivateKeyFile(), ""));
            signing.getCosign().setPublicKeyFile(SigningValidator.checkProperty(context, "COSIGN_PUBLIC_KEY", "signing.cosign.publicKeyFile", signing.getCosign().getPublicKeyFile(), ""));
        } else {
            signing.setPublicKey(SigningValidator.checkProperty(context, "GPG_PUBLIC_KEY", "signing.publicKey", signing.getPublicKey(), errors, context.isDryrun()));
            signing.setSecretKey(SigningValidator.checkProperty(context, "GPG_SECRET_KEY", "signing.secretKey", signing.getSecretKey(), errors, context.isDryrun()));
        }
    }
}

