/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.deploy;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.deploy.Deploy;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.deploy.maven.MavenDeployersValidator;
import org.jreleaser.util.Errors;

public abstract class DeployValidator
extends Validator {
    public static void validateDeploy(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("deploy");
        Deploy deploy = context.getModel().getDeploy();
        MavenDeployersValidator.validateMavenDeployers(context, mode, errors);
        if (mode.validateConfig()) {
            boolean activeSet = deploy.isActiveSet();
            deploy.resolveEnabled(context.getModel().getProject());
            if (deploy.isEnabled()) {
                boolean enabled = deploy.getMaven().isEnabled();
                if (!activeSet && !enabled) {
                    context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                    deploy.disable();
                }
            }
        }
    }
}

