/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.upload;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.upload.Uploader;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;

public abstract class AbstractUploader<A extends org.jreleaser.model.api.upload.Uploader, S extends AbstractUploader<A, S>>
extends AbstractModelObject<S>
implements Uploader<A>,
ExtraProperties {
    @JsonIgnore
    protected final String type;
    protected final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    @JsonIgnore
    protected String name;
    @JsonIgnore
    protected boolean enabled;
    protected Active active;
    protected int connectTimeout;
    protected int readTimeout;
    protected Boolean artifacts;
    protected Boolean files;
    protected Boolean signatures;
    protected Boolean checksums;

    protected AbstractUploader(String type) {
        this.type = type;
    }

    @Override
    public void merge(S source) {
        this.active = this.merge(this.active, ((AbstractUploader)source).active);
        this.enabled = this.merge(this.enabled, ((AbstractUploader)source).enabled);
        this.name = this.merge(this.name, ((AbstractUploader)source).name);
        this.connectTimeout = this.merge(this.connectTimeout, ((AbstractUploader)source).connectTimeout);
        this.readTimeout = this.merge(this.readTimeout, ((AbstractUploader)source).readTimeout);
        this.artifacts = this.merge(this.artifacts, ((AbstractUploader)source).artifacts);
        this.files = this.merge(this.files, ((AbstractUploader)source).files);
        this.signatures = this.merge(this.signatures, ((AbstractUploader)source).signatures);
        this.checksums = this.merge(this.checksums, ((AbstractUploader)source).checksums);
        this.setExtraProperties(this.merge(this.extraProperties, ((AbstractUploader)source).extraProperties));
    }

    @Override
    public String getPrefix() {
        return this.type;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.active = Active.NEVER;
        }
        this.enabled = this.active.check((Active.Releaseable)project);
        if (project.isSnapshot() && !this.isSnapshotSupported()) {
            this.enabled = false;
        }
        return this.enabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of((String)str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    @Override
    public boolean isSnapshotSupported() {
        return true;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public boolean isArtifacts() {
        return this.artifacts == null || this.artifacts != false;
    }

    @Override
    public void setArtifacts(Boolean artifacts) {
        this.artifacts = artifacts;
    }

    @Override
    public boolean isArtifactsSet() {
        return this.artifacts != null;
    }

    @Override
    public boolean isFiles() {
        return this.files == null || this.files != false;
    }

    @Override
    public void setFiles(Boolean files) {
        this.files = files;
    }

    @Override
    public boolean isFilesSet() {
        return this.files != null;
    }

    @Override
    public boolean isSignatures() {
        return this.signatures == null || this.signatures != false;
    }

    @Override
    public void setSignatures(Boolean signatures) {
        this.signatures = signatures;
    }

    @Override
    public boolean isSignaturesSet() {
        return this.signatures != null;
    }

    @Override
    public boolean isChecksumsSet() {
        return this.checksums != null;
    }

    @Override
    public boolean isChecksums() {
        return this.checksums == null || this.checksums != false;
    }

    @Override
    public void setChecksums(Boolean checksums) {
        this.checksums = checksums;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", this.active);
        props.put("connectTimeout", this.connectTimeout);
        props.put("readTimeout", this.readTimeout);
        props.put("artifacts", this.isArtifacts());
        props.put("files", this.isFiles());
        props.put("signatures", this.isSignatures());
        props.put("checksums", this.isChecksums());
        this.asMap(full, props);
        props.put("extraProperties", this.getResolvedExtraProperties());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getName(), props);
        return map;
    }

    protected abstract void asMap(boolean var1, Map<String, Object> var2);

    @Override
    public List<String> resolveSkipKeys() {
        String skipUpload = "skipUpload";
        String skipUploadByType = skipUpload + StringUtils.capitalize((String)this.type);
        String skipUploadByName = skipUploadByType + StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.name);
        return CollectionUtils.listOf((Object[])new String[]{skipUpload, skipUploadByType, skipUploadByName});
    }

    @Override
    public Map<String, Object> artifactProps(JReleaserContext context, Artifact artifact) {
        return this.artifactProps(context.fullProps(), artifact);
    }

    @Override
    public Map<String, Object> artifactProps(Map<String, Object> props, Artifact artifact) {
        props.put("uploaderName", this.getName());
        Artifacts.artifactProps(artifact, props);
        LinkedHashSet<String> keys = new LinkedHashSet<String>(props.keySet());
        keys.stream().filter(k -> k.contains("skip") || k.contains("Skip")).forEach(props::remove);
        return props;
    }
}

