/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.jreleaser.util.StringUtils;

public enum FileType {
    ASC("asc"),
    DEB("deb"),
    DMG("dmg"),
    EXE("exe"),
    JAR("jar"),
    MSI("msi"),
    NUGET("nuget"),
    PKG("pkg"),
    RPM("rpm"),
    SIG("sig"),
    TAR("tar", true),
    TAR_BZ2("tar.bz2", true),
    TAR_GZ("tar.gz", true),
    TAR_XZ("tar.xz", true),
    TBZ2("tbz2", true),
    TGZ("tgz", true),
    TXZ("txz", true),
    ZIP("zip", true);

    private final String type;
    private final boolean archive;

    private FileType(String type) {
        this(type, false);
    }

    private FileType(String type, boolean archive) {
        this.type = type;
        this.archive = archive;
    }

    public boolean archive() {
        return this.archive;
    }

    public String type() {
        return this.type;
    }

    public String extension() {
        return "." + this.type;
    }

    public String toString() {
        return this.type();
    }

    public static FileType of(String str) {
        if (StringUtils.isBlank(str)) {
            return null;
        }
        return FileType.valueOf(str.toUpperCase(Locale.ENGLISH).trim().replace(".", "_"));
    }

    public static Set<String> getSupportedTypes() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (FileType value : FileType.values()) {
            set.add(value.type());
        }
        return set;
    }

    public static Set<String> getSupportedExtensions() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (FileType value : FileType.values()) {
            set.add(value.extension());
        }
        return set;
    }

    public static Optional<FileType> getFileType(Path path) {
        if (null != path) {
            return FileType.getFileType(path.getFileName().toString());
        }
        return Optional.empty();
    }

    public static Optional<FileType> getFileType(String path) {
        if (StringUtils.isBlank(path)) {
            return Optional.empty();
        }
        for (FileType value : FileType.values()) {
            if (!path.endsWith(value.extension())) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static String getType(Path path) {
        if (null != path) {
            return FileType.getType(path.getFileName().toString());
        }
        return "";
    }

    public static String getType(String path) {
        if (StringUtils.isBlank(path)) {
            return "";
        }
        for (FileType value : FileType.values()) {
            if (!path.endsWith(value.extension())) continue;
            return value.type();
        }
        return "";
    }

    public static String getExtension(Path path) {
        if (null != path) {
            return FileType.getExtension(path.getFileName().toString());
        }
        return "";
    }

    public static String getExtension(String path) {
        if (StringUtils.isBlank(path)) {
            return "";
        }
        for (FileType value : FileType.values()) {
            if (!path.endsWith(value.extension())) continue;
            return value.extension();
        }
        return "";
    }
}

