/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.ftp;

import java.io.IOException;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Ftp;
import org.jreleaser.model.internal.common.TimeoutAware;
import org.jreleaser.model.internal.download.FtpDownloader;
import org.jreleaser.model.internal.upload.FtpUploader;
import org.jreleaser.model.spi.download.DownloadException;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.util.StringUtils;

public class FtpUtils {
    private FtpUtils() {
    }

    public static FTPClient open(JReleaserContext context, FtpDownloader downloader) throws DownloadException {
        try {
            return FtpUtils.ftpClient(context, downloader);
        }
        catch (IOException e) {
            throw new DownloadException(RB.$((String)"ERROR_unexpected_download_from", (Object[])new Object[]{downloader.getName()}), (Throwable)e);
        }
    }

    public static FTPClient open(JReleaserContext context, FtpUploader uploader) throws UploadException {
        if (context.isDryrun()) {
            return null;
        }
        try {
            return FtpUtils.ftpClient(context, uploader);
        }
        catch (IOException e) {
            throw new UploadException(RB.$((String)"ERROR_unexpected_upload_to", (Object[])new Object[]{uploader.getName()}), (Throwable)e);
        }
    }

    private static <T extends Ftp & TimeoutAware> FTPClient ftpClient(JReleaserContext context, T ftp) throws IOException {
        FTPClient client = new FTPClient();
        client.setConnectTimeout(((TimeoutAware)ftp).getConnectTimeout() * 1000);
        client.setSoTimeout(((TimeoutAware)ftp).getReadTimeout() * 1000);
        client.addProtocolCommandListener((ProtocolCommandListener)new FtpCommandListener(context));
        client.connect(ftp.getResolvedHost(), ftp.getResolvedPort().intValue());
        int reply = client.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            client.disconnect();
            throw new IOException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]));
        }
        String username = ftp.getResolvedUsername();
        if (StringUtils.isBlank((String)username)) {
            username = "anonymous";
        }
        client.login(username, ftp.getResolvedPassword());
        reply = client.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            client.disconnect();
            throw new IOException(RB.$((String)"ERROR_login", (Object[])new Object[0]));
        }
        return client;
    }

    public static void close(FtpUploader uploader, FTPClient ftp) throws UploadException {
        try {
            if (null != ftp) {
                ftp.disconnect();
            }
        }
        catch (IOException e) {
            throw new UploadException(RB.$((String)"ERROR_disconnect", (Object[])new Object[]{uploader.getName()}), (Throwable)e);
        }
    }

    public static void close(FtpDownloader downloader, FTPClient ftp) throws DownloadException {
        try {
            ftp.disconnect();
        }
        catch (IOException e) {
            throw new DownloadException(RB.$((String)"ERROR_disconnect", (Object[])new Object[]{downloader.getName()}), (Throwable)e);
        }
    }

    private static class FtpCommandListener
    implements ProtocolCommandListener {
        private static final String LOGIN = "LOGIN";
        private final JReleaserContext context;

        public FtpCommandListener(JReleaserContext context) {
            this.context = context;
        }

        public void protocolCommandSent(ProtocolCommandEvent event) {
            StringBuilder msg = new StringBuilder("> ");
            String cmd = event.getCommand();
            if ("PASS".equalsIgnoreCase(cmd) || "USER".equalsIgnoreCase(cmd)) {
                msg.append(cmd).append(" *******");
            } else if (LOGIN.equalsIgnoreCase(cmd)) {
                String m = event.getMessage();
                m = m.substring(0, msg.indexOf(LOGIN) + LOGIN.length());
                msg.append(m).append(" *******");
            } else {
                msg.append(event.getMessage().trim());
            }
            this.context.getLogger().debug(msg.toString());
        }

        public void protocolReplyReceived(ProtocolCommandEvent event) {
            this.context.getLogger().debug("< " + event.getMessage().trim());
            if (FTPReply.isNegativeTransient((int)event.getReplyCode()) || FTPReply.isNegativePermanent((int)event.getReplyCode())) {
                throw new IllegalStateException(event.getMessage());
            }
        }
    }
}

