/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.LintScanner;
import com.github.sbaudoin.yamllint.LintStreamReader;
import com.github.sbaudoin.yamllint.Parser;
import com.github.sbaudoin.yamllint.rules.LineRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.scanner.ScannerException;
import org.yaml.snakeyaml.tokens.BlockMappingStartToken;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.Token;
import org.yaml.snakeyaml.tokens.ValueToken;

public class LineLength
extends LineRule {
    public static final String OPTION_MAX = "max";
    public static final String OPTION_ALLOW_NON_BREAKABLE_WORDS = "allow-non-breakable-words";
    public static final String OPTION_ALLOW_NON_BREAKABLE_INLINE_MAPPINGS = "allow-non-breakable-inline-mappings";

    public LineLength() {
        this.registerOption(OPTION_MAX, 80);
        this.registerOption(OPTION_ALLOW_NON_BREAKABLE_WORDS, true);
        this.registerOption(OPTION_ALLOW_NON_BREAKABLE_INLINE_MAPPINGS, false);
    }

    @Override
    public List<LintProblem> check(Map<Object, Object> conf, Parser.Line line) {
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (line.getEnd() - line.getStart() > (Integer)conf.get(OPTION_MAX)) {
            boolean anbw = (Boolean)conf.get(OPTION_ALLOW_NON_BREAKABLE_WORDS);
            conf.put(OPTION_ALLOW_NON_BREAKABLE_WORDS, anbw || (Boolean)conf.get(OPTION_ALLOW_NON_BREAKABLE_INLINE_MAPPINGS) != false);
            if (((Boolean)conf.get(OPTION_ALLOW_NON_BREAKABLE_WORDS)).booleanValue()) {
                int start;
                for (start = line.getStart(); start < line.getEnd() && line.getBuffer().charAt(start) == ' '; ++start) {
                }
                if (start != line.getEnd()) {
                    if (line.getBuffer().charAt(start) == '#') {
                        while (line.getBuffer().charAt(start) == '#') {
                            ++start;
                        }
                        ++start;
                    } else if (line.getBuffer().charAt(start) == '-') {
                        start += 2;
                    }
                    if (line.getBuffer().substring(start, line.getEnd()).indexOf(32) == -1) {
                        return problems;
                    }
                    if (((Boolean)conf.get(OPTION_ALLOW_NON_BREAKABLE_INLINE_MAPPINGS)).booleanValue() && this.checkInlineMapping(line)) {
                        return problems;
                    }
                }
            }
            problems.add(new LintProblem(line.getLineNo(), (Integer)conf.get(OPTION_MAX) + 1, "line too long (" + (line.getEnd() - line.getStart()) + " > " + conf.get(OPTION_MAX) + " characters)"));
        }
        return problems;
    }

    private boolean checkInlineMapping(Parser.Line line) {
        LintScanner loader = new LintScanner(new LintStreamReader(line.getContent()));
        try {
            while (loader.peekToken() != null) {
                if (!(loader.getToken() instanceof BlockMappingStartToken)) continue;
                while (loader.peekToken() != null) {
                    Token t;
                    if (!(loader.getToken() instanceof ValueToken) || !((t = loader.getToken()) instanceof ScalarToken)) continue;
                    return line.getContent().indexOf(32, t.getStartMark().getColumn()) < 0;
                }
            }
        }
        catch (ScannerException scannerException) {
            // empty catch block
        }
        return false;
    }
}

