/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.distribution;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.packagers.Packager;
import org.jreleaser.model.spi.packagers.PackagerProcessor;
import org.jreleaser.model.spi.packagers.PackagerProcessorFactory;

public class PackagerProcessors {
    public static <T extends Packager> PackagerProcessor<T> findProcessor(JReleaserContext context, T packager) {
        Map<String, PackagerProcessor> processors = StreamSupport.stream(ServiceLoader.load(PackagerProcessorFactory.class, PackagerProcessors.class.getClassLoader()).spliterator(), false).collect(Collectors.toMap(PackagerProcessorFactory::getName, factory -> factory.getPackagerNameProcessor(context)));
        if (processors.containsKey(packager.getType())) {
            PackagerProcessor packagerProcessor = processors.get(packager.getType());
            packagerProcessor.setPackager(packager);
            return packagerProcessor;
        }
        throw new JReleaserException(RB.$((String)"ERROR_unsupported_packager", (Object[])new Object[]{packager.getType()}));
    }
}

