/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.mastodon;

import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.jackson.JacksonEncoder;
import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.mastodon.MastodonException;
import org.jreleaser.sdk.mastodon.api.MastodonAPI;
import org.jreleaser.sdk.mastodon.api.Status;
import org.jreleaser.util.StringUtils;

public class MastodonSdk {
    private static final String API_V1 = "/api/v1";
    private final JReleaserLogger logger;
    private final MastodonAPI api;
    private final boolean dryrun;

    private MastodonSdk(JReleaserLogger logger, String host, String accessToken, int connectTimeout, int readTimeout, boolean dryrun) {
        Objects.requireNonNull(logger, "'logger' must not be null");
        StringUtils.requireNonBlank((String)host, (String)"'host' must not be blank");
        StringUtils.requireNonBlank((String)accessToken, (String)"'accessToken' must not be blank");
        if (!host.endsWith(API_V1)) {
            if (host.endsWith("/")) {
                host = host.substring(0, host.length() - 1);
            }
            host = host + API_V1;
        }
        this.logger = logger;
        this.dryrun = dryrun;
        this.api = (MastodonAPI)ClientUtils.builder((JReleaserLogger)logger, (int)connectTimeout, (int)readTimeout).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder())).requestInterceptor(template -> template.header("Authorization", new String[]{String.format("Bearer %s", accessToken)})).target(MastodonAPI.class, host);
        this.logger.debug(RB.$((String)"workflow.dryrun", (Object[])new Object[0]), new Object[]{dryrun});
    }

    public void status(String status) throws MastodonException {
        Status payload = Status.of(status);
        this.logger.debug("mastodon.status: " + payload);
        this.wrap(() -> this.api.status(payload));
    }

    private void wrap(Runnable runnable) throws MastodonException {
        try {
            if (!this.dryrun) {
                runnable.run();
            }
        }
        catch (RestAPIException e) {
            this.logger.trace((Throwable)e);
            throw new MastodonException(RB.$((String)"sdk.operation.failed", (Object[])new Object[]{"Mastodon"}), e);
        }
    }

    public static Builder builder(JReleaserLogger logger) {
        return new Builder(logger);
    }

    static class Builder {
        private final JReleaserLogger logger;
        private boolean dryrun;
        private String accessToken;
        private String host;
        private int connectTimeout = 20;
        private int readTimeout = 60;

        private Builder(JReleaserLogger logger) {
            this.logger = Objects.requireNonNull(logger, "'logger' must not be null");
        }

        public Builder dryrun(boolean dryrun) {
            this.dryrun = dryrun;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.accessToken = StringUtils.requireNonBlank((String)accessToken, (String)"'accessToken' must not be blank").trim();
            return this;
        }

        public Builder host(String host) {
            this.host = StringUtils.requireNonBlank((String)host, (String)"'host' must not be blank").trim();
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        private void validate() {
            StringUtils.requireNonBlank((String)this.host, (String)"'host' must not be blank");
            StringUtils.requireNonBlank((String)this.accessToken, (String)"'accessToken' must not be blank");
        }

        public MastodonSdk build() {
            this.validate();
            return new MastodonSdk(this.logger, this.host, this.accessToken, this.connectTimeout, this.readTimeout, this.dryrun);
        }
    }
}

