/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.mastodon;

import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.sdk.mastodon.MastodonException;
import org.jreleaser.sdk.mastodon.MastodonSdk;

public class MastodonAnnouncer
implements Announcer<org.jreleaser.model.api.announce.MastodonAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.MastodonAnnouncer mastodon;

    public MastodonAnnouncer(JReleaserContext context) {
        this.context = context;
        this.mastodon = context.getModel().getAnnounce().getMastodon();
    }

    public org.jreleaser.model.api.announce.MastodonAnnouncer getAnnouncer() {
        return this.mastodon.asImmutable();
    }

    public String getName() {
        return "mastodon";
    }

    public boolean isEnabled() {
        return this.mastodon.isEnabled();
    }

    public void announce() throws AnnounceException {
        String status = this.mastodon.getResolvedStatus(this.context);
        this.context.getLogger().debug("status: {}", new Object[]{status});
        try {
            MastodonSdk sdk = MastodonSdk.builder(this.context.getLogger()).host(this.mastodon.getHost()).accessToken(this.mastodon.getResolvedAccessToken()).connectTimeout(this.mastodon.getConnectTimeout()).readTimeout(this.mastodon.getReadTimeout()).dryrun(this.context.isDryrun()).build();
            sdk.status(status);
        }
        catch (MastodonException e) {
            throw new AnnounceException((Throwable)e);
        }
    }
}

