/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.git;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Changelog;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.release.Changelog;
import org.jreleaser.model.internal.util.VersionUtils;
import org.jreleaser.model.spi.release.User;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.git.ChangelogProvider;
import org.jreleaser.sdk.git.GitSdk;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.ComparatorUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.Version;

public class ChangelogGenerator {
    private static final String UNCATEGORIZED = "<<UNCATEGORIZED>>";
    private static final String REGEX_PREFIX = "regex:";

    protected String createChangelog(JReleaserContext context) throws IOException {
        BaseReleaser releaser = context.getModel().getRelease().getReleaser();
        Changelog changelog = releaser.getChangelog();
        String separator = System.lineSeparator();
        if ("gitlab".equals(releaser.getServiceName())) {
            separator = separator + System.lineSeparator();
        }
        String commitSeparator = separator;
        try {
            Git git = GitSdk.of(context).open();
            context.getLogger().debug(RB.$((String)"changelog.generator.resolve.commits", (Object[])new Object[0]));
            Iterable<RevCommit> commits = this.resolveCommits(git, context);
            Comparator<RevCommit> revCommitComparator = Comparator.comparing(RevCommit::getCommitTime).reversed();
            if (changelog.getSort() == Changelog.Sort.ASC) {
                revCommitComparator = Comparator.comparing(RevCommit::getCommitTime);
            }
            context.getLogger().debug(RB.$((String)"changelog.generator.sort.commits", (Object[])new Object[0]), new Object[]{changelog.getSort()});
            List<RevCommit> commitList = StreamSupport.stream(commits.spliterator(), false).filter(c -> !changelog.isSkipMergeCommits() || c.getParentCount() <= 1).collect(Collectors.toList());
            if (context.getModel().getRelease().getReleaser().getIssues().isEnabled()) {
                String rawContent = commitList.stream().map(RevCommit::getFullMessage).collect(Collectors.joining(System.lineSeparator()));
                Set<Integer> issues = ChangelogProvider.extractIssues(context, rawContent);
                ChangelogProvider.storeIssues(context, issues);
            }
            if (changelog.resolveFormatted(context.getModel().getProject())) {
                return this.formatChangelog(context, changelog, commitList, revCommitComparator, commitSeparator);
            }
            String commitsUrl = releaser.getResolvedCommitUrl(context.getModel());
            return "## Changelog" + System.lineSeparator() + System.lineSeparator() + commitList.stream().sorted(revCommitComparator).map(commit -> this.formatCommit((RevCommit)commit, commitsUrl, changelog, commitSeparator)).collect(Collectors.joining(commitSeparator));
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
    }

    protected String formatCommit(RevCommit commit, String commitsUrl, Changelog changelog, String commitSeparator) {
        String commitHash = commit.getId().name();
        String abbreviation = commit.getId().abbreviate(7).name();
        String[] input = commit.getFullMessage().trim().split(System.lineSeparator());
        ArrayList<String> lines = new ArrayList<String>();
        if (changelog.isLinks()) {
            lines.add("[" + abbreviation + "](" + commitsUrl + "/" + commitHash + ") " + input[0].trim());
        } else {
            lines.add(abbreviation + " " + input[0].trim());
        }
        return String.join((CharSequence)commitSeparator, lines);
    }

    private Version version(JReleaserContext context, Ref tag, Pattern versionPattern) {
        return this.version(context, tag, versionPattern, false);
    }

    private Version version(JReleaserContext context, Ref tag, Pattern versionPattern, boolean strict) {
        return VersionUtils.version((JReleaserContext)context, (String)GitSdk.extractTagName(tag), (Pattern)versionPattern, (boolean)strict);
    }

    private Version defaultVersion(JReleaserContext context) {
        return VersionUtils.defaultVersion((JReleaserContext)context);
    }

    public Tags resolveTags(Git git, JReleaserContext context) throws GitAPIException {
        Project.Snapshot snapshot;
        String effectiveLabel;
        GitSdk shallowTest = GitSdk.of(context);
        if (shallowTest.isShallow()) {
            context.getLogger().warn(RB.$((String)"changelog.shallow.warning", (Object[])new Object[0]));
        }
        List tags = git.tagList().call();
        BaseReleaser releaser = context.getModel().getRelease().getReleaser();
        String effectiveTagName = releaser.getEffectiveTagName(context.getModel());
        String tagName = releaser.getConfiguredTagName();
        String tagPattern = tagName.replaceAll("\\{\\{.*}}", "\\.\\*");
        Pattern versionPattern = VersionUtils.resolveVersionPattern((JReleaserContext)context);
        VersionUtils.clearUnparseableTags();
        tags.sort((tag1, tag2) -> {
            Version v1 = this.version(context, (Ref)tag1, versionPattern);
            Version v2 = this.version(context, (Ref)tag2, versionPattern);
            return v2.compareTo((Object)v1);
        });
        context.getLogger().debug(RB.$((String)"changelog.generator.lookup.tag", (Object[])new Object[0]), new Object[]{effectiveTagName});
        Optional<Object> tag = tags.stream().filter(ref -> GitSdk.extractTagName(ref).equals(effectiveTagName)).findFirst();
        Optional<Object> previousTag = Optional.empty();
        String previousTagName = releaser.getConfiguredPreviousTagName();
        if (StringUtils.isNotBlank((String)previousTagName)) {
            context.getLogger().debug(RB.$((String)"changelog.generator.lookup.previous.tag", (Object[])new Object[0]), new Object[]{previousTagName});
            previousTag = tags.stream().filter(ref -> GitSdk.extractTagName(ref).equals(previousTagName)).findFirst();
        }
        Version currentVersion = context.getModel().getProject().version();
        Version defaultVersion = this.defaultVersion(context);
        if (context.getModel().getProject().isSnapshot() && (effectiveLabel = (snapshot = context.getModel().getProject().getSnapshot()).getEffectiveLabel()).equals(effectiveTagName)) {
            if (snapshot.isFullChangelog()) {
                tag = Optional.empty();
            }
            if (!tag.isPresent()) {
                if (previousTag.isPresent()) {
                    tag = previousTag;
                }
                if (!tag.isPresent()) {
                    context.getLogger().debug(RB.$((String)"changelog.generator.lookup.matching.tag", (Object[])new Object[0]), new Object[]{tagPattern, effectiveTagName});
                    tag = tags.stream().filter(ref -> !GitSdk.extractTagName(ref).equals(effectiveTagName)).filter(ref -> versionPattern.matcher(GitSdk.extractTagName(ref)).matches()).filter(ref -> currentVersion.equalsSpec(this.version(context, (Ref)ref, versionPattern, true))).filter(ref -> !defaultVersion.equals(this.version(context, (Ref)ref, versionPattern, true))).findFirst();
                }
            }
            if (tag.isPresent()) {
                context.getLogger().debug(RB.$((String)"changelog.generator.tag.found", (Object[])new Object[0]), new Object[]{GitSdk.extractTagName((Ref)tag.get())});
                return Tags.previous((Ref)tag.get());
            }
            return Tags.empty();
        }
        if (!tag.isPresent()) {
            if (previousTag.isPresent()) {
                tag = previousTag;
            }
            if (!tag.isPresent()) {
                context.getLogger().debug(RB.$((String)"changelog.generator.lookup.matching.tag", (Object[])new Object[0]), new Object[]{tagPattern, effectiveTagName});
                tag = tags.stream().filter(ref -> !GitSdk.extractTagName(ref).equals(effectiveTagName)).filter(ref -> versionPattern.matcher(GitSdk.extractTagName(ref)).matches()).filter(ref -> currentVersion.equalsSpec(this.version(context, (Ref)ref, versionPattern, true))).filter(ref -> !defaultVersion.equals(this.version(context, (Ref)ref, versionPattern, true))).findFirst();
            }
            if (tag.isPresent()) {
                context.getLogger().debug(RB.$((String)"changelog.generator.tag.found", (Object[])new Object[0]), new Object[]{GitSdk.extractTagName((Ref)tag.get())});
                return Tags.previous((Ref)tag.get());
            }
            return Tags.empty();
        }
        if (!previousTag.isPresent()) {
            context.getLogger().debug(RB.$((String)"changelog.generator.lookup.before.tag", (Object[])new Object[0]), new Object[]{effectiveTagName, tagPattern});
            previousTag = tags.stream().filter(ref -> GitSdk.extractTagName(ref).matches(tagPattern)).filter(ref -> !defaultVersion.equals(this.version(context, (Ref)ref, versionPattern, true))).filter(ref -> ComparatorUtils.lessThan((Comparable)this.version(context, (Ref)ref, versionPattern, true), (Comparable)currentVersion)).findFirst();
        }
        if (previousTag.isPresent()) {
            context.getLogger().debug(RB.$((String)"changelog.generator.tag.found", (Object[])new Object[0]), new Object[]{GitSdk.extractTagName((Ref)previousTag.get())});
            return Tags.of((Ref)tag.get(), (Ref)previousTag.get());
        }
        return Tags.current((Ref)tag.get());
    }

    protected Iterable<RevCommit> resolveCommits(Git git, JReleaserContext context) throws GitAPIException, IOException {
        Ref fromRef;
        Project.Snapshot snapshot;
        String effectiveLabel;
        Tags tags = this.resolveTags(git, context);
        BaseReleaser releaser = context.getModel().getRelease().getReleaser();
        ObjectId head = git.getRepository().resolve("HEAD");
        if (context.getModel().getProject().isSnapshot() && (effectiveLabel = (snapshot = context.getModel().getProject().getSnapshot()).getEffectiveLabel()).equals(releaser.getEffectiveTagName(context.getModel()))) {
            if (tags.getPrevious().isPresent()) {
                Ref fromRef2 = tags.getPrevious().get();
                return git.log().addRange((AnyObjectId)this.getObjectId(git, fromRef2), (AnyObjectId)head).call();
            }
            return git.log().add((AnyObjectId)head).call();
        }
        if (!tags.getCurrent().isPresent()) {
            if (tags.getPrevious().isPresent()) {
                fromRef = tags.getPrevious().get();
                return git.log().addRange((AnyObjectId)this.getObjectId(git, fromRef), (AnyObjectId)head).call();
            }
            return git.log().add((AnyObjectId)head).call();
        }
        if (tags.getPrevious().isPresent()) {
            fromRef = this.getObjectId(git, tags.getPrevious().get());
            ObjectId toRef = this.getObjectId(git, tags.getCurrent().get());
            return git.log().addRange((AnyObjectId)fromRef, (AnyObjectId)toRef).call();
        }
        ObjectId toRef = this.getObjectId(git, tags.getCurrent().get());
        return git.log().add((AnyObjectId)toRef).call();
    }

    private ObjectId getObjectId(Git git, Ref ref) throws IOException {
        Ref peeled = git.getRepository().getRefDatabase().peel(ref);
        return peeled.getPeeledObjectId() != null ? peeled.getPeeledObjectId() : peeled.getObjectId();
    }

    protected String formatChangelog(JReleaserContext context, Changelog changelog, List<RevCommit> commits, Comparator<RevCommit> revCommitComparator, String lineSeparator) {
        TreeSet<Contributor> contributors = new TreeSet<Contributor>();
        LinkedHashMap categories = new LinkedHashMap();
        commits.stream().sorted(revCommitComparator).map(Commit::of).peek(c -> {
            if (!changelog.getContributors().isEnabled()) {
                return;
            }
            if (!changelog.getHide().containsContributor(((Commit)c).author.name)) {
                contributors.add(new Contributor(((Commit)c).author));
            }
            ((Commit)c).committers.stream().filter(author -> !changelog.getHide().containsContributor(author.name)).forEach(author -> contributors.add(new Contributor((Author)author)));
        }).peek(c -> this.applyLabels((Commit)c, changelog.getLabelers())).filter(c -> this.checkLabels((Commit)c, changelog)).forEach(commit -> categories.computeIfAbsent(this.categorize((Commit)commit, changelog), k -> new ArrayList()).add(commit));
        BaseReleaser releaser = context.getModel().getRelease().getReleaser();
        String commitsUrl = releaser.getResolvedCommitUrl(context.getModel());
        StringBuilder changes = new StringBuilder();
        for (Changelog.Category category : changelog.getCategories()) {
            String categoryKey = category.getKey();
            if (!categories.containsKey(categoryKey) || changelog.getHide().containsCategory(categoryKey)) continue;
            changes.append("## ").append(category.getTitle()).append(lineSeparator);
            String categoryFormat = this.resolveCommitFormat(changelog, category);
            changes.append(((List)categories.get(categoryKey)).stream().map(c -> Templates.resolveTemplate((String)categoryFormat, c.asContext(changelog.isLinks(), commitsUrl))).collect(Collectors.joining(lineSeparator))).append(lineSeparator).append(System.lineSeparator());
        }
        if (!changelog.getHide().isUncategorized() && categories.containsKey(UNCATEGORIZED)) {
            if (changes.length() > 0) {
                changes.append("---").append(lineSeparator);
            }
            changes.append(((List)categories.get(UNCATEGORIZED)).stream().map(c -> Templates.resolveTemplate((String)changelog.getFormat(), c.asContext(changelog.isLinks(), commitsUrl))).collect(Collectors.joining(lineSeparator))).append(lineSeparator).append(System.lineSeparator());
        }
        StringBuilder formattedContributors = new StringBuilder();
        if (changelog.getContributors().isEnabled() && !contributors.isEmpty()) {
            formattedContributors.append("## Contributors").append(lineSeparator).append("We'd like to thank the following people for their contributions:").append(lineSeparator).append(this.formatContributors(context, changelog, contributors, lineSeparator)).append(lineSeparator);
        }
        Map props = context.fullProps();
        props.put("changelogChanges", MustacheUtils.passThrough((String)changes.toString()));
        props.put("changelogContributors", MustacheUtils.passThrough((String)formattedContributors.toString()));
        return this.applyReplacers(context, changelog, StringUtils.stripMargin((String)MustacheUtils.applyTemplate((Reader)changelog.getResolvedContentTemplate(context), (Map)props)));
    }

    private String resolveCommitFormat(Changelog changelog, Changelog.Category category) {
        if (StringUtils.isNotBlank((String)category.getFormat())) {
            return category.getFormat();
        }
        return changelog.getFormat();
    }

    private String formatContributors(JReleaserContext context, Changelog changelog, Set<Contributor> contributors, String lineSeparator) {
        ArrayList list = new ArrayList();
        String format = changelog.getContributors().getFormat();
        Map<String, List<Contributor>> grouped = contributors.stream().peek(contributor -> {
            block2: {
                block3: {
                    if (!StringUtils.isNotBlank((String)format)) break block2;
                    if (format.contains("AsLink")) break block3;
                    if (!format.contains("Username")) break block2;
                }
                context.getReleaser().findUser(((Contributor)contributor).email, ((Contributor)contributor).name).ifPresent(contributor::setUser);
            }
        }).collect(Collectors.groupingBy(Contributor::getName));
        String contributorFormat = StringUtils.isNotBlank((String)format) ? format : "{{contributorName}}";
        grouped.keySet().stream().sorted().forEach(name -> {
            List cs = (List)grouped.get(name);
            Optional<Contributor> contributor = cs.stream().filter(c -> c.getUser() != null).findFirst();
            if (contributor.isPresent()) {
                list.add(Templates.resolveTemplate((String)contributorFormat, contributor.get().asContext()));
            } else {
                list.add(Templates.resolveTemplate((String)contributorFormat, ((Contributor)cs.get(0)).asContext()));
            }
        });
        String separator = contributorFormat.startsWith("-") || contributorFormat.startsWith("*") ? lineSeparator : ", ";
        return String.join((CharSequence)separator, list);
    }

    private String applyReplacers(JReleaserContext context, Changelog changelog, String text) {
        Map props = context.getModel().props();
        context.getModel().getRelease().getReleaser().fillProps(props, context.getModel());
        for (Changelog.Replacer replacer : changelog.getReplacers()) {
            String search = Templates.resolveTemplate((String)replacer.getSearch(), (Map)props);
            String replace = Templates.resolveTemplate((String)replacer.getReplace(), (Map)props);
            text = text.replaceAll(search, replace);
        }
        return text;
    }

    protected String categorize(Commit commit, Changelog changelog) {
        if (!commit.labels.isEmpty()) {
            for (Changelog.Category category : changelog.getCategories()) {
                if (!CollectionUtils.intersects((Set)category.getLabels(), (Set)commit.labels)) continue;
                return category.getKey();
            }
        }
        return UNCATEGORIZED;
    }

    private void applyLabels(Commit commit, Set<Changelog.Labeler> labelers) {
        for (Changelog.Labeler labeler : labelers) {
            String regex;
            if (StringUtils.isNotBlank((String)labeler.getTitle())) {
                if (labeler.getTitle().startsWith(REGEX_PREFIX)) {
                    regex = labeler.getTitle().substring(REGEX_PREFIX.length());
                    if (commit.title.matches(StringUtils.normalizeRegexPattern((String)regex))) {
                        commit.labels.add(labeler.getLabel());
                    }
                } else if (commit.title.contains(labeler.getTitle()) || commit.title.matches(StringUtils.toSafeRegexPattern((String)labeler.getTitle()))) {
                    commit.labels.add(labeler.getLabel());
                }
            }
            if (!StringUtils.isNotBlank((String)labeler.getBody())) continue;
            if (labeler.getBody().startsWith(REGEX_PREFIX)) {
                regex = labeler.getBody().substring(REGEX_PREFIX.length());
                if (!commit.body.matches(StringUtils.normalizeRegexPattern((String)regex))) continue;
                commit.labels.add(labeler.getLabel());
                continue;
            }
            if (!commit.body.contains(labeler.getBody()) && !commit.body.matches(StringUtils.toSafeRegexPattern((String)labeler.getBody()))) continue;
            commit.labels.add(labeler.getLabel());
        }
    }

    protected boolean checkLabels(Commit commit, Changelog changelog) {
        if (!changelog.getIncludeLabels().isEmpty()) {
            return CollectionUtils.intersects((Set)changelog.getIncludeLabels(), (Set)commit.labels);
        }
        if (!changelog.getExcludeLabels().isEmpty()) {
            return !CollectionUtils.intersects((Set)changelog.getExcludeLabels(), (Set)commit.labels);
        }
        return true;
    }

    public static String generate(JReleaserContext context) throws IOException {
        if (!context.getModel().getRelease().getReleaser().getChangelog().isEnabled()) {
            return "";
        }
        return new ChangelogGenerator().createChangelog(context);
    }

    private static class Contributor
    implements Comparable<Contributor> {
        private final String name;
        private final String email;
        private User user;

        private Contributor(Author author) {
            this.name = author.name;
            this.email = author.email;
        }

        private Contributor(String name, String email) {
            this.name = name;
            this.email = email;
        }

        public String getName() {
            return this.name;
        }

        public String getEmail() {
            return this.email;
        }

        public User getUser() {
            return this.user;
        }

        public void setUser(User user) {
            this.user = user;
        }

        Map<String, Object> asContext() {
            LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>();
            context.put("contributorName", MustacheUtils.passThrough((String)this.name));
            context.put("contributorNameAsLink", MustacheUtils.passThrough((String)this.name));
            context.put("contributorUsername", "");
            context.put("contributorUsernameAsLink", "");
            if (this.user != null) {
                context.put("contributorNameAsLink", MustacheUtils.passThrough((String)this.user.asLink(this.name)));
                context.put("contributorUsername", MustacheUtils.passThrough((String)this.user.getUsername()));
                context.put("contributorUsernameAsLink", MustacheUtils.passThrough((String)this.user.asLink("@" + this.user.getUsername())));
            }
            return context;
        }

        @Override
        public int compareTo(Contributor that) {
            return this.name.compareTo(that.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Contributor that = (Contributor)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return this.name + " <" + this.email + ">";
        }
    }

    private static class Author
    implements Comparable<Author> {
        protected final String name;
        protected final String email;

        private Author(String name, String email) {
            this.name = name;
            this.email = email;
        }

        public String getName() {
            return this.name;
        }

        public String getEmail() {
            return this.email;
        }

        @Override
        public int compareTo(Author that) {
            return this.name.compareTo(that.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Author that = (Author)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return this.name + " <" + this.email + ">";
        }
    }

    protected static class Commit {
        private static final Pattern CO_AUTHORED_BY_PATTERN = Pattern.compile("^[Cc]o-authored-by:\\s+(.*)\\s+<(.*)>.*$");
        private final Set<String> labels = new LinkedHashSet<String>();
        private final Set<Author> committers = new LinkedHashSet<Author>();
        private String fullHash;
        private String shortHash;
        private String title;
        private String body;
        private Author author;
        private int time;

        protected Commit() {
        }

        Map<String, Object> asContext(boolean links, String commitsUrl) {
            LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>();
            if (links) {
                context.put("commitShortHash", MustacheUtils.passThrough((String)("[" + this.shortHash + "](" + commitsUrl + "/" + this.shortHash + ")")));
            } else {
                context.put("commitShortHash", this.shortHash);
            }
            context.put("commitsUrl", commitsUrl);
            context.put("commitFullHash", this.fullHash);
            context.put("commitTitle", MustacheUtils.passThrough((String)this.title));
            context.put("commitAuthor", MustacheUtils.passThrough((String)this.author.name));
            context.put("commitBody", MustacheUtils.passThrough((String)this.body));
            return context;
        }

        private void addContributor(String name, String email) {
            if (StringUtils.isNotBlank((String)name) && StringUtils.isNotBlank((String)email)) {
                this.committers.add(new Author(name, email));
            }
        }

        static Commit of(RevCommit rc) {
            Commit c = new Commit();
            c.fullHash = rc.getId().name();
            c.shortHash = rc.getId().abbreviate(7).name();
            c.body = rc.getFullMessage();
            String[] lines = Commit.split(c.body);
            c.title = lines[0];
            c.author = new Author(rc.getAuthorIdent().getName(), rc.getAuthorIdent().getEmailAddress());
            c.addContributor(rc.getCommitterIdent().getName(), rc.getCommitterIdent().getEmailAddress());
            c.time = rc.getCommitTime();
            for (String line : lines) {
                Matcher m = CO_AUTHORED_BY_PATTERN.matcher(line);
                if (!m.matches()) continue;
                c.addContributor(m.group(1), m.group(2));
            }
            return c;
        }

        private static String[] split(String str) {
            String sep = "\r\n";
            if (str.contains(sep)) {
                return str.split(sep);
            }
            return str.split("\n");
        }
    }

    public static class Tags {
        private final Optional<Ref> current;
        private final Optional<Ref> previous;

        private Tags(Ref current, Ref previous) {
            this.current = Optional.ofNullable(current);
            this.previous = Optional.ofNullable(previous);
        }

        public Optional<Ref> getCurrent() {
            return this.current;
        }

        public Optional<Ref> getPrevious() {
            return this.previous;
        }

        private static Tags empty() {
            return new Tags(null, null);
        }

        private static Tags current(Ref tag) {
            return new Tags(tag, null);
        }

        private static Tags previous(Ref tag) {
            return new Tags(null, tag);
        }

        private static Tags of(Ref tag1, Ref tag2) {
            return new Tags(tag1, tag2);
        }
    }
}

