/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.JpackageAssembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.FileUtils;

public abstract class JpackageAssemblerResolver
extends Validator {
    public static void resolveJpackageOutputs(JReleaserContext context, Errors errors) {
        List<JpackageAssembler> activeJpackages = context.getModel().getAssemble().getActiveJpackages();
        if (!activeJpackages.isEmpty()) {
            context.getLogger().debug("assemble.jpackage");
        }
        for (JpackageAssembler jpackage : activeJpackages) {
            if (!jpackage.isExported()) continue;
            JpackageAssemblerResolver.resolveJpackageOutputs(context, jpackage, errors);
        }
    }

    private static void resolveJpackageOutputs(JReleaserContext context, JpackageAssembler jpackage, Errors errors) {
        Path baseOutputDirectory = context.getAssembleDirectory().resolve(jpackage.getName()).resolve(jpackage.getType());
        Artifact jdk = jpackage.getResolvedPlatformPackager().getJdk();
        if (!context.isPlatformSelected(jdk)) {
            return;
        }
        JpackageAssembler.PlatformPackager packager = jpackage.getResolvedPlatformPackager();
        String platform = jdk.getPlatform();
        for (String type : packager.getTypes()) {
            try {
                Optional file = (Optional)FileUtils.listFilesAndProcess((Path)baseOutputDirectory, files -> files.filter(path -> path.getFileName().toString().endsWith(type)).findFirst());
                if (!file.isPresent()) {
                    errors.assembly(RB.$((String)"validation_missing_assembly", (Object[])new Object[]{jpackage.getType(), jpackage.getName(), jpackage.getName()}));
                    continue;
                }
                Artifact artifact = Artifact.of((Path)file.get(), platform);
                artifact.setExtraProperties(jpackage.getExtraProperties());
                artifact.activate();
                jpackage.addOutput(artifact);
            }
            catch (IOException e) {
                throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }
}

