/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.upload;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.upload.AbstractUploader;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public final class GiteaUploader
extends AbstractUploader<org.jreleaser.model.api.upload.GiteaUploader, GiteaUploader> {
    private static final String DOWNLOAD_URL = "https://{{host}}/api/packages/{{owner}}/generic/{{packageName}}/{{packageVersion}}/{{artifactFile}}";
    private String host;
    private String owner;
    private String token;
    private String packageName;
    private String packageVersion;
    private final org.jreleaser.model.api.upload.GiteaUploader immutable = new org.jreleaser.model.api.upload.GiteaUploader(){

        public String getHost() {
            return GiteaUploader.this.host;
        }

        public String getOwner() {
            return GiteaUploader.this.owner;
        }

        public String getToken() {
            return GiteaUploader.this.token;
        }

        public String getPackageName() {
            return GiteaUploader.this.packageName;
        }

        public String getPackageVersion() {
            return GiteaUploader.this.packageVersion;
        }

        public String getType() {
            return GiteaUploader.this.type;
        }

        public String getName() {
            return GiteaUploader.this.name;
        }

        public boolean isSnapshotSupported() {
            return GiteaUploader.this.isSnapshotSupported();
        }

        public boolean isArtifacts() {
            return GiteaUploader.this.isArtifacts();
        }

        public boolean isFiles() {
            return GiteaUploader.this.isFiles();
        }

        public boolean isSignatures() {
            return GiteaUploader.this.isSignatures();
        }

        public boolean isChecksums() {
            return GiteaUploader.this.isChecksums();
        }

        public Active getActive() {
            return GiteaUploader.this.active;
        }

        public boolean isEnabled() {
            return GiteaUploader.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(GiteaUploader.this.asMap(full));
        }

        public String getPrefix() {
            return GiteaUploader.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(GiteaUploader.this.extraProperties);
        }

        public Integer getConnectTimeout() {
            return GiteaUploader.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return GiteaUploader.this.readTimeout;
        }
    };

    public GiteaUploader() {
        super("gitea");
    }

    @Override
    public org.jreleaser.model.api.upload.GiteaUploader asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(GiteaUploader source) {
        super.merge(source);
        this.host = this.merge(this.host, source.host);
        this.owner = this.merge(this.owner, source.owner);
        this.token = this.merge(this.token, source.token);
        this.packageName = this.merge(this.packageName, source.packageName);
        this.packageVersion = this.merge(this.packageVersion, source.packageVersion);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("host", this.host);
        props.put("owner", this.owner);
        props.put("token", StringUtils.isNotBlank((String)this.getResolvedToken()) ? "************" : "**unset**");
        props.put("packageName", this.packageName);
        props.put("packageVersion", this.packageVersion);
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context.fullProps(), artifact);
    }

    @Override
    public String getResolvedDownloadUrl(Map<String, Object> props, Artifact artifact) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>(this.artifactProps(props, artifact));
        p.putAll(this.getResolvedExtraProperties());
        p.put("host", this.host);
        p.put("owner", this.owner);
        p.put("packageName", this.packageName);
        p.put("packageVersion", this.packageVersion);
        return Templates.resolveTemplate((String)DOWNLOAD_URL, p);
    }

    public String getResolvedUploadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context, artifact);
    }

    public String getResolvedToken() {
        return Env.env((Collection)CollectionUtils.listOf((Object[])new String[]{"GITLAB_" + Env.toVar((String)this.name) + "_TOKEN", "GITLAB_TOKEN"}), (String)this.token);
    }
}

