/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.catalog.swid;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.util.StringUtils;

public class Entity
extends AbstractModelObject<Entity>
implements Domain,
Comparable<Entity> {
    private static final long serialVersionUID = -4316021076553932863L;
    private final Set<String> roles = new TreeSet<String>();
    private String name;
    private String regid;
    @JsonIgnore
    private final org.jreleaser.model.api.catalog.swid.Entity immutable = new org.jreleaser.model.api.catalog.swid.Entity(){
        private static final long serialVersionUID = -8205490334587909973L;

        public String getName() {
            return Entity.this.name;
        }

        public String getRegid() {
            return Entity.this.regid;
        }

        public Set<String> getRoles() {
            return Collections.unmodifiableSet(Entity.this.roles);
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Entity.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.catalog.swid.Entity asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Entity source) {
        this.name = this.merge(this.name, source.name);
        this.regid = this.merge(this.regid, source.regid);
        this.setRoles(this.merge(this.roles, source.roles));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRegid() {
        return this.regid;
    }

    public void setRegid(String regid) {
        this.regid = regid;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles.clear();
        this.roles.addAll(roles);
    }

    public void addRoles(Set<String> roles) {
        this.roles.addAll(roles);
    }

    public void addRole(String role) {
        if (StringUtils.isNotBlank((String)role)) {
            this.roles.add(role.trim());
        }
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("name", this.name);
        props.put("regid", this.regid);
        props.put("roles", this.roles);
        return props;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity entity = (Entity)o;
        return this.name.equals(entity.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public int compareTo(Entity o) {
        return Comparator.comparing(Entity::getName).compare(this, o);
    }
}

