/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.opencollective;

import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.sdk.opencollective.OpenCollectiveException;
import org.jreleaser.sdk.opencollective.OpenCollectiveSdk;
import org.jreleaser.util.StringUtils;

public class OpenCollectiveAnnouncer
implements Announcer<org.jreleaser.model.api.announce.OpenCollectiveAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.OpenCollectiveAnnouncer openCollective;

    public OpenCollectiveAnnouncer(JReleaserContext context) {
        this.context = context;
        this.openCollective = context.getModel().getAnnounce().getOpenCollective();
    }

    public org.jreleaser.model.api.announce.OpenCollectiveAnnouncer getAnnouncer() {
        return this.openCollective.asImmutable();
    }

    public String getName() {
        return "opencollective";
    }

    public boolean isEnabled() {
        return this.openCollective.isEnabled();
    }

    public void announce() throws AnnounceException {
        String message = "";
        if (StringUtils.isNotBlank((String)this.openCollective.getMessage())) {
            message = this.openCollective.getResolvedMessage(this.context);
        } else {
            TemplateContext props = new TemplateContext();
            this.context.getModel().getRelease().getReleaser().fillProps(props, this.context);
            message = this.openCollective.getResolvedMessageTemplate(this.context, props);
        }
        String title = this.openCollective.getResolvedTitle(this.context);
        String slug = this.openCollective.getSlug();
        this.context.getLogger().debug("slug: {}", new Object[]{slug});
        this.context.getLogger().info("title: {}", new Object[]{title});
        this.context.getLogger().info("message: {}", new Object[]{message});
        try {
            OpenCollectiveSdk sdk = OpenCollectiveSdk.builder(this.context.asImmutable()).host(this.openCollective.getHost()).token(this.openCollective.getToken()).connectTimeout(this.openCollective.getConnectTimeout()).readTimeout(this.openCollective.getReadTimeout()).dryrun(this.context.isDryrun()).build();
            sdk.postUpdate(slug, title, message);
        }
        catch (OpenCollectiveException e) {
            throw new AnnounceException((Throwable)e);
        }
    }
}

