/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.logging;

import java.io.PrintWriter;
import java.util.ArrayDeque;
import org.jreleaser.logging.JReleaserLogger;

public abstract class AbstractJReleaserLogger
implements JReleaserLogger {
    private final ArrayDeque<String> prefix = new ArrayDeque();
    private final PrintWriter tracer;
    private String indent = "";

    protected AbstractJReleaserLogger(PrintWriter tracer) {
        this.tracer = tracer;
    }

    protected boolean isIndented() {
        return !"".equals(this.indent);
    }

    @Override
    public PrintWriter getTracer() {
        return this.tracer;
    }

    @Override
    public void close() {
        if (null == this.tracer) {
            return;
        }
        this.tracer.flush();
        this.tracer.close();
    }

    @Override
    public void reset() {
        this.prefix.clear();
        this.indent = "";
    }

    @Override
    public void replacePrefix(String prefix) {
        this.restorePrefix();
        this.setPrefix(prefix);
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix.push(prefix);
    }

    @Override
    public void restorePrefix() {
        if (!this.prefix.isEmpty()) {
            this.prefix.pop();
        }
    }

    @Override
    public void increaseIndent() {
        this.indent = this.indent + "  ";
    }

    @Override
    public void decreaseIndent() {
        if (this.indent.length() > 0) {
            this.indent = this.indent.substring(0, this.indent.length() - 2);
        }
    }

    protected String formatMessage(String message) {
        return this.indent + (!this.prefix.isEmpty() ? "[" + this.prefix.peek() + "] " : "") + message;
    }

    @Override
    public void trace(String message) {
        this.tracer.println(message);
        this.tracer.flush();
    }

    @Override
    public void trace(String message, Throwable throwable) {
        this.tracer.println(message);
        this.printThrowable(throwable);
        this.tracer.flush();
    }

    @Override
    public void trace(Throwable throwable) {
        this.printThrowable(throwable);
    }

    private void printThrowable(Throwable throwable) {
        if (null != throwable) {
            throwable.printStackTrace(this.tracer);
            this.tracer.flush();
        }
    }
}

