/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.TemplatePackager;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.packagers.AbstractPackagerProcessor;
import org.jreleaser.templates.TemplateResource;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.StringUtils;

public abstract class AbstractTemplatePackagerProcessor<T extends TemplatePackager<?>>
extends AbstractPackagerProcessor<T> {
    protected AbstractTemplatePackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPrepareDistribution(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        try {
            this.doPrepareDistribution(distribution, props, distribution.getName(), this.getPrepareDirectory(props), ((TemplatePackager)this.getPackager()).getTemplateDirectory(), this.getPackagerName(), true);
        }
        catch (IOException e) {
            throw new PackagerProcessingException((Throwable)e);
        }
    }

    protected void doPrepareDistribution(Distribution distribution, TemplateContext props, String distributionName, Path prepareDirectory, String templateDirectory, String packagerName, boolean copyLicense) throws IOException, PackagerProcessingException {
        FileUtils.deleteFiles((Path)prepareDirectory);
        Files.createDirectories(prepareDirectory, new FileAttribute[0]);
        this.context.getLogger().debug(RB.$((String)"packager.resolve.templates", (Object[])new Object[0]), new Object[]{distributionName, packagerName});
        Map templates = TemplateUtils.resolveAndMergeTemplates((JReleaserLogger)this.context.getLogger(), (String)distribution.getType().name(), (String)this.getPackagerName(), (boolean)this.context.getModel().getProject().isSnapshot(), (Path)this.context.getBasedir().resolve(templateDirectory));
        for (Map.Entry entry : templates.entrySet()) {
            String filename = (String)entry.getKey();
            if (this.isSkipped(filename)) {
                this.context.getLogger().debug(RB.$((String)"packager.skipped.template", (Object[])new Object[0]), new Object[]{filename, distributionName, packagerName});
                continue;
            }
            TemplateResource value = (TemplateResource)entry.getValue();
            if (value.isReader()) {
                this.context.getLogger().debug(RB.$((String)"packager.evaluate.template", (Object[])new Object[0]), new Object[]{filename, distributionName, packagerName});
                String content = this.applyTemplate(filename, value.getReader(), props);
                if (!content.endsWith(System.lineSeparator())) {
                    content = content + System.lineSeparator();
                }
                this.context.getLogger().debug(RB.$((String)"packager.write.template", (Object[])new Object[0]), new Object[]{filename, distributionName, packagerName});
                this.writeFile(distribution, content, props, prepareDirectory, filename);
                continue;
            }
            this.context.getLogger().debug(RB.$((String)"packager.write.file", (Object[])new Object[0]), new Object[]{filename, distributionName, packagerName});
            this.writeFile(distribution, value.getInputStream(), props, prepareDirectory, filename);
        }
        if (copyLicense && StringUtils.isFalse(((TemplatePackager)this.packager).getExtraProperties().get("skipLicenseFile"))) {
            this.context.getLogger().debug(RB.$((String)"packager.copy.license", (Object[])new Object[0]));
            FileUtils.copyFiles((JReleaserLogger)this.context.getLogger(), (Path)this.context.getBasedir(), (Path)prepareDirectory, path -> path.getFileName().startsWith("LICENSE"));
        }
    }

    protected String applyTemplate(String fileName, Reader reader, TemplateContext props) {
        return MustacheUtils.applyTemplate((Reader)reader, (TemplateContext)props);
    }

    public boolean isSkipped(String filename) {
        if (((TemplatePackager)this.packager).getSkipTemplates().contains(filename)) {
            return true;
        }
        if (((TemplatePackager)this.packager).getSkipTemplates().stream().anyMatch(filename::contains)) {
            return true;
        }
        if (((TemplatePackager)this.packager).getSkipTemplates().stream().anyMatch(filename::matches)) {
            return true;
        }
        String fname = TemplateUtils.trimTplExtension((String)filename);
        if (((TemplatePackager)this.packager).getSkipTemplates().contains(fname)) {
            return true;
        }
        if (((TemplatePackager)this.packager).getSkipTemplates().stream().anyMatch(fname::contains)) {
            return true;
        }
        return ((TemplatePackager)this.packager).getSkipTemplates().stream().anyMatch(fname::matches);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        this.doPackageDistribution(distribution, props, this.getPackageDirectory(props));
    }

    protected void doPackageDistribution(Distribution distribution, TemplateContext props, Path packageDirectory) throws PackagerProcessingException {
        try {
            FileUtils.deleteFiles((Path)packageDirectory);
            Files.createDirectories(packageDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new PackagerProcessingException((Throwable)e);
        }
    }

    protected abstract void writeFile(Distribution var1, String var2, TemplateContext var3, Path var4, String var5) throws PackagerProcessingException;

    protected void writeFile(Distribution distribution, InputStream inputStream, TemplateContext props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        Path outputFile = outputDirectory.resolve(fileName);
        this.writeFile(inputStream, outputFile);
    }

    protected void writeFile(Reader reader, Path outputFile) throws PackagerProcessingException {
        try {
            FileUtils.createDirectoriesWithFullAccess((Path)outputFile.getParent());
            Files.write(outputFile, IOUtils.toByteArray((Reader)reader, (Charset)StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            FileUtils.grantFullAccess((Path)outputFile);
        }
        catch (Exception e) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_error_writing_file", (Object[])new Object[]{outputFile.toAbsolutePath()}), (Throwable)e);
        }
    }

    protected void writeFile(InputStream inputStream, Path outputFile) throws PackagerProcessingException {
        try {
            FileUtils.createDirectoriesWithFullAccess((Path)outputFile.getParent());
            Files.write(outputFile, IOUtils.toByteArray((InputStream)inputStream), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            FileUtils.grantFullAccess((Path)outputFile);
        }
        catch (Exception e) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_error_writing_file", (Object[])new Object[]{outputFile.toAbsolutePath()}), (Throwable)e);
        }
    }

    protected void writeFile(byte[] content, Path outputFile) throws PackagerProcessingException {
        try {
            FileUtils.createDirectoriesWithFullAccess((Path)outputFile.getParent());
            Files.write(outputFile, content, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            FileUtils.grantFullAccess((Path)outputFile);
        }
        catch (Exception e) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_error_writing_file", (Object[])new Object[]{outputFile.toAbsolutePath()}), (Throwable)e);
        }
    }

    protected void writeFile(String content, Path outputFile) throws PackagerProcessingException {
        this.writeFile(content.getBytes(StandardCharsets.UTF_8), outputFile);
    }
}

