/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.AbstractDownloader;
import org.jreleaser.model.Http;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public class HttpDownloader
extends AbstractDownloader<HttpDownloader>
implements Http {
    public static final String TYPE = "http";
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private String username;
    private String password;
    private Http.Authorization authorization;

    public HttpDownloader() {
        super(TYPE);
    }

    @Override
    public void merge(HttpDownloader http) {
        this.freezeCheck();
        super.merge(http);
        this.username = this.merge(this.username, http.username);
        this.password = this.merge(this.password, http.password);
        this.authorization = this.merge(this.authorization, http.authorization);
        this.setHeaders(this.merge(this.headers, http.headers));
    }

    public Http.Authorization resolveAuthorization() {
        if (null == this.authorization) {
            this.authorization = Http.Authorization.NONE;
        }
        return this.authorization;
    }

    public String getResolvedUsername() {
        return Env.env((String)("HTTP_" + Env.toVar((String)this.name) + "_USERNAME"), (String)this.username);
    }

    public String getResolvedPassword() {
        return Env.env((String)("HTTP_" + Env.toVar((String)this.name) + "_PASSWORD"), (String)this.password);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.freezeCheck();
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.freezeCheck();
        this.password = password;
    }

    public Http.Authorization getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(Http.Authorization authorization) {
        this.freezeCheck();
        this.authorization = authorization;
    }

    public void setAuthorization(String authorization) {
        this.freezeCheck();
        this.authorization = Http.Authorization.of(authorization);
    }

    public Map<String, String> getHeaders() {
        return this.freezeWrap(this.headers);
    }

    public void setHeaders(Map<String, String> headers) {
        this.freezeCheck();
        this.headers.putAll(headers);
    }

    public void addHeaders(Map<String, String> headers) {
        this.freezeCheck();
        this.headers.putAll(headers);
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("authorization", (Object)this.authorization);
        props.put("username", StringUtils.isNotBlank((String)this.getResolvedUsername()) ? "************" : "**unset**");
        props.put("password", StringUtils.isNotBlank((String)this.getResolvedPassword()) ? "************" : "**unset**");
        props.put("headers", this.headers);
    }
}

