/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Assembler;
import org.jreleaser.model.FileSet;
import org.jreleaser.model.Platform;
import org.jreleaser.model.Project;
import org.jreleaser.model.Stereotype;
import org.jreleaser.util.MustacheUtils;

abstract class AbstractAssembler<S extends AbstractAssembler<S>>
extends AbstractModelObject<S>
implements Assembler {
    @JsonIgnore
    protected final Set<Artifact> outputs = new LinkedHashSet<Artifact>();
    protected final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    protected final List<FileSet> fileSets = new ArrayList<FileSet>();
    protected final Platform platform = new Platform();
    @JsonIgnore
    protected final String type;
    @JsonIgnore
    protected String name;
    @JsonIgnore
    protected boolean enabled;
    protected Active active;
    protected Boolean exported;
    private Stereotype stereotype;

    protected AbstractAssembler(String type) {
        this.type = type;
    }

    @Override
    public void freeze() {
        super.freeze();
        this.platform.freeze();
        this.outputs.forEach(AbstractModelObject::freeze);
        this.fileSets.forEach(AbstractModelObject::freeze);
    }

    @Override
    public void merge(S assembler) {
        this.freezeCheck();
        this.active = this.merge(this.active, ((AbstractAssembler)assembler).active);
        this.enabled = this.merge(this.enabled, ((AbstractAssembler)assembler).enabled);
        this.exported = this.merge(this.exported, ((AbstractAssembler)assembler).exported);
        this.name = this.merge(this.name, ((AbstractAssembler)assembler).name);
        this.platform.merge(((AbstractAssembler)assembler).platform);
        this.stereotype = this.merge(this.stereotype, ((AbstractAssembler)assembler).getStereotype());
        this.setOutputs(this.merge(this.outputs, ((AbstractAssembler)assembler).outputs));
        this.setFileSets(this.merge(this.fileSets, ((AbstractAssembler)assembler).fileSets));
        this.setExtraProperties(this.merge(this.extraProperties, ((AbstractAssembler)assembler).extraProperties));
    }

    @Override
    public Map<String, Object> props() {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("distributionName", this.name);
        props.put("distributionStereotype", (Object)this.getStereotype());
        return props;
    }

    @Override
    public Stereotype getStereotype() {
        return this.stereotype;
    }

    @Override
    public void setStereotype(Stereotype stereotype) {
        this.freezeCheck();
        this.stereotype = stereotype;
    }

    @Override
    public void setStereotype(String str) {
        this.setStereotype(Stereotype.of(str));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.active = Active.NEVER;
        }
        this.enabled = this.active.check(project);
        return this.enabled;
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public void setPlatform(Platform platform) {
        this.freezeCheck();
        this.platform.merge(platform);
    }

    @Override
    public boolean isExported() {
        return this.exported == null || this.exported != false;
    }

    @Override
    public void setExported(Boolean exported) {
        this.freezeCheck();
        this.exported = exported;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.freezeCheck();
        this.name = name;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.freezeCheck();
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of(str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    @Override
    public Set<Artifact> getOutputs() {
        return this.freezeWrap(Artifact.sortArtifacts(this.outputs));
    }

    @Override
    public void setOutputs(Set<Artifact> output) {
        this.freezeCheck();
        this.outputs.clear();
        this.outputs.addAll(output);
    }

    @Override
    public void addOutput(Artifact artifact) {
        this.freezeCheck();
        if (null != artifact) {
            this.outputs.add(artifact);
        }
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.freezeWrap(this.extraProperties);
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.freezeCheck();
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.freezeCheck();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public String getPrefix() {
        return this.getType();
    }

    @Override
    public List<FileSet> getFileSets() {
        return this.freezeWrap(this.fileSets);
    }

    @Override
    public void setFileSets(List<FileSet> fileSets) {
        this.freezeCheck();
        this.fileSets.clear();
        this.fileSets.addAll(fileSets);
    }

    @Override
    public void addFileSets(List<FileSet> files) {
        this.freezeCheck();
        this.fileSets.addAll(files);
    }

    @Override
    public void addFileSet(FileSet file) {
        this.freezeCheck();
        if (null != file) {
            this.fileSets.add(file);
        }
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("exported", this.isExported());
        props.put("active", (Object)this.active);
        props.put("stereotype", (Object)this.stereotype);
        if (full || this.platform.isSet()) {
            props.put("platform", this.platform.asMap(full));
        }
        this.asMap(full, props);
        LinkedHashMap<String, Map<String, Object>> mappedFileSets = new LinkedHashMap<String, Map<String, Object>>();
        for (int i = 0; i < this.fileSets.size(); ++i) {
            mappedFileSets.put("fileSet " + i, this.fileSets.get(i).asMap(full));
        }
        props.put("fileSets", mappedFileSets);
        props.put("extraProperties", this.getResolvedExtraProperties());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getName(), props);
        return map;
    }

    protected abstract void asMap(boolean var1, Map<String, Object> var2);
}

