/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util.signing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.openpgp.PGPException;
import org.jreleaser.util.signing.Keyring;

public final class InMemoryKeyring
extends Keyring {
    private final byte[] encodedPublicKey;
    private final byte[] encodedPrivateKey;

    public InMemoryKeyring(byte[] encodedPublicKey, byte[] encodedPrivateKey) throws IOException, PGPException {
        this.encodedPublicKey = encodedPublicKey;
        this.encodedPrivateKey = encodedPrivateKey;
    }

    @Override
    protected InputStream getPublicKeyRingStream() throws IOException {
        return new ByteArrayInputStream(this.encodedPublicKey);
    }

    @Override
    protected InputStream getSecretKeyRingStream() throws IOException {
        return new ByteArrayInputStream(this.encodedPrivateKey);
    }
}

