/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.Parser;
import com.github.sbaudoin.yamllint.rules.LineRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EmptyLines
extends LineRule {
    public static final String OPTION_MAX = "max";
    public static final String OPTION_MAX_START = "max-start";
    public static final String OPTION_MAX_END = "max-end";

    public EmptyLines() {
        this.registerOption(OPTION_MAX, 2);
        this.registerOption(OPTION_MAX_START, 0);
        this.registerOption(OPTION_MAX_END, 0);
    }

    @Override
    public List<LintProblem> check(Map<Object, Object> conf, Parser.Line line) {
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (line.getStart() == line.getEnd() && line.getEnd() < line.getBuffer().length()) {
            int start;
            if (line.getEnd() + 2 <= line.getBuffer().length() && "\n\n".equals(line.getBuffer().substring(line.getEnd(), line.getEnd() + 2)) || line.getEnd() + 4 <= line.getBuffer().length() && "\r\n\r\n".equals(line.getBuffer().substring(line.getEnd(), line.getEnd() + 4))) {
                return problems;
            }
            int blankLines = 0;
            for (start = line.getStart(); start >= 2 && "\r\n".equals(line.getBuffer().substring(start - 2, start)); start -= 2) {
                ++blankLines;
            }
            while (start >= 1 && line.getBuffer().charAt(start - 1) == '\n') {
                ++blankLines;
                --start;
            }
            int max = (Integer)conf.get(OPTION_MAX);
            if (start == 0) {
                ++blankLines;
                max = (Integer)conf.get(OPTION_MAX_START);
            }
            if (line.getEnd() == line.getBuffer().length() - 1 && line.getBuffer().charAt(line.getEnd()) == '\n' || line.getEnd() == line.getBuffer().length() - 2 && "\r\n".equals(line.getBuffer().substring(line.getEnd(), line.getEnd() + 2))) {
                if (line.getEnd() == 0) {
                    return problems;
                }
                max = (Integer)conf.get(OPTION_MAX_END);
            }
            if (blankLines > max) {
                problems.add(new LintProblem(line.getLineNo(), 1, "too many blank lines (" + blankLines + " > " + max + ")"));
            }
        }
        return problems;
    }
}

