/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.forgejo;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.model.api.common.Apply;
import org.jreleaser.model.api.common.ExtraProperties;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.util.VersionUtils;
import org.jreleaser.model.spi.release.ReleaseException;
import org.jreleaser.model.spi.release.Repository;
import org.jreleaser.model.spi.release.User;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.forgejo.Forgejo;
import org.jreleaser.sdk.forgejo.api.Asset;
import org.jreleaser.sdk.forgejo.api.Issue;
import org.jreleaser.sdk.forgejo.api.Label;
import org.jreleaser.sdk.forgejo.api.Milestone;
import org.jreleaser.sdk.forgejo.api.Release;
import org.jreleaser.sdk.forgejo.api.Repository;
import org.jreleaser.sdk.git.ChangelogProvider;
import org.jreleaser.sdk.git.GitSdk;
import org.jreleaser.sdk.git.release.AbstractReleaser;
import org.jreleaser.util.StringUtils;

public class ForgejoReleaser
extends AbstractReleaser<org.jreleaser.model.api.release.ForgejoReleaser> {
    private static final long serialVersionUID = -8160459963248847787L;
    private final org.jreleaser.model.internal.release.ForgejoReleaser forgejo;

    public ForgejoReleaser(JReleaserContext context, Set<org.jreleaser.model.spi.release.Asset> assets) {
        super(context, assets);
        this.forgejo = context.getModel().getRelease().getForgejo();
    }

    public org.jreleaser.model.api.release.ForgejoReleaser getReleaser() {
        return this.forgejo.asImmutable();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createRelease() throws ReleaseException {
        String pullBranch = this.forgejo.getBranch();
        String pushBranch = this.forgejo.getResolvedBranchPush(this.context.getModel());
        boolean mustCheckoutBranch = !pushBranch.equals(pullBranch);
        this.context.getLogger().info(RB.$((String)"git.releaser.releasing", (Object[])new Object[0]), new Object[]{this.forgejo.getResolvedRepoUrl(this.context.getModel()), pushBranch});
        String tagName = this.forgejo.getEffectiveTagName(this.context.getModel());
        try {
            Forgejo api = new Forgejo(this.context.asImmutable(), this.forgejo.getApiEndpoint(), this.forgejo.getToken(), this.forgejo.getConnectTimeout(), this.forgejo.getReadTimeout());
            if (!this.context.isDryrun()) {
                List<String> branchNames = api.listBranches(this.forgejo.getOwner(), this.forgejo.getName());
                GitSdk.of((JReleaserContext)this.context).checkoutBranch((BaseReleaser)this.forgejo, pushBranch, mustCheckoutBranch, !branchNames.contains(pushBranch));
            }
            String changelog = this.context.getChangelog().getResolvedChangelog();
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.lookup", (Object[])new Object[0]), new Object[]{tagName, this.forgejo.getCanonicalRepoName()});
            Release release = this.findReleaseByTag(api, tagName);
            boolean snapshot = this.context.getModel().getProject().isSnapshot();
            if (null != release) {
                this.context.getLogger().debug(RB.$((String)"git.releaser.release.exists", (Object[])new Object[0]), new Object[]{tagName});
                if (this.forgejo.isOverwrite() || snapshot) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.delete", (Object[])new Object[0]), new Object[]{tagName});
                    if (!this.context.isDryrun()) {
                        api.deleteRelease(this.forgejo.getOwner(), this.forgejo.getName(), tagName, release.getId());
                    }
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
                    this.createRelease(api, tagName, changelog, this.forgejo.isMatch());
                    return;
                }
                if (this.forgejo.getUpdate().isEnabled()) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.update", (Object[])new Object[0]), new Object[]{tagName});
                    if (this.context.isDryrun()) return;
                    Release updater = new Release();
                    if (this.forgejo.getPrerelease().isEnabledSet()) {
                        updater.setPrerelease(this.forgejo.getPrerelease().isEnabled());
                    }
                    if (this.forgejo.isDraftSet()) {
                        updater.setDraft(this.forgejo.isDraft());
                    }
                    if (this.forgejo.getUpdate().getSections().contains(UpdateSection.TITLE)) {
                        this.context.getLogger().info(RB.$((String)"git.releaser.release.update.title", (Object[])new Object[0]), new Object[]{this.forgejo.getEffectiveReleaseName()});
                        updater.setName(this.forgejo.getEffectiveReleaseName());
                    }
                    if (this.forgejo.getUpdate().getSections().contains(UpdateSection.BODY)) {
                        this.context.getLogger().info(RB.$((String)"git.releaser.release.update.body", (Object[])new Object[0]));
                        updater.setBody(changelog);
                    }
                    api.updateRelease(this.forgejo.getOwner(), this.forgejo.getName(), release.getId(), updater);
                    if (this.forgejo.getUpdate().getSections().contains(UpdateSection.ASSETS)) {
                        this.updateAssets(api, release);
                    }
                    this.updateIssues(this.forgejo, api);
                    return;
                }
                if (this.context.isDryrun()) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
                    this.createRelease(api, tagName, changelog, false);
                    return;
                }
                throw new IllegalStateException(RB.$((String)"ERROR_git_releaser_cannot_release", (Object[])new Object[]{StringUtils.capitalize((String)this.forgejo.getServiceName()), tagName}));
            }
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.not.found", (Object[])new Object[0]), new Object[]{tagName});
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
            this.createRelease(api, tagName, changelog, snapshot && this.forgejo.isMatch());
            return;
        }
        catch (IOException | IllegalStateException | RestAPIException e) {
            this.context.getLogger().trace(e);
            throw new ReleaseException(e);
        }
    }

    private Release findReleaseByTag(Forgejo api, String tagName) {
        if (this.context.isDryrun()) {
            return null;
        }
        return api.findReleaseByTag(this.forgejo.getOwner(), this.forgejo.getName(), tagName);
    }

    protected Repository.Kind resolveRepositoryKind() {
        return Repository.Kind.OTHER;
    }

    public org.jreleaser.model.spi.release.Repository maybeCreateRepository(String owner, String repo, String password, ExtraProperties extraProperties) throws IOException {
        this.context.getLogger().debug(RB.$((String)"git.repository.lookup", (Object[])new Object[0]), new Object[]{owner, repo});
        Forgejo api = new Forgejo(this.context.asImmutable(), this.forgejo.getApiEndpoint(), password, this.forgejo.getConnectTimeout(), this.forgejo.getReadTimeout());
        Repository repository = api.findRepository(owner, repo);
        if (null == repository) {
            repository = api.createRepository(owner, repo);
        }
        return new org.jreleaser.model.spi.release.Repository(this.resolveRepositoryKind(), owner, repo, repository.getHtmlUrl(), repository.getCloneUrl());
    }

    public Optional<User> findUser(String email, String name) {
        try {
            String host = this.forgejo.getHost();
            String endpoint = this.forgejo.getApiEndpoint();
            host = endpoint.startsWith("https") ? "https://" + host : "http://" + host;
            if (!host.endsWith("/")) {
                host = host + "/";
            }
            return new Forgejo(this.context.asImmutable(), this.forgejo.getApiEndpoint(), this.forgejo.getToken(), this.forgejo.getConnectTimeout(), this.forgejo.getReadTimeout()).findUser(email, name, host);
        }
        catch (RestAPIException e) {
            this.context.getLogger().trace((Throwable)e);
            this.context.getLogger().debug(RB.$((String)"git.releaser.user.not.found", (Object[])new Object[0]), new Object[]{email});
            return Optional.empty();
        }
    }

    public List<org.jreleaser.model.spi.release.Release> listReleases(String owner, String repo) throws IOException {
        Forgejo api = new Forgejo(this.context.asImmutable(), this.forgejo.getApiEndpoint(), this.forgejo.getToken(), this.forgejo.getConnectTimeout(), this.forgejo.getReadTimeout());
        List<org.jreleaser.model.spi.release.Release> releases = api.listReleases(owner, repo);
        VersionUtils.clearUnparseableTags();
        Pattern versionPattern = VersionUtils.resolveVersionPattern((JReleaserContext)this.context);
        for (org.jreleaser.model.spi.release.Release release : releases) {
            release.setVersion(VersionUtils.version((JReleaserContext)this.context, (String)release.getTagName(), (Pattern)versionPattern));
        }
        releases.sort((r1, r2) -> r2.getVersion().compareTo((Object)r1.getVersion()));
        return releases;
    }

    private void createRelease(Forgejo api, String tagName, String changelog, boolean deleteTags) throws IOException {
        if (this.context.isDryrun()) {
            for (org.jreleaser.model.spi.release.Asset asset : this.assets) {
                if (0L == Files.size(asset.getPath()) || !Files.exists(asset.getPath(), new LinkOption[0])) continue;
                this.context.getLogger().info(" " + RB.$((String)"git.upload.asset", (Object[])new Object[0]), new Object[]{asset.getFilename()});
            }
            this.updateIssues(this.forgejo, api);
            return;
        }
        if (deleteTags) {
            this.deleteTags(api, this.forgejo.getOwner(), this.forgejo.getName(), tagName);
        }
        if (deleteTags || !this.forgejo.isSkipTag()) {
            this.context.getLogger().debug(RB.$((String)"git.releaser.repository.tag", (Object[])new Object[0]), new Object[]{tagName, this.context.getModel().getCommit().getShortHash()});
            GitSdk.of((JReleaserContext)this.context).tag(tagName, true, this.context);
        }
        Release release = new Release();
        release.setName(this.forgejo.getEffectiveReleaseName());
        release.setTagName(tagName);
        release.setTargetCommitish(this.forgejo.getResolvedBranchPush(this.context.getModel()));
        release.setBody(changelog);
        if (this.forgejo.getPrerelease().isEnabledSet()) {
            release.setPrerelease(this.forgejo.getPrerelease().isEnabled());
        }
        if (this.forgejo.isDraftSet()) {
            release.setDraft(this.forgejo.isDraft());
        }
        release = api.createRelease(this.forgejo.getOwner(), this.forgejo.getName(), release);
        api.uploadAssets(this.forgejo.getOwner(), this.forgejo.getName(), release, this.assets);
        if (this.forgejo.getMilestone().isClose() && !this.context.getModel().getProject().isSnapshot()) {
            Optional<Milestone> milestone = api.findMilestoneByName(this.forgejo.getOwner(), this.forgejo.getName(), this.forgejo.getMilestone().getEffectiveName());
            milestone.ifPresent(m -> api.closeMilestone(this.forgejo.getOwner(), this.forgejo.getName(), (Milestone)m));
        }
        this.updateIssues(this.forgejo, api);
    }

    private void updateIssues(org.jreleaser.model.internal.release.ForgejoReleaser forgejo, Forgejo api) throws IOException {
        if (!forgejo.getIssues().isEnabled()) {
            return;
        }
        List issueNumbers = ChangelogProvider.getIssues((JReleaserContext)this.context);
        if (!issueNumbers.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"git.issue.release.mark", (Object[])new Object[]{issueNumbers.size()}));
        }
        if (this.context.isDryrun()) {
            for (String issueNumber : issueNumbers) {
                this.context.getLogger().debug(RB.$((String)"git.issue.release", (Object[])new Object[]{issueNumber}));
            }
            return;
        }
        String tagName = forgejo.getEffectiveTagName(this.context.getModel());
        String labelName = forgejo.getIssues().getLabel().getName();
        String labelColor = forgejo.getIssues().getLabel().getColor();
        TemplateContext props = forgejo.props(this.context.getModel());
        forgejo.fillProps(props, this.context.getModel());
        String comment = Templates.resolveTemplate((String)forgejo.getIssues().getComment(), (TemplateContext)props);
        if (labelColor.startsWith("#")) {
            labelColor = labelColor.substring(1);
        }
        Label label = null;
        try {
            label = api.getOrCreateLabel(forgejo.getOwner(), forgejo.getName(), labelName, labelColor, forgejo.getIssues().getLabel().getDescription());
        }
        catch (RestAPIException e) {
            throw new IllegalStateException(RB.$((String)"ERROR_git_releaser_fetch_label", (Object[])new Object[]{tagName, labelName}), e);
        }
        Optional<Object> milestone = Optional.empty();
        Apply applyMilestone = forgejo.getIssues().getApplyMilestone();
        if (forgejo.getMilestone().isClose() && !this.context.getModel().getProject().isSnapshot() && !(milestone = api.findMilestoneByName(forgejo.getOwner(), forgejo.getName(), forgejo.getMilestone().getEffectiveName())).isPresent()) {
            milestone = api.findClosedMilestoneByName(forgejo.getOwner(), forgejo.getName(), forgejo.getMilestone().getEffectiveName());
        }
        for (String issueNumber : issueNumbers) {
            Issue issue;
            Optional<Issue> op = api.findIssue(forgejo.getOwner(), forgejo.getName(), Integer.parseInt(issueNumber));
            if (!op.isPresent() || !"closed".equals((issue = op.get()).getState()) || !issue.getLabels().stream().noneMatch(l -> l.getName().equals(labelName))) continue;
            this.context.getLogger().debug(RB.$((String)"git.issue.release", (Object[])new Object[]{issueNumber}));
            api.addLabelToIssue(forgejo.getOwner(), forgejo.getName(), issue, label);
            api.commentOnIssue(forgejo.getOwner(), forgejo.getName(), issue, comment);
            milestone.ifPresent(m -> this.applyMilestone(forgejo, api, issueNumber, issue, applyMilestone, (Milestone)m));
        }
    }

    private void applyMilestone(org.jreleaser.model.internal.release.ForgejoReleaser forgejo, Forgejo api, String issueNumber, Issue issue, Apply applyMilestone, Milestone targetMilestone) {
        Milestone issueMilestone = issue.getMilestone();
        String targetMilestoneTitle = targetMilestone.getTitle();
        if (null == issueMilestone) {
            this.context.getLogger().debug(RB.$((String)"git.issue.milestone.apply", (Object[])new Object[]{targetMilestoneTitle, issueNumber}));
            api.setMilestoneOnIssue(forgejo.getOwner(), forgejo.getName(), issue, targetMilestone);
        } else {
            String milestoneTitle = issueMilestone.getTitle();
            if (applyMilestone == Apply.ALWAYS) {
                this.context.getLogger().debug(StringUtils.uncapitalize((String)RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle})));
            } else if (applyMilestone == Apply.WARN) {
                if (!milestoneTitle.equals(targetMilestoneTitle)) {
                    this.context.getLogger().warn(RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle}));
                }
            } else if (applyMilestone == Apply.FORCE) {
                if (!milestoneTitle.equals(targetMilestoneTitle)) {
                    this.context.getLogger().warn(RB.$((String)"git.issue.milestone.force", (Object[])new Object[]{targetMilestoneTitle, issueNumber, milestoneTitle}));
                    api.setMilestoneOnIssue(forgejo.getOwner(), forgejo.getName(), issue, targetMilestone);
                } else {
                    this.context.getLogger().debug(StringUtils.uncapitalize((String)RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle})));
                }
            }
        }
    }

    private void updateAssets(Forgejo api, Release release) throws IOException {
        TreeSet<org.jreleaser.model.spi.release.Asset> assetsToBeUpdated = new TreeSet<org.jreleaser.model.spi.release.Asset>();
        TreeSet<org.jreleaser.model.spi.release.Asset> assetsToBeUploaded = new TreeSet<org.jreleaser.model.spi.release.Asset>();
        Map<String, Asset> existingAssets = api.listAssets(this.forgejo.getOwner(), this.forgejo.getName(), release);
        LinkedHashMap assetsToBePublished = new LinkedHashMap();
        this.assets.forEach(asset -> assetsToBePublished.put(asset.getFilename(), asset));
        assetsToBePublished.keySet().forEach(name -> {
            if (existingAssets.containsKey(name)) {
                assetsToBeUpdated.add((org.jreleaser.model.spi.release.Asset)assetsToBePublished.get(name));
            } else {
                assetsToBeUploaded.add((org.jreleaser.model.spi.release.Asset)assetsToBePublished.get(name));
            }
        });
        api.updateAssets(this.forgejo.getOwner(), this.forgejo.getName(), release, assetsToBeUpdated, existingAssets);
        api.uploadAssets(this.forgejo.getOwner(), this.forgejo.getName(), release, assetsToBeUploaded);
    }

    private void deleteTags(Forgejo api, String owner, String repo, String tagName) {
        try {
            api.deleteTag(owner, repo, tagName);
        }
        catch (RestAPIException restAPIException) {
            // empty catch block
        }
    }
}

