/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.github;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import feign.Client;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormData;
import feign.form.FormEncoder;
import feign.httpclient.ApacheHttpClient;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.spi.release.Asset;
import org.jreleaser.model.spi.release.Release;
import org.jreleaser.model.spi.release.User;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.github.api.GhAsset;
import org.jreleaser.sdk.github.api.GhAttachment;
import org.jreleaser.sdk.github.api.GhBranch;
import org.jreleaser.sdk.github.api.GhDiscussion;
import org.jreleaser.sdk.github.api.GhIssue;
import org.jreleaser.sdk.github.api.GhLabel;
import org.jreleaser.sdk.github.api.GhMilestone;
import org.jreleaser.sdk.github.api.GhOrganization;
import org.jreleaser.sdk.github.api.GhPackageVersion;
import org.jreleaser.sdk.github.api.GhRelease;
import org.jreleaser.sdk.github.api.GhReleaseNotes;
import org.jreleaser.sdk.github.api.GhReleaseNotesParams;
import org.jreleaser.sdk.github.api.GhRepository;
import org.jreleaser.sdk.github.api.GhSearchUser;
import org.jreleaser.sdk.github.api.GhTag;
import org.jreleaser.sdk.github.api.GhUser;
import org.jreleaser.sdk.github.api.GithubAPI;
import org.jreleaser.sdk.github.internal.Page;
import org.jreleaser.sdk.github.internal.PaginatingDecoder;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;

class Github {
    private static final String USERS_NOREPLY_GITHUB_COM = "@users.noreply.github.com";
    private static final String ENDPOINT = "https://api.github.com";
    private static final String GITHUB_API_VERSION = "2022-11-28";
    private static final String GITHUB_MIME_TYPE = "application/vnd.github+json";
    private final JReleaserContext context;
    private final ObjectMapper objectMapper;
    private final GithubAPI api;
    private final String token;
    private final int connectTimeout;
    private final int readTimeout;

    Github(JReleaserContext context, String token, int connectTimeout, int readTimeout) {
        this(context, ENDPOINT, token, connectTimeout, readTimeout);
    }

    Github(JReleaserContext context, String endpoint, String token, int connectTimeout, int readTimeout) {
        this.context = Objects.requireNonNull(context, "'context' must not be null");
        this.token = StringUtils.requireNonBlank((String)token, (String)"'token' must not be blank");
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        StringUtils.requireNonBlank((String)endpoint, (String)"'endpoint' must not be blank");
        if (endpoint.endsWith("/")) {
            endpoint = endpoint.substring(0, endpoint.length() - 1);
        }
        this.objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true);
        this.api = (GithubAPI)ClientUtils.builder((JReleaserContext)context, (int)connectTimeout, (int)readTimeout).client((Client)new ApacheHttpClient()).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(this.objectMapper))).decoder((Decoder)new PaginatingDecoder((Decoder)new JacksonDecoder(this.objectMapper))).requestInterceptor(template -> {
            template.header("Accept", new String[]{GITHUB_MIME_TYPE});
            template.header("X-GitHub-Api-Version", new String[]{GITHUB_API_VERSION});
            template.header("Authorization", new String[]{String.format("Bearer %s", token)});
        }).target(GithubAPI.class, endpoint);
    }

    GhRepository findRepository(String owner, String repo) {
        this.context.getLogger().debug(RB.$((String)"git.repository.lookup", (Object[])new Object[0]), new Object[]{owner, repo});
        try {
            return this.api.getRepository(owner, repo);
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return null;
            }
            throw e;
        }
    }

    List<Release> listReleases(String owner, String repoName) {
        this.context.getLogger().debug(RB.$((String)"git.list.releases", (Object[])new Object[0]), new Object[]{owner, repoName});
        ArrayList<Release> releases = new ArrayList<Release>();
        int pageCount = 0;
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("draft", false);
        params.put("prerelease", false);
        params.put("per_page", 20);
        boolean consume = true;
        do {
            params.put("page", ++pageCount);
            Page<List<GhRelease>> page = this.api.listReleases(owner, repoName, params);
            page.getContent().stream().map(r -> new Release(r.getName(), r.getTagName(), r.getHtmlUrl(), r.getPublishedAt())).forEach(releases::add);
            if (page.hasLinks() && page.getLinks().hasNext()) continue;
            consume = false;
        } while (consume);
        return releases;
    }

    List<String> listBranches(String owner, String repoName) {
        this.context.getLogger().debug(RB.$((String)"git.list.branches", (Object[])new Object[0]), new Object[]{owner, repoName});
        ArrayList<String> branches = new ArrayList<String>();
        int pageCount = 0;
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("per_page", 20);
        boolean consume = true;
        do {
            params.put("page", ++pageCount);
            Page<List<GhBranch>> page = this.api.listBranches(owner, repoName, params);
            page.getContent().stream().map(GhBranch::getName).forEach(branches::add);
            if (page.hasLinks() && page.getLinks().hasNext()) continue;
            consume = false;
        } while (consume);
        return branches;
    }

    Map<String, GhAsset> listAssets(String owner, String repo, GhRelease release) {
        this.context.getLogger().debug(RB.$((String)"git.list.assets.github", (Object[])new Object[0]), new Object[]{owner, repo, release.getId()});
        LinkedHashMap<String, GhAsset> assets = new LinkedHashMap<String, GhAsset>();
        for (GhAsset asset : this.api.listAssets(owner, repo, release.getId())) {
            assets.put(asset.getName(), asset);
        }
        return assets;
    }

    List<GhMilestone> listMilestones(String owner, String repoName, String state) {
        this.context.getLogger().debug(RB.$((String)"git.list.milestones", (Object[])new Object[0]), new Object[]{owner, repoName, state});
        ArrayList<GhMilestone> milestones = new ArrayList<GhMilestone>();
        int pageCount = 0;
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("state", state);
        params.put("per_page", 20);
        boolean consume = true;
        do {
            params.put("page", ++pageCount);
            Page<List<GhMilestone>> page = this.api.listMilestones(owner, repoName, params);
            milestones.addAll((Collection)page.getContent());
            if (page.hasLinks() && page.getLinks().hasNext()) continue;
            consume = false;
        } while (consume);
        return milestones;
    }

    Optional<GhMilestone> findMilestoneByName(String owner, String repo, String milestoneName) {
        this.context.getLogger().debug(RB.$((String)"git.milestone.lookup", (Object[])new Object[0]), new Object[]{milestoneName, owner, repo});
        return this.findMilestone(owner, repo, milestoneName, "open");
    }

    Optional<GhMilestone> findClosedMilestoneByName(String owner, String repo, String milestoneName) {
        this.context.getLogger().debug(RB.$((String)"git.milestone.lookup.closed", (Object[])new Object[0]), new Object[]{milestoneName, owner, repo});
        return this.findMilestone(owner, repo, milestoneName, "closed");
    }

    private Optional<GhMilestone> findMilestone(String owner, String repo, String milestoneName, String state) {
        return this.listMilestones(owner, repo, state).stream().filter(m -> milestoneName.equals(m.getTitle())).findFirst();
    }

    void closeMilestone(String owner, String repo, GhMilestone milestone) {
        this.context.getLogger().debug(RB.$((String)"git.milestone.close", (Object[])new Object[0]), new Object[]{milestone.getTitle(), owner, repo});
        this.api.updateMilestone((Map<String, Object>)CollectionUtils.map().e((Object)"state", (Object)"closed"), owner, repo, milestone.getNumber());
    }

    GhRepository createRepository(String owner, String repo) {
        this.context.getLogger().debug(RB.$((String)"git.repository.create", (Object[])new Object[0]), new Object[]{owner, repo});
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("name", repo);
        params.put("private", false);
        GhOrganization organization = this.resolveOrganization(owner);
        if (null != organization) {
            return this.api.createRepository(params, owner);
        }
        return this.api.createRepository(params);
    }

    List<GhTag> listTags(String owner, String repoName) {
        this.context.getLogger().debug(RB.$((String)"git.list.milestones", (Object[])new Object[0]), new Object[]{owner, repoName});
        ArrayList<GhTag> tags = new ArrayList<GhTag>();
        int pageCount = 0;
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("per_page", 20);
        boolean consume = true;
        do {
            params.put("page", ++pageCount);
            Page<List<GhTag>> page = this.api.listTags(owner, repoName, params);
            tags.addAll((Collection)page.getContent());
            if (page.hasLinks() && page.getLinks().hasNext()) continue;
            consume = false;
        } while (consume);
        return tags;
    }

    GhRelease findReleaseByTag(String owner, String repo, String tagName) {
        this.context.getLogger().debug(RB.$((String)"git.fetch.release.by.tag", (Object[])new Object[0]), new Object[]{owner, repo, tagName});
        try {
            return this.api.getReleaseByTagName(owner, repo, tagName);
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return null;
            }
            throw e;
        }
    }

    GhRelease findReleaseById(String owner, String repo, Long id) {
        this.context.getLogger().debug(RB.$((String)"git.fetch.release.by.id", (Object[])new Object[0]), new Object[]{owner, repo, id});
        return this.api.getRelease(owner, repo, id);
    }

    void deleteTag(String owner, String repo, String tagName) throws RestAPIException {
        block2: {
            this.context.getLogger().debug(RB.$((String)"git.delete.tag.from", (Object[])new Object[0]), new Object[]{tagName, owner, repo});
            try {
                this.api.deleteTag(owner, repo, tagName);
            }
            catch (RestAPIException e) {
                if (!e.isNotFound()) break block2;
                this.context.getLogger().debug(RB.$((String)"git.tag.not.exist", (Object[])new Object[0]), new Object[]{tagName});
            }
        }
    }

    GhRelease createRelease(String owner, String repo, GhRelease release) throws RestAPIException {
        this.context.getLogger().debug(RB.$((String)"git.create.release", (Object[])new Object[0]), new Object[]{owner, repo, release.getTagName()});
        return this.api.createRelease(release, owner, repo);
    }

    void updateRelease(String owner, String repo, Long id, GhRelease release) throws RestAPIException {
        this.context.getLogger().debug(RB.$((String)"git.update.release", (Object[])new Object[0]), new Object[]{owner, repo, release.getTagName()});
        this.api.updateRelease(release, owner, repo, id);
    }

    void deleteRelease(String owner, String repo, String tagName, Long id) throws RestAPIException {
        this.context.getLogger().debug(RB.$((String)"git.delete.release.from.id", (Object[])new Object[0]), new Object[]{tagName, owner, repo, id});
        try {
            this.api.deleteRelease(owner, repo, id);
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return;
            }
            throw e;
        }
    }

    void uploadAssets(GhRelease release, Set<Asset> assets) throws IOException {
        for (Asset asset : assets) {
            if (0L == Files.size(asset.getPath()) || !Files.exists(asset.getPath(), new LinkOption[0])) continue;
            this.uploadOrUpdateAsset(asset, release, "git.upload.asset", "git.upload.asset.failure");
        }
    }

    void updateAssets(String owner, String repo, GhRelease release, Set<Asset> assets, Map<String, GhAsset> existingAssets) throws IOException {
        for (Asset asset : assets) {
            if (0L == Files.size(asset.getPath()) || !Files.exists(asset.getPath(), new LinkOption[0])) continue;
            this.context.getLogger().debug(" " + RB.$((String)"git.delete.asset", (Object[])new Object[0]), new Object[]{asset.getFilename()});
            try {
                this.api.deleteAsset(owner, repo, existingAssets.get(asset.getFilename()).getId());
            }
            catch (RestAPIException e) {
                this.context.getLogger().error(" " + RB.$((String)"git.delete.asset.failure", (Object[])new Object[0]), new Object[]{asset.getFilename()});
                throw e;
            }
            this.uploadOrUpdateAsset(asset, release, "git.update.asset", "git.update.asset.failure");
        }
    }

    private void uploadOrUpdateAsset(Asset asset, GhRelease release, String operationMessageKey, String operationErrorMessageKey) throws IOException {
        this.context.getLogger().info(" " + RB.$((String)operationMessageKey, (Object[])new Object[0]), new Object[]{asset.getFilename()});
        try {
            URI uri;
            GhAttachment attachment;
            String uploadUrl = release.getUploadUrl();
            if (uploadUrl.endsWith("{?name,label}")) {
                uploadUrl = uploadUrl.substring(0, uploadUrl.length() - 13);
            }
            if (!"uploaded".equalsIgnoreCase((attachment = this.uploadAsset(uri = new URI(uploadUrl + "?name=" + asset.getFilename()), ClientUtils.toFormData((Path)asset.getPath()))).getState())) {
                this.context.getLogger().warn(" " + RB.$((String)operationErrorMessageKey, (Object[])new Object[0]), new Object[]{asset.getFilename()});
            }
        }
        catch (URISyntaxException shouldNeverHappen) {
            this.context.getLogger().error(" " + RB.$((String)operationErrorMessageKey, (Object[])new Object[0]), new Object[]{asset.getFilename()});
            throw new IllegalStateException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), shouldNeverHappen);
        }
        catch (RestAPIException e) {
            this.context.getLogger().error(" " + RB.$((String)operationErrorMessageKey, (Object[])new Object[0]), new Object[]{asset.getFilename()});
            throw e;
        }
        catch (UploadException e) {
            this.context.getLogger().error(" " + RB.$((String)operationErrorMessageKey, (Object[])new Object[0]), new Object[]{asset.getFilename()});
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    private GhAttachment uploadAsset(URI uri, FormData data) throws UploadException, IOException {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put("Accept", GITHUB_MIME_TYPE);
        headers.put("X-GitHub-Api-Version", GITHUB_API_VERSION);
        headers.put("Authorization", String.format("Bearer %s", this.token));
        Reader reader = ClientUtils.postFile((JReleaserLogger)this.context.getLogger(), (URI)uri, (int)this.connectTimeout, (int)this.readTimeout, (FormData)data, headers);
        return (GhAttachment)this.objectMapper.readValue(reader, GhAttachment.class);
    }

    Optional<GhDiscussion> findDiscussion(String organization, String team, String title) {
        return this.listDiscussions(organization, team).stream().filter(d -> title.equals(d.getTitle())).findFirst();
    }

    List<GhDiscussion> listDiscussions(String organization, String team) {
        this.context.getLogger().debug(RB.$((String)"git.list.discussions", (Object[])new Object[0]), new Object[]{organization, team});
        ArrayList<GhDiscussion> discussions = new ArrayList<GhDiscussion>();
        int pageCount = 0;
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("per_page", 20);
        boolean consume = true;
        do {
            params.put("page", ++pageCount);
            Page<List<GhDiscussion>> page = this.api.listDiscussions(organization, team, params);
            discussions.addAll((Collection)page.getContent());
            if (page.hasLinks() && page.getLinks().hasNext()) continue;
            consume = false;
        } while (consume);
        return discussions;
    }

    void createDiscussion(String organization, String team, String title, String message) {
        this.context.getLogger().debug(RB.$((String)"git.releaser.discussion.create", (Object[])new Object[0]), new Object[]{title});
        GhDiscussion discussion = new GhDiscussion();
        discussion.setTitle(title);
        discussion.setBody(message);
        this.api.createDiscussion(discussion, organization, team);
    }

    GhLabel getOrCreateLabel(String owner, String name, String labelName, String labelColor, String description) {
        this.context.getLogger().debug(RB.$((String)"git.label.fetch", (Object[])new Object[]{labelName}));
        List<GhLabel> labels = this.listLabels(owner, name);
        Optional<GhLabel> label = labels.stream().filter(l -> l.getName().equals(labelName)).findFirst();
        if (label.isPresent()) {
            return label.get();
        }
        this.context.getLogger().debug(RB.$((String)"git.label.create", (Object[])new Object[]{labelName}));
        return this.api.createLabel(owner, name, labelName, labelColor, description);
    }

    public Optional<GhIssue> findIssue(String owner, String name, int issueNumber) {
        this.context.getLogger().debug(RB.$((String)"git.issue.fetch", (Object[])new Object[]{issueNumber}));
        try {
            return Optional.of(this.api.findIssue(owner, name, issueNumber));
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return Optional.empty();
            }
            throw e;
        }
    }

    void addLabelToIssue(String owner, String name, GhIssue issue, GhLabel label) {
        this.context.getLogger().debug(RB.$((String)"git.issue.label", (Object[])new Object[]{label.getName(), issue.getNumber()}));
        LinkedHashMap<String, List<String>> labels = new LinkedHashMap<String, List<String>>();
        List list = labels.computeIfAbsent("labels", k -> new ArrayList());
        list.addAll(issue.getLabels().stream().map(GhLabel::getName).collect(Collectors.toList()));
        list.add(label.getName());
        this.api.labelIssue(labels, owner, name, issue.getNumber());
    }

    void commentOnIssue(String owner, String name, GhIssue issue, String comment) {
        this.context.getLogger().debug(RB.$((String)"git.issue.comment", (Object[])new Object[]{issue.getNumber()}));
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("body", comment);
        this.api.commentIssue(params, owner, name, issue.getNumber());
    }

    void setMilestoneOnIssue(String owner, String name, GhIssue issue, GhMilestone milestone) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("milestone", milestone.getNumber());
        this.api.updateIssue(params, owner, name, issue.getNumber());
    }

    private List<GhLabel> listLabels(String owner, String repoName) {
        this.context.getLogger().debug(RB.$((String)"git.list.labels", (Object[])new Object[0]), new Object[]{owner, repoName});
        ArrayList<GhLabel> labels = new ArrayList<GhLabel>();
        int pageCount = 0;
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("limit", 20);
        boolean consume = true;
        do {
            params.put("page", ++pageCount);
            Page<List<GhLabel>> page = this.api.listLabels(owner, repoName, params);
            labels.addAll((Collection)page.getContent());
            if (page.hasLinks() && page.getLinks().hasNext()) continue;
            consume = false;
        } while (consume);
        return labels;
    }

    private GhOrganization resolveOrganization(String name) {
        try {
            return this.api.getOrganization(name);
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return null;
            }
            throw e;
        }
    }

    void updateRelease(String owner, String repo, String tag, Long id, GhRelease release) throws RestAPIException {
        this.context.getLogger().debug(RB.$((String)"git.update.release", (Object[])new Object[0]), new Object[]{owner, repo, tag});
        this.api.updateRelease(release, owner, repo, id);
    }

    private String getPrivateEmailUserId(String email) {
        if (!email.endsWith(USERS_NOREPLY_GITHUB_COM)) {
            return null;
        }
        String username = email.substring(0, email.indexOf("@"));
        if (username.contains("+")) {
            username = username.substring(username.indexOf("+") + 1);
        }
        return username;
    }

    Optional<User> findUser(String email, String name) throws RestAPIException {
        GhUser user;
        this.context.getLogger().debug(RB.$((String)"git.user.lookup", (Object[])new Object[0]), new Object[]{name, email});
        String username = this.getPrivateEmailUserId(email);
        if (null != username && null != (user = this.api.getUser(username))) {
            return Optional.of(new User(user.getLogin(), email, user.getHtmlUrl()));
        }
        GhSearchUser search = this.api.searchUser(CollectionUtils.mapOf((Object[])new Object[]{"q", email}));
        if (search.getTotalCount() > 0) {
            GhUser user2 = search.getItems().get(0);
            return Optional.of(new User(user2.getLogin(), email, user2.getHtmlUrl()));
        }
        return Optional.empty();
    }

    GhReleaseNotes generateReleaseNotes(String owner, String repo, GhReleaseNotesParams params) throws RestAPIException {
        this.context.getLogger().info(RB.$((String)"github.generate.release.notes", (Object[])new Object[0]), new Object[]{owner, repo, params.getPreviousTagName(), params.getTagName()});
        return this.api.generateReleaseNotes(params, owner, repo);
    }

    List<GhPackageVersion> listPackageVersions(String packageType, String packageName) throws IOException {
        this.context.getLogger().debug(RB.$((String)"github.list.versions", (Object[])new Object[0]), new Object[]{packageType, packageName});
        ArrayList<GhPackageVersion> issues = new ArrayList<GhPackageVersion>();
        Page<List<GhPackageVersion>> page = this.api.listPackageVersions0(packageType, packageName);
        issues.addAll((Collection)page.getContent());
        if (page.hasLinks() && page.getLinks().hasNext()) {
            try {
                this.collectPackageVersions(page, issues);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return issues;
    }

    private void collectPackageVersions(Page<List<GhPackageVersion>> page, List<GhPackageVersion> issues) throws URISyntaxException {
        URI next = new URI(page.getLinks().next());
        this.context.getLogger().debug(next.toString());
        page = this.api.listPackageVersions1(next);
        issues.addAll((Collection<GhPackageVersion>)page.getContent());
        if (page.hasLinks() && page.getLinks().hasNext()) {
            this.collectPackageVersions(page, issues);
        }
    }

    void deletePackageVersion(String packageType, String packageName, String packageVersion) throws RestAPIException {
        this.context.getLogger().debug(RB.$((String)"github.delete.package.version", (Object[])new Object[0]), new Object[]{packageVersion, packageName});
        this.api.deletePackageVersion(packageType, packageName, packageVersion);
    }

    void deletePackage(String packageType, String packageName) throws RestAPIException {
        this.context.getLogger().debug(RB.$((String)"github.delete.package", (Object[])new Object[0]), new Object[]{packageType, packageName});
        this.api.deletePackage(packageType, packageName);
    }
}

