/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.api.assemble.DebAssembler;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.Assembler;
import org.jreleaser.model.internal.assemble.DebAssembler;
import org.jreleaser.model.internal.assemble.JavaArchiveAssembler;
import org.jreleaser.model.internal.assemble.JavaAssembler;
import org.jreleaser.model.internal.assemble.JpackageAssembler;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.validation.assemble.AssemblersValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class DebAssemblerValidator {
    private DebAssemblerValidator() {
    }

    public static void validateDeb(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, DebAssembler> deb = context.getModel().getAssemble().getDeb();
        if (!deb.isEmpty()) {
            context.getLogger().debug("assemble.deb");
        }
        for (Map.Entry<String, DebAssembler> e : deb.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateAssembly()) continue;
            DebAssemblerValidator.validateDeb(context, mode, e.getValue(), errors);
        }
    }

    private static void validateDeb(JReleaserContext context, JReleaserContext.Mode mode, DebAssembler assembler, Errors errors) {
        DebAssembler.Control control;
        context.getLogger().debug("assemble.deb.{}", new Object[]{assembler.getName()});
        Validator.resolveActivatable(context, (Activatable)assembler, CollectionUtils.listOf((Object[])new String[]{"assemble.deb." + assembler.getName(), "assemble.deb"}), "NEVER");
        Project project = context.getModel().getProject();
        if (!assembler.resolveEnabled(project)) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((String)assembler.getName())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"deb.name"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            assembler.disable();
            return;
        }
        assembler.setPlatform(assembler.getPlatform().mergeValues(context.getModel().getPlatform()));
        boolean assemblerRefIsOk = false;
        if (StringUtils.isNotBlank((String)assembler.getAssemblerRef())) {
            String assemblerRef = assembler.getAssemblerRef().trim();
            Assembler<?> otherAssembler = context.getModel().getAssemble().findAssembler(assemblerRef);
            if (otherAssembler == null) {
                errors.configuration(RB.$((String)"validation_not_configured", (Object[])new Object[]{"assemble.deb." + assembler.getName()}));
            } else if (!otherAssembler.isEnabled()) {
                errors.configuration(RB.$((String)"validation_is_disabled", (Object[])new Object[]{"assemble.deb." + assembler.getName()}));
            } else if (otherAssembler instanceof DebAssembler || otherAssembler instanceof JpackageAssembler) {
                errors.configuration(RB.$((String)"validation_is_invalid", (Object[])new Object[]{"assemble.deb." + assembler.getName() + ".assemblerRef", otherAssembler.getClass().getSimpleName()}));
            } else {
                assemblerRefIsOk = true;
            }
            if (otherAssembler instanceof JavaAssembler && StringUtils.isBlank((String)assembler.getExecutable())) {
                assembler.setExecutable(((JavaAssembler)otherAssembler).getExecutable());
            } else if (otherAssembler instanceof JavaArchiveAssembler && StringUtils.isBlank((String)assembler.getExecutable())) {
                assembler.setExecutable(((JavaArchiveAssembler)otherAssembler).getExecutable().resolveExecutable("linux"));
            } else if (StringUtils.isBlank((String)assembler.getExecutable())) {
                errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{"assemble.deb." + assembler.getName() + ".executable"}));
            }
        }
        if (!assemblerRefIsOk && assembler.getFileSets().isEmpty()) {
            errors.configuration(RB.$((String)"validation_deb_empty_fileset", (Object[])new Object[]{assembler.getName()}));
        }
        if (!assemblerRefIsOk && StringUtils.isBlank((String)assembler.getExecutable())) {
            assembler.setExecutable(assembler.getName());
        }
        if (StringUtils.isBlank((String)assembler.getAssemblerRef()) && StringUtils.isBlank((String)assembler.getArchitecture())) {
            errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{"assemble.deb." + assembler.getName() + ".architecture"}));
        }
        AssemblersValidator.validateAssembler(context, mode, assembler, errors);
        if (StringUtils.isBlank((String)assembler.getInstallationPath())) {
            assembler.setInstallationPath("/opt/{{packageName}}");
        }
        if (StringUtils.isBlank((String)(control = assembler.getControl()).getPackageName())) {
            control.setPackageName(assembler.getName());
        }
        if (StringUtils.isBlank((String)control.getPackageVersion())) {
            control.setPackageVersion(project.getResolvedVersion());
        }
        if (null == control.getPackageRevision()) {
            control.setPackageRevision(1);
        }
        if (control.getPackageRevision() < 0) {
            errors.configuration(RB.$((String)"validation_is_invalid", (Object[])new Object[]{"assemble.deb." + assembler.getName() + ".control.revision", control.getPackageRevision()}));
        }
        if (StringUtils.isBlank((String)control.getProvides())) {
            control.setProvides(control.getPackageName());
        }
        if (StringUtils.isBlank((String)control.getMaintainer())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"assemble.deb." + assembler.getName() + ".control.maintainer"}));
        }
        if (null == control.getSection()) {
            control.setSection(DebAssembler.Section.MISC);
        }
        if (null == control.getPriority()) {
            control.setPriority(DebAssembler.Priority.OPTIONAL);
        }
        if (!control.isEssentialSet().booleanValue()) {
            control.setEssential(false);
        }
    }

    public static void postValidateDeb(JReleaserContext context, Errors errors) {
        context.getLogger().debug("assemble.deb");
        for (DebAssembler assembler : context.getModel().getAssemble().getActiveDebs()) {
            DebAssemblerValidator.postValidateDeb(context, assembler, errors);
        }
    }

    private static void postValidateDeb(JReleaserContext context, DebAssembler assembler, Errors errors) {
        Project project = context.getModel().getProject();
        if (!assembler.resolveEnabled(project)) {
            return;
        }
        DebAssembler.Control control = assembler.getControl();
        if (StringUtils.isBlank((String)control.getDescription())) {
            control.setDescription(project.getLongDescription());
        }
        if (StringUtils.isBlank((String)control.getDescription())) {
            control.setDescription(project.getDescription());
        }
        if (StringUtils.isBlank((String)control.getHomepage())) {
            control.setHomepage(project.getLinks().getHomepage());
        }
    }
}

