/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Locale;
import org.jreleaser.util.StringUtils;

public enum Algorithm {
    MD2,
    MD5,
    RMD160,
    SHA_1,
    SHA_256,
    SHA_384,
    SHA_512,
    SHA3_224,
    SHA3_256,
    SHA3_384,
    SHA3_512;


    public String formatted() {
        if (this.name().startsWith("SHA3")) {
            return this.name().toLowerCase(Locale.ENGLISH).replace("_", "-");
        }
        return this.name().toLowerCase(Locale.ENGLISH).replace("_", "");
    }

    @JsonCreator
    public static Algorithm of(String str) {
        String value;
        if (StringUtils.isBlank(str)) {
            return null;
        }
        switch (value = str.toUpperCase(Locale.ENGLISH).trim().replace("-", "_")) {
            case "SHA1": {
                return SHA_1;
            }
            case "SHA256": {
                return SHA_256;
            }
            case "SHA384": {
                return SHA_384;
            }
            case "SHA512": {
                return SHA_512;
            }
        }
        return Algorithm.valueOf(value);
    }
}

