/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.nexus2;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import dev.failsafe.function.CheckedPredicate;
import dev.failsafe.function.CheckedSupplier;
import feign.FeignException;
import feign.RequestInterceptor;
import feign.Response;
import feign.RetryableException;
import feign.Util;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.form.FormData;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.nexus2.Nexus2Exception;
import org.jreleaser.sdk.nexus2.api.Data;
import org.jreleaser.sdk.nexus2.api.NexusAPI;
import org.jreleaser.sdk.nexus2.api.NexusAPIException;
import org.jreleaser.sdk.nexus2.api.PromoteRequest;
import org.jreleaser.sdk.nexus2.api.StagedRepository;
import org.jreleaser.sdk.nexus2.api.StagingActivity;
import org.jreleaser.sdk.nexus2.api.StagingProfile;
import org.jreleaser.sdk.nexus2.api.StagingProfileRepository;
import org.jreleaser.util.StringUtils;

public class Nexus2 {
    private final JReleaserContext context;
    private final NexusAPI api;
    private final boolean dryrun;
    private final String apiHost;
    private final String username;
    private final String password;
    private final int connectTimeout;
    private final int readTimeout;
    private final Retrier retrier;

    public Nexus2(JReleaserContext context, String apiHost, String username, String password, int connectTimeout, int readTimeout, boolean dryrun, int transitionDelay, int transitionMaxRetries) {
        Objects.requireNonNull(context, "'context' must not be blank");
        StringUtils.requireNonBlank((String)apiHost, (String)"'apiHost' must not be blank");
        StringUtils.requireNonBlank((String)username, (String)"'username' must not be blank");
        StringUtils.requireNonBlank((String)password, (String)"'password' must not be blank");
        this.context = context;
        this.dryrun = dryrun;
        this.apiHost = apiHost;
        this.username = username;
        this.password = password;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.retrier = new Retrier(context.getLogger(), transitionDelay, transitionMaxRetries);
        this.api = (NexusAPI)ClientUtils.builder((JReleaserContext)context, (int)connectTimeout, (int)readTimeout).encoder((Encoder)new JacksonEncoder()).decoder((Decoder)new ContentNegotiationDecoder()).requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor(username, password)).errorDecoder((ErrorDecoder)new NexusErrorDecoder(context.getLogger())).target(NexusAPI.class, apiHost);
    }

    public String findStagingProfileId(String groupId) throws Nexus2Exception {
        return this.wrapNoDryrun(() -> {
            Data<List<StagingProfile>> data = this.api.getStagingProfiles();
            if (null == data || null == data.getData() || data.getData().isEmpty()) {
                throw this.fail(RB.$((String)"ERROR_nexus_find_staging_profile", (Object[])new Object[]{groupId}));
            }
            return data.getData().stream().filter(profile -> groupId.startsWith(profile.getName()) && (groupId.length() == profile.getName().length() || groupId.charAt(profile.getName().length()) == '.')).max(Comparator.comparingInt(profile -> profile.getName().length())).map(StagingProfile::getId).orElseThrow(() -> this.fail(RB.$((String)"ERROR_nexus_find_staging_profile", (Object[])new Object[]{groupId})));
        });
    }

    public List<StagingProfileRepository> findStagingProfileRepositories(String profileId, String groupId) throws Nexus2Exception {
        return this.wrap(() -> {
            Data<List<StagingProfileRepository>> data = this.api.getStagingProfileRepositories();
            if (null == data || null == data.getData()) {
                throw this.fail(RB.$((String)"ERROR_nexus_create_staging_repository", (Object[])new Object[]{groupId}));
            }
            return data.getData().stream().filter(r -> r.getProfileId().equals(profileId)).filter(r -> r.getProfileName().equals(groupId)).sorted(Comparator.comparing(StagingProfileRepository::getUpdated).reversed()).collect(Collectors.toList());
        });
    }

    public String createStagingRepository(String profileId, String groupId) throws Nexus2Exception {
        this.context.getLogger().debug(RB.$((String)"nexus.create.staging.repository2", (Object[])new Object[]{groupId, profileId}));
        return this.wrap(() -> {
            Data<StagedRepository> data = this.api.startStagingRepository(new Data<PromoteRequest>(PromoteRequest.ofDescription("Staging repository for " + groupId)), profileId);
            if (null == data || null == data.getData()) {
                throw this.fail(RB.$((String)"ERROR_nexus_create_staging_repository", (Object[])new Object[]{groupId}));
            }
            return data.getData().getStagedRepositoryId();
        });
    }

    public void dropStagingRepository(String profileId, String stagingRepositoryId, String groupId) throws Nexus2Exception {
        this.context.getLogger().debug(StringUtils.uncapitalize((String)RB.$((String)"nexus.drop.repository", (Object[])new Object[]{stagingRepositoryId})));
        this.wrap(() -> {
            this.api.dropStagingRepository(new Data<PromoteRequest>(PromoteRequest.of(stagingRepositoryId, "Staging repository for " + groupId)), profileId);
            this.waitForState(stagingRepositoryId, "drop", StagingProfileRepository.State.NOT_FOUND);
        });
    }

    public void releaseStagingRepository(String profileId, String stagingRepositoryId, String groupId) throws Nexus2Exception {
        this.wrap(() -> {
            this.api.releaseStagingRepository(new Data<PromoteRequest>(PromoteRequest.of(stagingRepositoryId, "Staging repository for " + groupId)), profileId);
            this.waitForState(stagingRepositoryId, "release", StagingProfileRepository.State.RELEASED, StagingProfileRepository.State.NOT_FOUND);
        });
    }

    public void closeStagingRepository(String profileId, String stagingRepositoryId, String groupId) throws Nexus2Exception {
        this.wrap(() -> {
            this.api.closeStagingRepository(new Data<PromoteRequest>(PromoteRequest.of(stagingRepositoryId, "Staging repository for " + groupId)), profileId);
            this.waitForState(stagingRepositoryId, "close", StagingProfileRepository.State.CLOSED);
        });
    }

    private void waitForState(String stagingRepositoryId, String activity, StagingProfileRepository.State ... states) throws Nexus2Exception {
        this.context.getLogger().debug(RB.$((String)"nexus.wait.repository.state", (Object[])new Object[]{stagingRepositoryId, Arrays.asList(states)}));
        StagingProfileRepository repository = (StagingProfileRepository)this.retrier.retry(StagingProfileRepository::isTransitioning, () -> this.getStagingRepository(stagingRepositoryId));
        if (repository.isTransitioning()) {
            throw new IllegalStateException(RB.$((String)"nexus.wait.repository.transitioning", (Object[])new Object[]{stagingRepositoryId}));
        }
        if (Arrays.binarySearch((Object[])states, (Object)repository.getState()) < 0) {
            Set<String> messages = this.resolveActivityMessages(stagingRepositoryId, activity);
            String title = RB.$((String)"nexus.wait.repository.invalid.state", (Object[])new Object[]{stagingRepositoryId, Arrays.asList(states), repository.getState()});
            throw new Nexus2Exception(title + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), messages));
        }
    }

    private Set<String> resolveActivityMessages(String stagingRepositoryId, String activityName) throws Nexus2Exception {
        List<StagingActivity> data = this.api.getActivities(stagingRepositoryId);
        if (null == data || data.isEmpty()) {
            throw this.fail(RB.$((String)"ERROR_nexus_find_staging_activities", (Object[])new Object[]{stagingRepositoryId}));
        }
        Optional<StagingActivity> activity = data.stream().filter(a -> activityName.equals(a.getName())).findFirst();
        if (!activity.isPresent()) {
            throw this.fail(RB.$((String)"ERROR_nexus_find_staging_activity", (Object[])new Object[]{activityName, stagingRepositoryId}));
        }
        LinkedHashSet<String> messages = new LinkedHashSet<String>();
        for (StagingActivity.StagingActivityEvent event : activity.get().getEvents()) {
            if (!event.getName().endsWith("Failed")) continue;
            for (StagingActivity.StagingProperty property : event.getProperties()) {
                if (!"failureMessage".equals(property.getName()) && !"cause".equals(property.getName())) continue;
                messages.add(property.getValue());
            }
        }
        return messages;
    }

    private StagingProfileRepository getStagingRepository(String stagingRepositoryId) {
        this.context.getLogger().debug(RB.$((String)"nexus.get.staging.repository", (Object[])new Object[]{stagingRepositoryId}));
        try {
            return this.api.getStagingRepository(stagingRepositoryId);
        }
        catch (NexusAPIException apiException) {
            if (apiException.isNotFound()) {
                return StagingProfileRepository.notFound(stagingRepositoryId);
            }
            throw apiException;
        }
    }

    public void deploy(String stagingRepositoryId, String path, Path file) throws Nexus2Exception {
        String filename = file.getFileName().toString();
        this.context.getLogger().debug(" - " + RB.$((String)"nexus.deploy.artifact", (Object[])new Object[]{filename, path, filename}));
        try {
            FormData data = ClientUtils.toFormData((Path)file);
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
            String auth = this.username + ":" + this.password;
            byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.UTF_8));
            auth = new String(encodedAuth, StandardCharsets.UTF_8);
            headers.put("Authorization", "Basic " + auth);
            StringBuilder url = new StringBuilder(this.apiHost);
            if (StringUtils.isNotBlank((String)stagingRepositoryId)) {
                url.append("staging/deployByRepositoryId/").append(stagingRepositoryId);
            }
            if (!path.startsWith("/")) {
                url.append("/");
            }
            url.append(path).append("/").append(filename);
            ClientUtils.putFile((JReleaserLogger)this.context.getLogger(), (String)url.toString(), (int)this.connectTimeout, (int)this.readTimeout, (FormData)data, headers);
        }
        catch (IOException | UploadException e) {
            this.context.getLogger().error(" x {}", new Object[]{filename, e});
            throw this.fail(RB.$((String)"ERROR_nexus_deploy_artifact", (Object[])new Object[]{filename}), (Exception)e);
        }
    }

    private Nexus2Exception fail(String message) {
        return new Nexus2Exception(message);
    }

    private Nexus2Exception fail(String message, Exception e) {
        return new Nexus2Exception(message, e);
    }

    private void wrap(NexusOperation operation) throws Nexus2Exception {
        try {
            if (!this.dryrun) {
                operation.execute();
            }
        }
        catch (Nexus2Exception e) {
            this.context.getLogger().trace((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new Nexus2Exception(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), e);
        }
    }

    private <T> T wrap(Callable<T> callable) throws Nexus2Exception {
        try {
            if (!this.dryrun) {
                return callable.call();
            }
            return null;
        }
        catch (Nexus2Exception e) {
            this.context.getLogger().trace((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.context.getLogger().trace((Throwable)e);
            throw new Nexus2Exception(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), e);
        }
    }

    private <T> T wrapNoDryrun(Callable<T> callable) throws Nexus2Exception {
        try {
            return callable.call();
        }
        catch (Nexus2Exception e) {
            this.context.getLogger().trace((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.context.getLogger().trace((Throwable)e);
            throw new Nexus2Exception(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), e);
        }
    }

    public static class Retrier {
        private final JReleaserLogger logger;
        private final int delay;
        private final int maxRetries;

        public Retrier(JReleaserLogger logger, int delay, int maxRetries) {
            this.logger = logger;
            this.delay = delay;
            this.maxRetries = maxRetries;
        }

        public <R> R retry(CheckedPredicate<R> stopFunction, CheckedSupplier<R> retriableOperation) {
            int maxAttempts = this.maxRetries + 1;
            RetryPolicy policy = ((RetryPolicyBuilder)((RetryPolicyBuilder)RetryPolicy.builder().handle(new Class[]{IllegalStateException.class, NexusAPIException.class})).handleResultIf(stopFunction)).withDelay(Duration.ofSeconds(this.delay)).withMaxRetries(this.maxRetries).onFailedAttempt(event -> {
                this.logger.info(RB.$((String)"nexus.retry.attempt", (Object[])new Object[0]), new Object[]{event.getAttemptCount(), maxAttempts});
                this.logger.debug(RB.$((String)"nexus.retry.failed.attempt", (Object[])new Object[0]), new Object[]{event.getAttemptCount(), maxAttempts, event.getLastResult()});
            }).build();
            return (R)Failsafe.with((Policy)policy, (Policy[])new RetryPolicy[0]).get(retriableOperation);
        }
    }

    static class ContentNegotiationDecoder
    implements Decoder {
        private final XmlDecoder xml = new XmlDecoder((XmlMapper)new XmlMapper().registerModule((Module)new JavaTimeModule()));
        private final JacksonDecoder json = new JacksonDecoder(new ObjectMapper().registerModule((Module)new JavaTimeModule()));

        ContentNegotiationDecoder() {
        }

        public Object decode(Response response, Type type) throws IOException, FeignException {
            try {
                return this.xml.decode(response, type);
            }
            catch (NotXml e) {
                return this.json.decode(response, type);
            }
        }
    }

    static class NexusErrorDecoder
    implements ErrorDecoder {
        private final ErrorDecoder defaultErrorDecoder = new ErrorDecoder.Default();
        private final JReleaserLogger logger;

        public NexusErrorDecoder(JReleaserLogger logger) {
            this.logger = logger;
        }

        public Exception decode(String methodKey, Response response) {
            Exception exception = this.defaultErrorDecoder.decode(methodKey, response);
            if (exception instanceof RetryableException) {
                return exception;
            }
            if (response.status() >= 500) {
                this.logger.trace(response.request().httpMethod() + " " + response.request().url());
                this.logger.trace(response.status() + " " + response.reason());
                if (null != response.body() && response.body().length() > 0) {
                    try (InputStreamReader reader = new InputStreamReader(response.body().asInputStream(), StandardCharsets.UTF_8);){
                        this.logger.trace(IOUtils.toString((Reader)reader));
                    }
                    catch (IOException e) {
                        this.logger.trace((Throwable)e);
                    }
                }
                return new RetryableException(response.status(), response.reason(), response.request().httpMethod(), (Long)null, response.request());
            }
            return new NexusAPIException(response.status(), response.reason(), response.headers());
        }
    }

    static interface NexusOperation {
        public void execute() throws Nexus2Exception;
    }

    static class NotXml
    extends IOException {
        private static final long serialVersionUID = -6458245950020411953L;

        NotXml() {
        }
    }

    static class XmlDecoder
    implements Decoder {
        private final XmlMapper mapper;

        public XmlDecoder() {
            this(new XmlMapper());
        }

        public XmlDecoder(XmlMapper mapper) {
            this.mapper = mapper;
        }

        public Object decode(Response response, Type type) throws IOException {
            if (null == response.body()) {
                throw new NotXml();
            }
            Collection value = (Collection)response.headers().get("Content-Type");
            if (null == value || value.size() != 1) {
                throw new NotXml();
            }
            String contentType = (String)value.iterator().next();
            if (!contentType.contains("application/xml")) {
                throw new NotXml();
            }
            Reader reader = response.body().asReader(Util.UTF_8);
            if (!reader.markSupported()) {
                reader = new BufferedReader(reader, 1);
            }
            try {
                reader.mark(1);
                if (reader.read() == -1) {
                    return null;
                }
                reader.reset();
                return this.mapper.readValue(reader, this.mapper.constructType(type));
            }
            catch (RuntimeJsonMappingException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }
    }
}

