/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.upload;

import java.util.Map;
import org.jreleaser.model.api.upload.Uploader;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.upload.AbstractUploader;
import org.jreleaser.util.StringUtils;

public abstract class AbstractGitPackageUploader<A extends Uploader, S extends AbstractGitPackageUploader<A, S>>
extends AbstractUploader<A, S> {
    private static final long serialVersionUID = -9172635937307460363L;
    private String host;
    private String token;
    private String packageName;
    private String packageVersion;

    protected AbstractGitPackageUploader(String type) {
        super(type);
    }

    @Override
    public void merge(S source) {
        super.merge(source);
        this.host = this.merge(this.host, ((AbstractGitPackageUploader)source).getHost());
        this.token = this.merge(this.token, ((AbstractGitPackageUploader)source).getToken());
        this.packageName = this.merge(this.packageName, ((AbstractGitPackageUploader)source).getPackageName());
        this.packageVersion = this.merge(this.packageVersion, ((AbstractGitPackageUploader)source).getPackageVersion());
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("host", this.host);
        props.put("token", StringUtils.isNotBlank((String)this.token) ? "************" : "**unset**");
        props.put("packageName", this.packageName);
        props.put("packageVersion", this.packageVersion);
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context.fullProps(), artifact);
    }

    public String getResolvedUploadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context, artifact);
    }
}

